/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.esa.snap.runtime.EngineConfig;
import org.esa.snap.runtime.InstallationScanner;

public class BundleCreator {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage:");
            System.out.println("   BundleCreator TARGET-FILE (SNAP-INSTALLATION-DIR | SNAP-ENGINE-DIR [SNAP-TOOLBOXES-DIR]...)");
            System.exit(-1);
        }
        String targetFile = args[0];
        String arg2 = args[1];
        boolean isInstalledSnap = BundleCreator.detectMode(arg2);
        if (isInstalledSnap) {
            BundleCreator.createBundleFromInstalledSnap(arg2, targetFile);
        } else {
            BundleCreator.createBundleFromBuiltSnap(args, targetFile);
        }
    }

    private static void createBundleFromInstalledSnap(String installationDir, String targetFile) {
        Path nbUserDir;
        if (!((String)targetFile).endsWith("zip")) {
            targetFile = (String)targetFile + ".zip";
        }
        EngineConfig config = EngineConfig.instance();
        Logger logger = config.logger();
        logger.info("Creating assembly file " + (String)targetFile + " for SNAP installation '" + installationDir + "'...");
        Path installationPath = Paths.get(installationDir, new String[0]);
        config.installDir(installationPath);
        InstallationScanner.ScanResult scanResult = new InstallationScanner(config).scanInstallationDir();
        List<Path> classPathEntries = scanResult.classPathEntries;
        List<Path> libraryPathEntries = scanResult.libraryPathEntries;
        if (classPathEntries.isEmpty() && libraryPathEntries.isEmpty()) {
            logger.warning("Nothing found in directory '" + installationDir + "'. Please make sure a valid SNAP installation is provided.");
            System.exit(0);
        }
        if (!Files.isDirectory(nbUserDir = config.userDir().resolve("system"), new LinkOption[0])) {
            nbUserDir = Paths.get(System.getProperty("user.home"), new String[0]).resolve("AppData").resolve("Roaming").resolve("SNAP");
        }
        URI zipUri = BundleCreator.createZipUri((String)targetFile);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try (FileSystem zipfs = FileSystems.newFileSystem(zipUri, env);){
            logger.fine("Adding classpath entries to zip...");
            for (Path classPathEntry : classPathEntries) {
                if (!classPathEntry.startsWith(installationPath) && !classPathEntry.startsWith(nbUserDir)) {
                    logger.warning("Invalid classpath entry: '" + classPathEntry.toString());
                    continue;
                }
                String targetFilename = BundleCreator.getTargetFilename(classPathEntry.getParent().toString(), classPathEntry);
                targetFilename = targetFilename.replace(File.separator, "_");
                Files.copy(classPathEntry, zipfs.getPath(File.separator + targetFilename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                logger.fine("Added '" + classPathEntry.toString() + "'");
            }
            logger.fine("done. Adding shared objects entries to zip...");
            for (Path libraryPathEntry : libraryPathEntries) {
                Files.newDirectoryStream(libraryPathEntry).forEach(path -> {
                    if (Files.isRegularFile(path, new LinkOption[0])) {
                        String targetFilename = path.toString().substring(path.toString().lastIndexOf(File.separator) + 1);
                        try {
                            Files.copy(path, zipfs.getPath("/" + targetFilename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("...done.");
    }

    private static void createBundleFromBuiltSnap(String[] args, String targetFile) throws IOException {
        EngineConfig config = EngineConfig.instance();
        Logger logger = config.logger();
        logger.info("Creating assembly file " + targetFile + " for SNAP sources at '" + args[1] + "'...");
        JarVisitor jarVisitor = new JarVisitor();
        SoVisitor soVisitor = new SoVisitor();
        for (int i = 1; i < args.length; ++i) {
            String inputDir = args[i];
            Files.walkFileTree(Paths.get(inputDir, new String[0]), jarVisitor);
            Files.walkFileTree(Paths.get(inputDir, new String[0]), soVisitor);
        }
        ArrayList<Path> classPathEntries = new ArrayList<Path>(jarVisitor.resultFiles);
        ArrayList<Path> libraryPathEntries = new ArrayList<Path>(soVisitor.resultFiles);
        URI zipUri = BundleCreator.createZipUri(targetFile);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try (FileSystem zipfs = FileSystems.newFileSystem(zipUri, env);){
            logger.fine("Adding classpath entries to zip...");
            BundleCreator.addEntriesToZipfile(classPathEntries, zipfs, logger);
            logger.fine("done. Adding shared objects entries to zip...");
            BundleCreator.addEntriesToZipfile(libraryPathEntries, zipfs, logger);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("...done.");
    }

    private static URI createZipUri(String targetFile) {
        URI zipUri;
        Path zipfile = Paths.get(targetFile, new String[0]);
        URI fileUri = zipfile.toUri();
        try {
            zipUri = new URI("jar:" + fileUri.getScheme(), fileUri.getRawPath(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return zipUri;
    }

    private static void addEntriesToZipfile(List<Path> libraryPathEntries, FileSystem zipfs, Logger logger) throws IOException {
        for (Path libraryPathEntry : libraryPathEntries) {
            String targetFilename = BundleCreator.getTargetFilename(libraryPathEntry.getParent().toString(), libraryPathEntry);
            targetFilename = targetFilename.replace(File.separator, "_");
            Files.copy(libraryPathEntry, zipfs.getPath(File.separator + targetFilename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            logger.fine("Added '" + libraryPathEntry.toString() + "'");
        }
    }

    private static boolean detectMode(String arg2) {
        Path maybeInstallationDir = Paths.get(arg2, new String[0]);
        Path binPath = maybeInstallationDir.resolve("bin");
        boolean windowsExecutableExists = Files.exists(binPath.resolve("gpt.exe"), new LinkOption[0]);
        boolean linuxExecutableExists = Files.exists(binPath.resolve("gpt"), new LinkOption[0]);
        boolean macExecutableExists = Files.exists(binPath.resolve("gpt.command"), new LinkOption[0]);
        return windowsExecutableExists || linuxExecutableExists || macExecutableExists;
    }

    private static String getTargetFilename(String directory, Path classPathEntry) {
        return classPathEntry.toString().substring(classPathEntry.toString().indexOf(directory) + directory.length() + 1);
    }

    private static class SoVisitor
    extends SimpleFileVisitor<Path> {
        List<Path> resultFiles = new ArrayList<Path>();

        SoVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            boolean isSharedObject = file.toString().endsWith(".so");
            if (isSharedObject) {
                this.resultFiles.add(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class JarVisitor
    extends SimpleFileVisitor<Path> {
        List<Path> resultFiles = new ArrayList<Path>();

        JarVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (file.toString().contains(File.separator + "target" + File.separator + "nbm" + File.separator) && file.toString().endsWith(".jar")) {
                this.resultFiles.add(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

