/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.CollectionChangeEvent;
import javax.media.jai.CollectionOp;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.PropertySourceChangeEvent;
import javax.media.jai.RegistryMode;
import javax.media.jai.RenderedOp;
import javax.media.jai.RenderingChangeEvent;
import javax.media.jai.TileCache;
import javax.media.jai.registry.RemoteRIFRegistry;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.NegotiableCapability;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.remote.RemoteDescriptor;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.RemoteJAI;
import javax.media.jai.remote.RemoteRIF;
import javax.media.jai.remote.RemoteRenderedImage;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public class RemoteRenderedOp
extends RenderedOp
implements RemoteRenderedImage {
    protected String protocolName;
    protected String serverName;
    private NegotiableCapabilitySet negotiated;
    private transient RenderingHints oldHints;
    private static Set nodeEventNames = null;

    public RemoteRenderedOp(String string, String string2, String string3, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        this(null, string, string2, string3, parameterBlock, renderingHints);
    }

    public RemoteRenderedOp(OperationRegistry operationRegistry, String string, String string2, String string3, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        super(operationRegistry, string3, parameterBlock, renderingHints);
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        this.protocolName = string;
        this.serverName = string2;
        this.addPropertyChangeListener("ServerName", this);
        this.addPropertyChangeListener("ProtocolName", this);
        this.addPropertyChangeListener("ProtocolAndServerName", this);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic2"));
        }
        if (string.equalsIgnoreCase(this.serverName)) {
            return;
        }
        String string2 = this.serverName;
        this.serverName = string;
        this.fireEvent("ServerName", string2, string);
        this.nodeSupport.resetPropertyEnvironment(false);
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public void setProtocolName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        if (string.equalsIgnoreCase(this.protocolName)) {
            return;
        }
        String string2 = this.protocolName;
        this.protocolName = string;
        this.fireEvent("ProtocolName", string2, string);
        this.nodeSupport.resetPropertyEnvironment(false);
    }

    public void setProtocolAndServerNames(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic2"));
        }
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        boolean bl = string.equalsIgnoreCase(this.protocolName);
        boolean bl2 = string2.equalsIgnoreCase(this.serverName);
        if (bl) {
            if (bl2) {
                return;
            }
            this.setServerName(string2);
            return;
        }
        if (bl2) {
            this.setProtocolName(string);
            return;
        }
        String string3 = this.protocolName;
        String string4 = this.serverName;
        this.protocolName = string;
        this.serverName = string2;
        this.fireEvent("ProtocolAndServerName", new String[]{string3, string4}, new String[]{string, string2});
        this.nodeSupport.resetPropertyEnvironment(false);
    }

    public String getRegistryModeName() {
        return RegistryMode.getMode("remoteRendered").getName();
    }

    protected synchronized PlanarImage createInstance(boolean bl) {
        Object object;
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.setParameters(this.getParameters());
        int n = this.getNumSources();
        for (int i = 0; i < n; ++i) {
            object = this.getNodeSource(i);
            Object object2 = null;
            if (object instanceof RenderedOp) {
                RenderedOp renderedOp = (RenderedOp)object;
                object2 = bl ? renderedOp.getRendering() : renderedOp.createInstance();
            } else {
                object2 = object instanceof RenderedImage || object instanceof Collection ? object : (object instanceof CollectionOp ? ((CollectionOp)object).getCollection() : object);
            }
            parameterBlock.addSource(object2);
        }
        RemoteRenderedImage remoteRenderedImage = RemoteRIFRegistry.create(this.nodeSupport.getRegistry(), this.protocolName, this.serverName, this.nodeSupport.getOperationName(), parameterBlock, this.nodeSupport.getRenderingHints());
        if (remoteRenderedImage == null) {
            throw new ImagingException(JaiI18N.getString("RemoteRenderedOp2"));
        }
        object = this.nodeSupport.getRenderingHints();
        this.oldHints = object == null ? null : (RenderingHints)((RenderingHints)object).clone();
        return PlanarImage.wrapRenderedImage(remoteRenderedImage);
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block55: {
            int n;
            int n2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7 = propertyChangeEvent.getSource();
            Vector<Object> vector = this.nodeSupport.getParameterBlock().getSources();
            String string = propertyChangeEvent.getPropertyName().toLowerCase(Locale.ENGLISH);
            if (this.theImage == null || (!(propertyChangeEvent instanceof PropertyChangeEventJAI) || object7 != this || propertyChangeEvent instanceof PropertySourceChangeEvent || !nodeEventNames.contains(string)) && (!(propertyChangeEvent instanceof RenderingChangeEvent) && !(propertyChangeEvent instanceof CollectionChangeEvent) && (!(propertyChangeEvent instanceof PropertyChangeEventJAI) || !(object7 instanceof RenderedImage) || !string.equals("invalidregion")) || !vector.contains(object7))) break block55;
            PlanarImage planarImage = this.theImage;
            boolean bl = false;
            Object object8 = null;
            if (object7 == this && (string.equals("operationregistry") || string.equals("protocolname") || string.equals("protocolandservername"))) {
                bl = true;
                this.theImage = null;
            } else if (propertyChangeEvent instanceof RenderingChangeEvent || object7 instanceof RenderedImage && string.equals("invalidregion")) {
                bl = true;
                object6 = null;
                if (propertyChangeEvent instanceof RenderingChangeEvent) {
                    object5 = (RenderingChangeEvent)propertyChangeEvent;
                    object6 = ((RenderingChangeEvent)object5).getInvalidRegion();
                    if (object6 == null) {
                        object6 = ((PlanarImage)((PropertyChangeEvent)object5).getOldValue()).getBounds();
                    }
                } else {
                    object6 = (Shape)propertyChangeEvent.getNewValue();
                    if (object6 == null) {
                        object5 = (RenderedImage)object7;
                        object6 = new Rectangle(object5.getMinX(), object5.getMinY(), object5.getWidth(), object5.getHeight());
                    }
                }
                if (!(this.theImage instanceof PlanarImageServerProxy)) {
                    this.theImage = null;
                } else {
                    Cloneable cloneable;
                    int n3;
                    Object object9;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    object5 = (PlanarImageServerProxy)this.theImage;
                    object4 = object6.getBounds();
                    if (((Rectangle)object4).isEmpty() && !((Rectangle)(object3 = new Rectangle(n7 = ((PlanarImage)object5).tileXToX(((PlanarImage)object5).getMinTileX()), n6 = ((PlanarImage)object5).tileYToY(((PlanarImage)object5).getMinTileY()), n5 = ((PlanarImage)object5).getNumXTiles() * ((PlanarImageServerProxy)object5).getTileWidth(), n4 = ((PlanarImage)object5).getNumYTiles() * ((PlanarImageServerProxy)object5).getTileHeight()))).equals(object2 = ((PlanarImage)object5).getBounds())) {
                        object9 = new Area((Shape)object3);
                        object9.subtract(new Area((Shape)object2));
                        object6 = object9;
                        object4 = object6.getBounds();
                    }
                    n7 = 0;
                    ArrayList<Object> arrayList = null;
                    if (((Rectangle)object4).isEmpty()) {
                        object8 = object6;
                        n7 = 1;
                    } else {
                        n5 = vector.indexOf(object7);
                        Rectangle rectangle = ((PlanarImageServerProxy)object5).mapSourceRect((Rectangle)object4, n5);
                        if (rectangle == null) {
                            rectangle = ((PlanarImage)object5).getBounds();
                        }
                        int n8 = (object3 = this.getTileIndices(rectangle)) != null ? ((Point[])object3).length : 0;
                        object9 = null;
                        for (n3 = 0; n3 < n8; ++n3) {
                            if (n3 % 1000 == 0 && object9 != null) {
                                object9 = new GeneralPath(new Area((Shape)object9));
                            }
                            if ((object = ((PlanarImageServerProxy)object5).mapDestRect((Rectangle)(cloneable = this.getTileRect(((Point)object3[n3]).x, ((Point)object3[n3]).y)), n5)) == null) {
                                object9 = null;
                                break;
                            }
                            if (object6.intersects((Rectangle2D)object)) {
                                if (object9 == null) {
                                    object9 = new GeneralPath((Shape)((Object)cloneable));
                                    continue;
                                }
                                object9.append((Shape)((Object)cloneable), false);
                                continue;
                            }
                            if (arrayList == null) {
                                arrayList = new ArrayList<Object>();
                            }
                            arrayList.add(object3[n3]);
                        }
                        object8 = object9 == null ? null : new Area((Shape)object9);
                    }
                    TileCache tileCache = ((PlanarImageServerProxy)object5).getTileCache();
                    this.theImage = null;
                    if (tileCache != null && (n7 != 0 || arrayList != null)) {
                        this.newEventRendering(this.protocolName, (PlanarImageServerProxy)object5, (PropertyChangeEventJAI)propertyChangeEvent);
                        if (this.theImage instanceof PlanarImageServerProxy && ((PlanarImageServerProxy)this.theImage).getTileCache() != null) {
                            PlanarImageServerProxy planarImageServerProxy = (PlanarImageServerProxy)this.theImage;
                            object3 = planarImageServerProxy.getTileCache();
                            object2 = planarImageServerProxy.getTileCacheMetric();
                            if (n7 != 0) {
                                object9 = tileCache.getTiles((RenderedImage)object5);
                                n3 = object9 == null ? 0 : ((Raster[])object9).length;
                                for (int i = 0; i < n3; ++i) {
                                    object = object9[i];
                                    n2 = planarImageServerProxy.XToTileX(object.getMinX());
                                    n = planarImageServerProxy.YToTileY(object.getMinY());
                                    object3.add(planarImageServerProxy, n2, n, (Raster)object, object2);
                                }
                            } else {
                                int n9 = arrayList.size();
                                for (n3 = 0; n3 < n9; ++n3) {
                                    cloneable = (Point)arrayList.get(n3);
                                    object = tileCache.getTile((RenderedImage)object5, ((Point)cloneable).x, ((Point)cloneable).y);
                                    if (object == null) continue;
                                    object3.add(planarImageServerProxy, ((Point)cloneable).x, ((Point)cloneable).y, (Raster)object, object2);
                                }
                            }
                        }
                    }
                }
            } else {
                Object object10;
                object6 = null;
                object5 = null;
                object4 = this.serverName;
                String string2 = this.serverName;
                boolean bl2 = false;
                if (string.equals("operationname")) {
                    if (this.theImage instanceof PlanarImageServerProxy) {
                        this.newEventRendering(this.protocolName, (PlanarImageServerProxy)this.theImage, (PropertyChangeEventJAI)propertyChangeEvent);
                    } else {
                        this.theImage = null;
                        this.createRendering();
                    }
                    bl = true;
                } else if (string.equals("parameterblock")) {
                    object6 = (ParameterBlock)propertyChangeEvent.getOldValue();
                    object5 = (ParameterBlock)propertyChangeEvent.getNewValue();
                    bl2 = true;
                } else if (string.equals("sources")) {
                    Vector<Object> vector2 = this.nodeSupport.getParameterBlock().getParameters();
                    object6 = new ParameterBlock((Vector)propertyChangeEvent.getOldValue(), vector2);
                    object5 = new ParameterBlock((Vector)propertyChangeEvent.getNewValue(), vector2);
                    bl2 = true;
                } else if (string.equals("parameters")) {
                    object6 = new ParameterBlock(vector, (Vector)propertyChangeEvent.getOldValue());
                    object5 = new ParameterBlock(vector, (Vector)propertyChangeEvent.getNewValue());
                    bl2 = true;
                } else if (string.equals("renderinghints")) {
                    object6 = object5 = this.nodeSupport.getParameterBlock();
                    bl2 = true;
                } else if (string.equals("servername")) {
                    object6 = object5 = this.nodeSupport.getParameterBlock();
                    object4 = (String)propertyChangeEvent.getOldValue();
                    string2 = (String)propertyChangeEvent.getNewValue();
                    bl2 = true;
                } else if (propertyChangeEvent instanceof CollectionChangeEvent) {
                    int n10 = vector.indexOf(object7);
                    object10 = (Vector)vector.clone();
                    object3 = (Vector)vector.clone();
                    ((Vector)object10).set(n10, propertyChangeEvent.getOldValue());
                    ((Vector)object3).set(n10, propertyChangeEvent.getNewValue());
                    object2 = this.nodeSupport.getParameterBlock().getParameters();
                    object6 = new ParameterBlock((Vector<Object>)object10, (Vector<Object>)object2);
                    object5 = new ParameterBlock((Vector<Object>)object3, (Vector<Object>)object2);
                    bl2 = true;
                }
                if (bl2) {
                    bl = true;
                    OperationRegistry operationRegistry = this.nodeSupport.getRegistry();
                    object10 = (RemoteDescriptor)operationRegistry.getDescriptor(RemoteDescriptor.class, this.protocolName);
                    object8 = (Shape)object10.getInvalidRegion("rendered", (String)object4, (ParameterBlock)(object6 = ImageUtil.evaluateParameters((ParameterBlock)object6)), this.oldHints, string2, (ParameterBlock)(object5 = ImageUtil.evaluateParameters((ParameterBlock)object5)), this.nodeSupport.getRenderingHints(), this);
                    if (object8 == null || !(this.theImage instanceof PlanarImageServerProxy)) {
                        this.theImage = null;
                    } else {
                        object3 = (PlanarImageServerProxy)this.theImage;
                        this.newEventRendering(this.protocolName, (PlanarImageServerProxy)object3, (PropertyChangeEventJAI)propertyChangeEvent);
                        if (this.theImage instanceof PlanarImageServerProxy && ((PlanarImageServerProxy)object3).getTileCache() != null && ((PlanarImageServerProxy)this.theImage).getTileCache() != null) {
                            Rectangle rectangle;
                            int n11;
                            int n12;
                            Rectangle rectangle2;
                            object2 = (PlanarImageServerProxy)this.theImage;
                            TileCache tileCache = ((PlanarImageServerProxy)object3).getTileCache();
                            TileCache tileCache2 = ((PlanarImageServerProxy)object2).getTileCache();
                            Object object11 = ((PlanarImageServerProxy)object2).getTileCacheMetric();
                            if (object8.getBounds().isEmpty() && !(rectangle2 = new Rectangle(n12 = ((PlanarImage)object3).tileXToX(((PlanarImage)object3).getMinTileX()), n2 = ((PlanarImage)object3).tileYToY(((PlanarImage)object3).getMinTileY()), n = ((PlanarImage)object3).getNumXTiles() * ((PlanarImageServerProxy)object3).getTileWidth(), n11 = ((PlanarImage)object3).getNumYTiles() * ((PlanarImageServerProxy)object3).getTileHeight())).equals(rectangle = ((PlanarImage)object3).getBounds())) {
                                Area area = new Area(rectangle2);
                                area.subtract(new Area(rectangle));
                                object8 = area;
                            }
                            if (object8.getBounds().isEmpty()) {
                                object = tileCache.getTiles((RenderedImage)object3);
                                n2 = object == null ? 0 : ((Raster[])object).length;
                                for (n = 0; n < n2; ++n) {
                                    Raster raster = object[n];
                                    int n13 = ((PlanarImage)object2).XToTileX(raster.getMinX());
                                    int n14 = ((PlanarImage)object2).YToTileY(raster.getMinY());
                                    tileCache2.add((RenderedImage)object2, n13, n14, raster, object11);
                                }
                            } else {
                                object = tileCache.getTiles((RenderedImage)object3);
                                n2 = object == null ? 0 : ((Raster[])object).length;
                                for (n = 0; n < n2; ++n) {
                                    Raster raster = object[n];
                                    rectangle2 = raster.getBounds();
                                    if (object8.intersects(rectangle2)) continue;
                                    tileCache2.add((RenderedImage)object2, ((PlanarImage)object2).XToTileX(rectangle2.x), ((PlanarImage)object2).YToTileY(rectangle2.y), raster, object11);
                                }
                            }
                        }
                    }
                }
            }
            if (planarImage instanceof PlanarImageServerProxy && this.theImage == null) {
                this.newEventRendering(this.protocolName, (PlanarImageServerProxy)planarImage, (PropertyChangeEventJAI)propertyChangeEvent);
            } else {
                this.createRendering();
            }
            if (bl) {
                this.resetProperties(true);
                object6 = new RenderingChangeEvent(this, planarImage, this.theImage, (Shape)object8);
                this.eventManager.firePropertyChange((PropertyChangeEvent)object6);
                object5 = this.getSinks();
                if (object5 != null) {
                    int n15 = ((Vector)object5).size();
                    for (int i = 0; i < n15; ++i) {
                        Object e = ((Vector)object5).get(i);
                        if (!(e instanceof PropertyChangeListener)) continue;
                        ((PropertyChangeListener)e).propertyChange((PropertyChangeEvent)object6);
                    }
                }
            }
        }
    }

    private void newEventRendering(String string, PlanarImageServerProxy planarImageServerProxy, PropertyChangeEventJAI propertyChangeEventJAI) {
        RemoteRIF remoteRIF = (RemoteRIF)this.nodeSupport.getRegistry().getFactory("remoterendered", string);
        this.theImage = (PlanarImage)((Object)remoteRIF.create(planarImageServerProxy, this, propertyChangeEventJAI));
    }

    private void fireEvent(String string, Object object, Object object2) {
        if (this.eventManager != null) {
            Object object3 = this.eventManager.getPropertyChangeEventSource();
            PropertyChangeEventJAI propertyChangeEventJAI = new PropertyChangeEventJAI(object3, string, object, object2);
            this.eventManager.firePropertyChange(propertyChangeEventJAI);
        }
    }

    public int getRetryInterval() {
        if (this.theImage != null) {
            return ((RemoteRenderedImage)((Object)this.theImage)).getRetryInterval();
        }
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints == null) {
            return 1000;
        }
        Integer n = (Integer)renderingHints.get(JAI.KEY_RETRY_INTERVAL);
        if (n == null) {
            return 1000;
        }
        return n;
    }

    public void setRetryInterval(int n) {
        RenderingHints renderingHints;
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
        }
        if (this.theImage != null) {
            ((RemoteRenderedImage)((Object)this.theImage)).setRetryInterval(n);
        }
        if ((renderingHints = this.nodeSupport.getRenderingHints()) == null) {
            this.nodeSupport.setRenderingHints(new RenderingHints(null));
            renderingHints = this.nodeSupport.getRenderingHints();
        }
        renderingHints.put(JAI.KEY_RETRY_INTERVAL, new Integer(n));
    }

    public int getNumRetries() {
        if (this.theImage != null) {
            return ((RemoteRenderedImage)((Object)this.theImage)).getNumRetries();
        }
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints == null) {
            return 5;
        }
        Integer n = (Integer)renderingHints.get(JAI.KEY_NUM_RETRIES);
        if (n == null) {
            return 5;
        }
        return n;
    }

    public void setNumRetries(int n) {
        RenderingHints renderingHints;
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic4"));
        }
        if (this.theImage != null) {
            ((RemoteRenderedImage)((Object)this.theImage)).setNumRetries(n);
        }
        if ((renderingHints = this.nodeSupport.getRenderingHints()) == null) {
            this.nodeSupport.setRenderingHints(new RenderingHints(null));
            renderingHints = this.nodeSupport.getRenderingHints();
        }
        renderingHints.put(JAI.KEY_NUM_RETRIES, new Integer(n));
    }

    public void setNegotiationPreferences(NegotiableCapabilitySet negotiableCapabilitySet) {
        if (this.theImage != null) {
            ((RemoteRenderedImage)((Object)this.theImage)).setNegotiationPreferences(negotiableCapabilitySet);
        }
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (negotiableCapabilitySet != null) {
            if (renderingHints == null) {
                this.nodeSupport.setRenderingHints(new RenderingHints(null));
                renderingHints = this.nodeSupport.getRenderingHints();
            }
            renderingHints.put(JAI.KEY_NEGOTIATION_PREFERENCES, negotiableCapabilitySet);
        } else if (renderingHints != null) {
            renderingHints.remove(JAI.KEY_NEGOTIATION_PREFERENCES);
        }
        this.negotiated = this.negotiate(negotiableCapabilitySet);
    }

    public NegotiableCapabilitySet getNegotiationPreferences() {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        return renderingHints == null ? null : (NegotiableCapabilitySet)renderingHints.get(JAI.KEY_NEGOTIATION_PREFERENCES);
    }

    private NegotiableCapabilitySet negotiate(NegotiableCapabilitySet negotiableCapabilitySet) {
        OperationRegistry operationRegistry = this.nodeSupport.getRegistry();
        NegotiableCapabilitySet negotiableCapabilitySet2 = null;
        RemoteDescriptor remoteDescriptor = (RemoteDescriptor)operationRegistry.getDescriptor(RemoteDescriptor.class, this.protocolName);
        if (remoteDescriptor == null) {
            Object[] objectArray = new Object[]{new String(this.protocolName)};
            MessageFormat messageFormat = new MessageFormat("");
            messageFormat.setLocale(Locale.getDefault());
            messageFormat.applyPattern(JaiI18N.getString("RemoteJAI16"));
            throw new ImagingException(messageFormat.format(objectArray));
        }
        int n = 0;
        int n2 = this.getNumRetries();
        int n3 = this.getRetryInterval();
        RemoteImagingException remoteImagingException = null;
        while (n++ < n2) {
            try {
                negotiableCapabilitySet2 = remoteDescriptor.getServerCapabilities(this.serverName);
                break;
            }
            catch (RemoteImagingException remoteImagingException2) {
                System.err.println(JaiI18N.getString("RemoteJAI24"));
                remoteImagingException = remoteImagingException2;
                try {
                    Thread.sleep(n3);
                }
                catch (InterruptedException interruptedException) {
                    this.sendExceptionToListener(JaiI18N.getString("Generic5"), new ImagingException(JaiI18N.getString("Generic5"), interruptedException));
                }
            }
        }
        if (negotiableCapabilitySet2 == null && n > n2) {
            this.sendExceptionToListener(JaiI18N.getString("RemoteJAI18"), remoteImagingException);
        }
        RemoteRIF remoteRIF = (RemoteRIF)operationRegistry.getFactory("remoteRendered", this.protocolName);
        return RemoteJAI.negotiate(negotiableCapabilitySet, negotiableCapabilitySet2, remoteRIF.getClientCapabilities());
    }

    public NegotiableCapabilitySet getNegotiatedValues() throws RemoteImagingException {
        if (this.theImage != null) {
            return ((RemoteRenderedImage)((Object)this.theImage)).getNegotiatedValues();
        }
        return this.negotiated;
    }

    public NegotiableCapability getNegotiatedValue(String string) throws RemoteImagingException {
        if (this.theImage != null) {
            return ((RemoteRenderedImage)((Object)this.theImage)).getNegotiatedValue(string);
        }
        return this.negotiated == null ? null : this.negotiated.getNegotiatedValue(string);
    }

    public void setServerNegotiatedValues(NegotiableCapabilitySet negotiableCapabilitySet) throws RemoteImagingException {
        if (this.theImage != null) {
            ((RemoteRenderedImage)((Object)this.theImage)).setServerNegotiatedValues(negotiableCapabilitySet);
        }
    }

    void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = (ImagingListener)this.getRenderingHints().get(JAI.KEY_IMAGING_LISTENER);
        imagingListener.errorOccurred(string, exception, this, false);
    }

    static {
        nodeEventNames = new HashSet();
        nodeEventNames.add("protocolname");
        nodeEventNames.add("servername");
        nodeEventNames.add("protocolandservername");
        nodeEventNames.add("operationname");
        nodeEventNames.add("operationregistry");
        nodeEventNames.add("parameterblock");
        nodeEventNames.add("sources");
        nodeEventNames.add("parameters");
        nodeEventNames.add("renderinghints");
    }
}

