/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.rmi.RMIImage;
import com.sun.media.jai.rmi.RMIImageImpl;
import com.sun.media.jai.rmi.RasterProxy;
import com.sun.media.jai.rmi.RenderContextProxy;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;

public class RemoteImage
extends PlanarImage {
    static final int DEFAULT_TIMEOUT = 1000;
    static final int DEFAULT_NUM_RETRIES = 5;
    static final int VAR_MIN_X = 0;
    static final int VAR_MIN_Y = 1;
    static final int VAR_WIDTH = 2;
    static final int VAR_HEIGHT = 3;
    static final int VAR_TILE_WIDTH = 4;
    static final int VAR_TILE_HEIGHT = 5;
    static final int VAR_TILE_GRID_X_OFFSET = 6;
    static final int VAR_TILE_GRID_Y_OFFSET = 7;
    static final int VAR_SAMPLE_MODEL = 8;
    static final int VAR_COLOR_MODEL = 9;
    static final int VAR_SOURCES = 10;
    static final int NUM_VARS = 11;
    private static final Class NULL_PROPERTY_CLASS = RMIImageImpl.NULL_PROPERTY.getClass();
    protected RMIImage remoteImage;
    private Long id = null;
    protected boolean[] fieldValid = new boolean[11];
    protected String[] propertyNames = null;
    protected int timeout = 1000;
    protected int numRetries = 5;
    private Rectangle imageBounds = null;

    private static Vector vectorize(RenderedImage renderedImage) {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.add(renderedImage);
        return vector;
    }

    public RemoteImage(String string, RenderedImage renderedImage) {
        super(null, null, null);
        int n;
        boolean bl;
        if (string == null) {
            string = this.getLocalHostAddress();
        }
        boolean bl2 = bl = (n = string.indexOf("::")) != -1;
        if (!bl && renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage1"));
        }
        if (bl) {
            this.id = Long.valueOf(string.substring(n + 2));
            string = string.substring(0, n);
        }
        this.getRMIImage(string);
        if (!bl) {
            this.getRMIID();
        }
        this.setRMIProperties(string);
        if (renderedImage != null) {
            try {
                if (renderedImage instanceof Serializable) {
                    this.remoteImage.setSource(this.id, renderedImage);
                } else {
                    this.remoteImage.setSource(this.id, new SerializableRenderedImage(renderedImage));
                }
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException.getMessage());
            }
        }
    }

    public RemoteImage(String string, RenderedOp renderedOp) {
        super(null, null, null);
        if (string == null) {
            string = this.getLocalHostAddress();
        }
        if (renderedOp == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage1"));
        }
        this.getRMIImage(string);
        this.getRMIID();
        this.setRMIProperties(string);
        try {
            this.remoteImage.setSource(this.id, renderedOp);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException.getMessage());
        }
    }

    public RemoteImage(String string, RenderableOp renderableOp, RenderContext renderContext) {
        super(null, null, null);
        if (string == null) {
            string = this.getLocalHostAddress();
        }
        if (renderableOp == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage1"));
        }
        if (renderContext == null) {
            renderContext = new RenderContext(new AffineTransform());
        }
        this.getRMIImage(string);
        this.getRMIID();
        this.setRMIProperties(string);
        RenderContextProxy renderContextProxy = new RenderContextProxy(renderContext);
        try {
            this.remoteImage.setSource(this.id, renderableOp, renderContextProxy);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new RuntimeException(remoteException.getMessage());
        }
    }

    private void getRMIImage(String string) {
        if (string == null) {
            string = this.getLocalHostAddress();
        }
        String string2 = new String("rmi://" + string + "/" + "RemoteImageServer");
        this.remoteImage = null;
        try {
            this.remoteImage = (RMIImage)Naming.lookup(string2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private String getLocalHostAddress() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return string;
    }

    private void getRMIID() {
        try {
            this.id = this.remoteImage.getRemoteID();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void setRMIProperties(String string) {
        this.setProperty(this.getClass().getName() + ".serverName", string);
        this.setProperty(this.getClass().getName() + ".id", this.id);
    }

    protected void finalize() {
        try {
            this.remoteImage.dispose(this.id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTimeout(int n) {
        if (n > 0) {
            this.timeout = n;
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setNumRetries(int n) {
        if (n > 0) {
            this.numRetries = n;
        }
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    protected void requestField(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage3"));
        }
        if (n3 < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage4"));
        }
        int n4 = 0;
        if (this.fieldValid[n]) {
            return;
        }
        while (n4++ < n2) {
            try {
                switch (n) {
                    case 0: {
                        this.minX = this.remoteImage.getMinX(this.id);
                        break;
                    }
                    case 1: {
                        this.minY = this.remoteImage.getMinY(this.id);
                        break;
                    }
                    case 2: {
                        this.width = this.remoteImage.getWidth(this.id);
                        break;
                    }
                    case 3: {
                        this.height = this.remoteImage.getHeight(this.id);
                        break;
                    }
                    case 4: {
                        this.tileWidth = this.remoteImage.getTileWidth(this.id);
                        break;
                    }
                    case 5: {
                        this.tileHeight = this.remoteImage.getTileHeight(this.id);
                        break;
                    }
                    case 6: {
                        this.tileGridXOffset = this.remoteImage.getTileGridXOffset(this.id);
                        break;
                    }
                    case 7: {
                        this.tileGridYOffset = this.remoteImage.getTileGridYOffset(this.id);
                        break;
                    }
                    case 8: {
                        this.sampleModel = this.remoteImage.getSampleModel(this.id).getSampleModel();
                        break;
                    }
                    case 9: {
                        this.colorModel = this.remoteImage.getColorModel(this.id).getColorModel();
                        break;
                    }
                    case 10: {
                        Vector vector = this.remoteImage.getSources(this.id);
                        int n5 = vector.size();
                        for (int i = 0; i < n5; ++i) {
                            RenderedImage renderedImage = (RenderedImage)vector.get(i);
                            this.addSource(PlanarImage.wrapRenderedImage(renderedImage));
                        }
                        break;
                    }
                }
                this.fieldValid[n] = true;
                return;
            }
            catch (RemoteException remoteException) {
                System.err.println(JaiI18N.getString("RemoteImage0"));
                try {
                    Thread.sleep(n3);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void requestField(int n) {
        this.requestField(n, this.numRetries, this.timeout);
    }

    public int getMinX() {
        this.requestField(0);
        return this.minX;
    }

    public int getMaxX() {
        this.requestField(0);
        this.requestField(2);
        return this.minX + this.width;
    }

    public int getMinY() {
        this.requestField(1);
        return this.minY;
    }

    public int getMaxY() {
        this.requestField(1);
        this.requestField(3);
        return this.minY + this.height;
    }

    public int getWidth() {
        this.requestField(2);
        return this.width;
    }

    public int getHeight() {
        this.requestField(3);
        return this.height;
    }

    public int getTileWidth() {
        this.requestField(4);
        return this.tileWidth;
    }

    public int getTileHeight() {
        this.requestField(5);
        return this.tileHeight;
    }

    public int getTileGridXOffset() {
        this.requestField(6);
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        this.requestField(7);
        return this.tileGridYOffset;
    }

    public SampleModel getSampleModel() {
        this.requestField(8);
        return this.sampleModel;
    }

    public ColorModel getColorModel() {
        this.requestField(9);
        return this.colorModel;
    }

    public Vector getSources() {
        this.requestField(10);
        return super.getSources();
    }

    public Object getProperty(String string) {
        Object object = super.getProperty(string);
        if (object == null || object == Image.UndefinedProperty) {
            int n = 0;
            while (n++ < this.numRetries) {
                try {
                    object = this.remoteImage.getProperty(this.id, string);
                    if (!NULL_PROPERTY_CLASS.isInstance(object)) break;
                    object = Image.UndefinedProperty;
                    break;
                }
                catch (RemoteException remoteException) {
                    try {
                        Thread.sleep(this.timeout);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (object == null) {
                object = Image.UndefinedProperty;
            }
            if (object != Image.UndefinedProperty) {
                this.setProperty(string, object);
            }
        }
        return object;
    }

    public String[] getPropertyNames() {
        int n;
        String[] stringArray = super.getPropertyNames();
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                vector.add(stringArray[n]);
            }
        }
        n = 0;
        String[] stringArray2 = null;
        while (n++ < this.numRetries) {
            try {
                stringArray2 = this.remoteImage.getPropertyNames(this.id);
                break;
            }
            catch (RemoteException remoteException) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (vector.contains(stringArray2[i])) continue;
                vector.add(stringArray2[i]);
            }
        }
        this.propertyNames = vector.size() == 0 ? null : vector.toArray(new String[vector.size()]);
        return this.propertyNames;
    }

    public Raster getTile(int n, int n2) {
        int n3 = 0;
        while (n3++ < this.numRetries) {
            try {
                RasterProxy rasterProxy = this.remoteImage.getTile(this.id, n, n2);
                return rasterProxy.getRaster();
            }
            catch (RemoteException remoteException) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return null;
    }

    public Raster getData() {
        int n = 0;
        while (n++ < this.numRetries) {
            try {
                RasterProxy rasterProxy = this.remoteImage.getData(this.id);
                return rasterProxy.getRaster();
            }
            catch (RemoteException remoteException) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return null;
    }

    public Raster getData(Rectangle rectangle) {
        if (this.imageBounds == null) {
            this.imageBounds = this.getBounds();
        }
        if (rectangle == null) {
            rectangle = this.imageBounds;
        } else if (!rectangle.intersects(this.imageBounds)) {
            throw new IllegalArgumentException(JaiI18N.getString("RemoteImage2"));
        }
        int n = 0;
        while (n++ < this.numRetries) {
            try {
                RasterProxy rasterProxy = this.remoteImage.getData(this.id, rectangle);
                return rasterProxy.getRaster();
            }
            catch (RemoteException remoteException) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return null;
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        Rectangle rectangle;
        int n = 0;
        Rectangle rectangle2 = rectangle = writableRaster == null ? new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight()) : writableRaster.getBounds();
        while (n++ < this.numRetries) {
            try {
                RasterProxy rasterProxy = this.remoteImage.copyData(this.id, rectangle);
                try {
                    if (writableRaster == null) {
                        writableRaster = (WritableRaster)rasterProxy.getRaster();
                        break;
                    }
                    writableRaster.setDataElements(rectangle.x, rectangle.y, rasterProxy.getRaster());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    writableRaster = null;
                }
                break;
            }
            catch (RemoteException remoteException) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return writableRaster;
    }
}

