/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public abstract class PointOpImage
extends OpImage {
    private boolean isDisposed = false;
    private boolean areFieldsInitialized = false;
    private boolean checkInPlaceOperation = false;
    private boolean isInPlaceEnabled = false;
    private WritableRenderedImage source0AsWritableRenderedImage;
    private OpImage source0AsOpImage;
    private boolean source0IsWritableRenderedImage;
    private boolean sameBounds;
    private boolean sameTileGrid;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, Vector vector, Map map) {
        Object object;
        int n = vector.size();
        if (n < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic5"));
        }
        RenderedImage renderedImage = (RenderedImage)vector.get(0);
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = new Rectangle();
        for (int i = 1; i < n; ++i) {
            object = (RenderedImage)vector.get(i);
            rectangle2.setBounds(object.getMinX(), object.getMinY(), object.getWidth(), object.getHeight());
            rectangle = rectangle.intersection(rectangle2);
        }
        if (rectangle.isEmpty()) {
            throw new IllegalArgumentException(JaiI18N.getString("PointOpImage0"));
        }
        if (imageLayout == null) {
            imageLayout = new ImageLayout(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            Rectangle rectangle3;
            if (!(imageLayout = (ImageLayout)imageLayout.clone()).isValid(1)) {
                imageLayout.setMinX(rectangle.x);
            }
            if (!imageLayout.isValid(2)) {
                imageLayout.setMinY(rectangle.y);
            }
            if (!imageLayout.isValid(4)) {
                imageLayout.setWidth(rectangle.width);
            }
            if (!imageLayout.isValid(8)) {
                imageLayout.setHeight(rectangle.height);
            }
            if ((rectangle3 = new Rectangle(imageLayout.getMinX(null), imageLayout.getMinY(null), imageLayout.getWidth(null), imageLayout.getHeight(null))).isEmpty()) {
                throw new IllegalArgumentException(JaiI18N.getString("PointOpImage1"));
            }
            if (!rectangle.contains(rectangle3)) {
                throw new IllegalArgumentException(JaiI18N.getString("PointOpImage2"));
            }
        }
        if (n > 1 && !imageLayout.isValid(256)) {
            SampleModel sampleModel;
            int n2;
            SampleModel sampleModel2 = renderedImage.getSampleModel();
            object = renderedImage.getColorModel();
            int n3 = PointOpImage.getAppropriateDataType(sampleModel2);
            int n4 = PointOpImage.getBandCount(sampleModel2, (ColorModel)object);
            int n5 = n3;
            int n6 = n4;
            for (int i = 1; i < n; ++i) {
                RenderedImage renderedImage2 = (RenderedImage)vector.get(i);
                sampleModel2 = renderedImage2.getSampleModel();
                object = renderedImage2.getColorModel();
                n2 = PointOpImage.getBandCount(sampleModel2, (ColorModel)object);
                n5 = PointOpImage.mergeTypes(n5, PointOpImage.getPixelType(sampleModel2));
                n6 = Math.min(n6, n2);
            }
            if (n5 == -1 && n6 > 1) {
                n5 = 0;
            }
            if (n5 != (sampleModel = renderedImage.getSampleModel()).getDataType() || n6 != sampleModel.getNumBands()) {
                int n7 = imageLayout.getTileWidth(renderedImage);
                n2 = imageLayout.getTileHeight(renderedImage);
                SampleModel sampleModel3 = n5 == -1 ? new MultiPixelPackedSampleModel(0, n7, n2, 1) : RasterFactory.createPixelInterleavedSampleModel(n5, n7, n2, n6);
                imageLayout.setSampleModel(sampleModel3);
                if (object != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel3, (ColorModel)object)) {
                    object = ImageUtil.getCompatibleColorModel(sampleModel3, map);
                    imageLayout.setColorModel((ColorModel)object);
                }
            }
        }
        return imageLayout;
    }

    private static int getPixelType(SampleModel sampleModel) {
        return ImageUtil.isBinary(sampleModel) ? -1 : sampleModel.getDataType();
    }

    private static int getBandCount(SampleModel sampleModel, ColorModel colorModel) {
        if (ImageUtil.isBinary(sampleModel)) {
            return 1;
        }
        if (colorModel instanceof IndexColorModel) {
            return colorModel.getNumComponents();
        }
        return sampleModel.getNumBands();
    }

    private static int getAppropriateDataType(SampleModel sampleModel) {
        int n;
        int n2 = n = sampleModel.getDataType();
        if (ImageUtil.isBinary(sampleModel)) {
            n2 = -1;
        } else if (n == 1 || n == 3) {
            boolean bl = true;
            boolean bl2 = true;
            int[] nArray = sampleModel.getSampleSize();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] > 16) {
                    bl = false;
                    bl2 = false;
                    break;
                }
                if (nArray[i] <= 8) continue;
                bl = false;
            }
            if (bl) {
                n2 = 0;
            } else if (bl2) {
                n2 = 1;
            }
        }
        return n2;
    }

    private static int mergeTypes(int n, int n2) {
        if (n == n2) {
            return n;
        }
        int n3 = n2;
        switch (n) {
            case -1: 
            case 0: {
                break;
            }
            case 2: {
                if (n2 == 0) {
                    n3 = 2;
                    break;
                }
                if (n2 != 1) break;
                n3 = 3;
                break;
            }
            case 1: {
                if (n2 == 0) {
                    n3 = 1;
                    break;
                }
                if (n2 != 2) break;
                n3 = 3;
                break;
            }
            case 3: {
                if (n2 != 0 && n2 != 2 && n2 != 1) break;
                n3 = 3;
                break;
            }
            case 4: {
                if (n2 == 5) break;
                n3 = 4;
                break;
            }
            case 5: {
                n3 = 5;
            }
        }
        return n3;
    }

    public PointOpImage(Vector vector, ImageLayout imageLayout, Map map, boolean bl) {
        super(PointOpImage.checkSourceVector(vector, true), PointOpImage.layoutHelper(imageLayout, vector, map), map, bl);
    }

    public PointOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl) {
        this(PointOpImage.vectorize(renderedImage), imageLayout, map, bl);
    }

    public PointOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, ImageLayout imageLayout, Map map, boolean bl) {
        this(PointOpImage.vectorize(renderedImage, renderedImage2), imageLayout, map, bl);
    }

    public PointOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, RenderedImage renderedImage3, ImageLayout imageLayout, Map map, boolean bl) {
        this(PointOpImage.vectorize(renderedImage, renderedImage2, renderedImage3), imageLayout, map, bl);
    }

    private synchronized void initializeFields() {
        Object object;
        if (this.areFieldsInitialized) {
            return;
        }
        PlanarImage planarImage = this.getSource(0);
        if (this.checkInPlaceOperation) {
            Vector vector = planarImage.getSinks();
            boolean bl = this.isInPlaceEnabled = planarImage != null && this.getTileGridXOffset() == planarImage.getTileGridXOffset() && this.getTileGridYOffset() == planarImage.getTileGridYOffset() && this.getBounds().equals(planarImage.getBounds()) && planarImage instanceof OpImage && this.hasCompatibleSampleModel(planarImage) && (vector == null || vector.size() <= 1);
            if (this.isInPlaceEnabled && !((OpImage)planarImage).computesUniqueTiles()) {
                this.isInPlaceEnabled = false;
            }
            if (this.isInPlaceEnabled) {
                try {
                    Method method = planarImage.getClass().getMethod("getTile", Integer.TYPE, Integer.TYPE);
                    object = Class.forName("javax.media.jai.OpImage");
                    Class<?> clazz = method.getDeclaringClass();
                    if (!clazz.equals(object)) {
                        this.isInPlaceEnabled = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.isInPlaceEnabled = false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.isInPlaceEnabled = false;
                }
            }
            if (this.isInPlaceEnabled) {
                this.source0IsWritableRenderedImage = planarImage instanceof WritableRenderedImage;
                if (this.source0IsWritableRenderedImage) {
                    this.source0AsWritableRenderedImage = (WritableRenderedImage)((Object)planarImage);
                } else {
                    this.source0AsOpImage = (OpImage)planarImage;
                }
            }
            this.checkInPlaceOperation = false;
        }
        int n = this.getNumSources();
        this.sameBounds = true;
        this.sameTileGrid = true;
        for (int i = 0; i < n && (this.sameBounds || this.sameTileGrid); ++i) {
            object = this.getSource(i);
            if (this.sameBounds) {
                boolean bl = this.sameBounds = this.sameBounds && this.minX == ((PlanarImage)object).minX && this.minY == ((PlanarImage)object).minY && this.width == ((PlanarImage)object).width && this.height == ((PlanarImage)object).height;
            }
            if (!this.sameTileGrid) continue;
            this.sameTileGrid = this.sameTileGrid && this.tileGridXOffset == ((PlanarImage)object).tileGridXOffset && this.tileGridYOffset == ((PlanarImage)object).tileGridYOffset && this.tileWidth == ((PlanarImage)object).tileWidth && this.tileHeight == ((PlanarImage)object).tileHeight;
        }
        this.areFieldsInitialized = true;
    }

    private boolean hasCompatibleSampleModel(PlanarImage planarImage) {
        boolean bl;
        SampleModel sampleModel = planarImage.getSampleModel();
        int n = this.sampleModel.getNumBands();
        boolean bl2 = bl = sampleModel.getTransferType() == this.sampleModel.getTransferType() && sampleModel.getWidth() == this.sampleModel.getWidth() && sampleModel.getHeight() == this.sampleModel.getHeight() && sampleModel.getNumBands() == n && sampleModel.getClass().equals(this.sampleModel.getClass());
        if (bl) {
            if (this.sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)this.sampleModel;
                bl = bl && componentSampleModel.getPixelStride() == componentSampleModel2.getPixelStride() && componentSampleModel.getScanlineStride() == componentSampleModel2.getScanlineStride();
                int[] nArray = componentSampleModel.getBankIndices();
                int[] nArray2 = componentSampleModel2.getBankIndices();
                int[] nArray3 = componentSampleModel.getBandOffsets();
                int[] nArray4 = componentSampleModel2.getBandOffsets();
                for (int i = 0; i < n && bl; ++i) {
                    bl = bl && nArray[i] == nArray2[i] && nArray3[i] == nArray4[i];
                }
            } else if (this.sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)this.sampleModel;
                bl = bl && singlePixelPackedSampleModel.getScanlineStride() == singlePixelPackedSampleModel2.getScanlineStride();
                int[] nArray = singlePixelPackedSampleModel.getBitMasks();
                int[] nArray5 = singlePixelPackedSampleModel2.getBitMasks();
                for (int i = 0; i < n && bl; ++i) {
                    bl = bl && nArray[i] == nArray5[i];
                }
            } else if (this.sampleModel instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)this.sampleModel;
                bl = bl && multiPixelPackedSampleModel.getPixelBitStride() == multiPixelPackedSampleModel2.getPixelBitStride() && multiPixelPackedSampleModel.getScanlineStride() == multiPixelPackedSampleModel2.getScanlineStride() && multiPixelPackedSampleModel.getDataBitOffset() == multiPixelPackedSampleModel2.getDataBitOffset();
            } else {
                bl = false;
            }
        }
        return bl;
    }

    protected void permitInPlaceOperation() {
        Object var1_1 = null;
        try {
            var1_1 = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = "javax.media.jai.PointOpImage.InPlace";
                    return System.getProperty(string);
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.checkInPlaceOperation = var1_1 == null || !(var1_1 instanceof String) || !((String)var1_1).equalsIgnoreCase("false");
    }

    protected boolean isColormapOperation() {
        return false;
    }

    public Raster computeTile(int n, int n2) {
        int n3;
        int n4;
        Object object;
        boolean bl;
        if (!this.cobbleSources) {
            return super.computeTile(n, n2);
        }
        this.initializeFields();
        WritableRaster writableRaster = null;
        if (this.isInPlaceEnabled) {
            if (this.source0IsWritableRenderedImage) {
                writableRaster = this.source0AsWritableRenderedImage.getWritableTile(n, n2);
            } else {
                Raster raster = this.source0AsOpImage.getTileFromCache(n, n2);
                if (raster == null) {
                    try {
                        raster = this.source0AsOpImage.computeTile(n, n2);
                        if (raster instanceof WritableRaster) {
                            writableRaster = (WritableRaster)raster;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        boolean bl2 = bl = writableRaster != null;
        if (!bl) {
            object = new Point(this.tileXToX(n), this.tileYToY(n2));
            writableRaster = this.createWritableRaster(this.sampleModel, (Point)object);
        }
        if (this.isColormapOperation()) {
            if (!bl) {
                object = this.getSource(0);
                Raster raster = null;
                Rectangle rectangle = null;
                Rectangle rectangle2 = writableRaster.getBounds();
                if (this.sameTileGrid) {
                    raster = this.getSource(0).getTile(n, n2);
                } else if (rectangle2.intersects(((PlanarImage)object).getBounds())) {
                    raster = ((PlanarImage)object).getData(rectangle2);
                } else {
                    return writableRaster;
                }
                rectangle = raster.getBounds();
                if (!rectangle2.contains(rectangle)) {
                    rectangle = rectangle2.intersection(rectangle);
                    raster = raster.createChild(raster.getMinX(), raster.getMinY(), rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
                }
                JDKWorkarounds.setRect(writableRaster, raster, 0, 0);
            }
            return writableRaster;
        }
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = n5 + writableRaster.getWidth();
        int n8 = n6 + writableRaster.getHeight();
        Rectangle rectangle = this.getBounds();
        if (n5 < rectangle.x) {
            n5 = rectangle.x;
        }
        if (n7 > (n4 = rectangle.x + rectangle.width)) {
            n7 = n4;
        }
        if (n6 < rectangle.y) {
            n6 = rectangle.y;
        }
        if (n8 > (n3 = rectangle.y + rectangle.height)) {
            n8 = n3;
        }
        int n9 = this.getNumSources();
        if (bl && n9 == 1) {
            Raster[] rasterArray = new Raster[]{writableRaster};
            Rectangle rectangle3 = new Rectangle(n5, n6, n7 - n5, n8 - n6);
            this.computeRect(rasterArray, writableRaster, rectangle3);
        } else if (bl && this.sameBounds && this.sameTileGrid) {
            Raster[] rasterArray = new Raster[n9];
            rasterArray[0] = writableRaster;
            for (int i = 1; i < n9; ++i) {
                rasterArray[i] = this.getSource(i).getTile(n, n2);
            }
            Rectangle rectangle4 = new Rectangle(n5, n6, n7 - n5, n8 - n6);
            this.computeRect(rasterArray, writableRaster, rectangle4);
        } else {
            if (!this.sameBounds) {
                int n10;
                int n11 = n10 = bl ? 1 : 0;
                while (n10 < n9) {
                    rectangle = this.getSource(n10).getBounds();
                    if (n5 < rectangle.x) {
                        n5 = rectangle.x;
                    }
                    if (n7 > (n4 = rectangle.x + rectangle.width)) {
                        n7 = n4;
                    }
                    if (n6 < rectangle.y) {
                        n6 = rectangle.y;
                    }
                    if (n8 > (n3 = rectangle.y + rectangle.height)) {
                        n8 = n3;
                    }
                    if (n5 >= n7 || n6 >= n8) {
                        return writableRaster;
                    }
                    ++n10;
                }
            }
            Rectangle rectangle5 = new Rectangle(n5, n6, n7 - n5, n8 - n6);
            Raster[] rasterArray = new Raster[n9];
            if (this.sameTileGrid) {
                int n12;
                if (bl) {
                    rasterArray[0] = writableRaster;
                }
                int n13 = n12 = bl ? 1 : 0;
                while (n12 < n9) {
                    rasterArray[n12] = this.getSource(n12).getTile(n, n2);
                    ++n12;
                }
                this.computeRect(rasterArray, writableRaster, rectangle5);
            } else {
                int n14;
                IntegerSequence integerSequence = new IntegerSequence(n5, n7);
                integerSequence.insert(n5);
                integerSequence.insert(n7);
                IntegerSequence integerSequence2 = new IntegerSequence(n6, n8);
                integerSequence2.insert(n6);
                integerSequence2.insert(n8);
                int n15 = n14 = bl ? 1 : 0;
                while (n14 < n9) {
                    PlanarImage planarImage = this.getSource(n14);
                    planarImage.getSplits(integerSequence, integerSequence2, rectangle5);
                    ++n14;
                }
                Rectangle rectangle6 = new Rectangle();
                integerSequence2.startEnumeration();
                int n16 = integerSequence2.nextElement();
                while (integerSequence2.hasMoreElements()) {
                    int n17 = integerSequence2.nextElement();
                    int n18 = n17 - n16;
                    integerSequence.startEnumeration();
                    n14 = integerSequence.nextElement();
                    while (integerSequence.hasMoreElements()) {
                        int n19;
                        int n20 = integerSequence.nextElement();
                        int n21 = n20 - n14;
                        if (bl) {
                            rasterArray[0] = writableRaster;
                        }
                        int n22 = n19 = bl ? 1 : 0;
                        while (n19 < n9) {
                            PlanarImage planarImage = this.getSource(n19);
                            int n23 = planarImage.XToTileX(n14);
                            int n24 = planarImage.YToTileY(n16);
                            rasterArray[n19] = planarImage.getTile(n23, n24);
                            ++n19;
                        }
                        rectangle6.x = n14;
                        rectangle6.y = n16;
                        rectangle6.width = n21;
                        rectangle6.height = n18;
                        this.computeRect(rasterArray, writableRaster, rectangle6);
                        n14 = n20;
                    }
                    n16 = n17;
                }
            }
        }
        if (bl && this.source0IsWritableRenderedImage) {
            this.source0AsWritableRenderedImage.releaseWritableTile(n, n2);
        }
        return writableRaster;
    }

    public final Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    public final Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    public synchronized void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        if (this.cache != null && this.isInPlaceEnabled && this.tileRecycler != null) {
            this.cache.removeTiles(this);
        }
        super.dispose();
    }
}

