/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PackedImageData;
import javax.media.jai.UnpackedImageData;

public final class PixelAccessor {
    public static final int TYPE_BIT = -1;
    public final SampleModel sampleModel;
    public final ColorModel colorModel;
    public final boolean isComponentSM;
    public final boolean isMultiPixelPackedSM;
    public final boolean isSinglePixelPackedSM;
    public final int sampleType;
    public final int bufferType;
    public final int transferType;
    public final int numBands;
    public final int[] sampleSize;
    public final boolean isPacked;
    public final boolean hasCompatibleCM;
    public final boolean isComponentCM;
    public final boolean isIndexCM;
    public final boolean isPackedCM;
    public final int componentType;
    public final int numComponents;
    public final int[] componentSize;

    private static SampleModel getSampleModel(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return renderedImage.getSampleModel();
    }

    public PixelAccessor(RenderedImage renderedImage) {
        this(PixelAccessor.getSampleModel(renderedImage), renderedImage.getColorModel());
    }

    public PixelAccessor(SampleModel sampleModel, ColorModel colorModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.sampleModel = sampleModel;
        this.colorModel = colorModel;
        this.isComponentSM = this.sampleModel instanceof ComponentSampleModel;
        this.isMultiPixelPackedSM = this.sampleModel instanceof MultiPixelPackedSampleModel;
        this.isSinglePixelPackedSM = this.sampleModel instanceof SinglePixelPackedSampleModel;
        this.bufferType = this.sampleModel.getDataType();
        this.transferType = this.sampleModel.getTransferType();
        this.numBands = this.sampleModel.getNumBands();
        this.sampleSize = this.sampleModel.getSampleSize();
        this.sampleType = this.isComponentSM ? this.bufferType : PixelAccessor.getType(this.sampleSize);
        this.isPacked = this.sampleType == -1 && this.numBands == 1;
        boolean bl = this.hasCompatibleCM = this.colorModel != null && JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel);
        if (this.hasCompatibleCM) {
            this.isComponentCM = this.colorModel instanceof ComponentColorModel;
            this.isIndexCM = this.colorModel instanceof IndexColorModel;
            this.isPackedCM = this.colorModel instanceof PackedColorModel;
            this.numComponents = this.colorModel.getNumComponents();
            this.componentSize = this.colorModel.getComponentSize();
            int n = PixelAccessor.getType(this.componentSize);
            this.componentType = n == -1 ? 0 : n;
        } else {
            this.isComponentCM = false;
            this.isIndexCM = false;
            this.isPackedCM = false;
            this.numComponents = this.numBands;
            this.componentSize = this.sampleSize;
            this.componentType = this.sampleType;
        }
    }

    private static int getType(int[] nArray) {
        int n;
        int n2 = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            n2 = Math.max(n2, nArray[n]);
        }
        n = n2 < 1 ? 32 : (n2 == 1 ? -1 : (n2 <= 8 ? 0 : (n2 <= 16 ? 1 : (n2 <= 32 ? 3 : (n2 <= 64 ? 5 : 32)))));
        return n;
    }

    public static int getPixelType(SampleModel sampleModel) {
        return sampleModel instanceof ComponentSampleModel ? sampleModel.getDataType() : PixelAccessor.getType(sampleModel.getSampleSize());
    }

    public static int getDestPixelType(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = 32;
        int n2 = vector.size();
        if (n2 > 0) {
            RenderedImage renderedImage = (RenderedImage)vector.get(0);
            SampleModel sampleModel = renderedImage.getSampleModel();
            n = PixelAccessor.getPixelType(sampleModel);
            for (int i = 1; i < n2; ++i) {
                renderedImage = (RenderedImage)vector.get(i);
                sampleModel = renderedImage.getSampleModel();
                int n3 = PixelAccessor.getPixelType(sampleModel);
                n = n == 1 && n3 == 2 || n == 2 && n3 == 1 ? 3 : Math.max(n, n3);
            }
        }
        return n;
    }

    public static int getDestNumBands(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = 0;
        int n2 = vector.size();
        if (n2 > 0) {
            RenderedImage renderedImage = (RenderedImage)vector.get(0);
            SampleModel sampleModel = renderedImage.getSampleModel();
            n = sampleModel.getNumBands();
            for (int i = 1; i < n2; ++i) {
                renderedImage = (RenderedImage)vector.get(i);
                sampleModel = renderedImage.getSampleModel();
                int n3 = sampleModel.getNumBands();
                n = n == 1 || n3 == 1 ? Math.max(n, n3) : Math.min(n, n3);
            }
        }
        return n;
    }

    public static boolean isPackedOperation(PixelAccessor[] pixelAccessorArray, PixelAccessor pixelAccessor) {
        boolean bl = pixelAccessor.isPacked;
        if (bl && pixelAccessorArray != null) {
            for (int i = 0; i < pixelAccessorArray.length; ++i) {
                boolean bl2 = bl = bl && pixelAccessorArray[i].isPacked;
                if (!bl) break;
            }
        }
        return bl;
    }

    public static boolean isPackedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2) {
        return pixelAccessor.isPacked && pixelAccessor2.isPacked;
    }

    public static boolean isPackedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2, PixelAccessor pixelAccessor3) {
        return pixelAccessor.isPacked && pixelAccessor2.isPacked && pixelAccessor3.isPacked;
    }

    public UnpackedImageData getPixels(Raster raster, Rectangle rectangle, int n, boolean bl) {
        if (!raster.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor1"));
        }
        if (n < this.sampleType || this.sampleType == 1 && n == 2) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor2"));
        }
        if (this.isComponentSM) {
            return this.getPixelsCSM(raster, rectangle, n, bl);
        }
        int n2 = rectangle.width * rectangle.height * this.numBands;
        Object object = null;
        switch (n) {
            case 0: {
                byte[] byArray;
                if (bl) {
                    byArray = new byte[n2];
                } else if (this.isMultiPixelPackedSM && this.transferType == 0) {
                    byArray = (byte[])raster.getDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                } else {
                    byArray = new byte[n2];
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    for (int i = 0; i < n2; ++i) {
                        byArray[i] = (byte)(nArray[i] & 0xFF);
                    }
                }
                object = this.repeatBand(byArray, this.numBands);
                break;
            }
            case 1: {
                short[] sArray;
                if (bl) {
                    sArray = new short[n2];
                } else if (this.isMultiPixelPackedSM && this.transferType == 1) {
                    sArray = (short[])raster.getDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                } else {
                    sArray = new short[n2];
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    for (int i = 0; i < n2; ++i) {
                        sArray[i] = (short)(nArray[i] & 0xFFFF);
                    }
                }
                object = this.repeatBand(sArray, this.numBands);
                break;
            }
            case 2: {
                short[] sArray = new short[n2];
                if (!bl) {
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    for (int i = 0; i < n2; ++i) {
                        sArray[i] = (short)nArray[i];
                    }
                }
                object = this.repeatBand(sArray, this.numBands);
                break;
            }
            case 3: {
                return this.getPixelsInt(raster, rectangle, bl);
            }
            case 4: {
                return this.getPixelsFloat(raster, rectangle, bl);
            }
            case 5: {
                return this.getPixelsDouble(raster, rectangle, bl);
            }
        }
        return new UnpackedImageData(raster, rectangle, n, object, this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl & raster instanceof WritableRaster);
    }

    private UnpackedImageData getPixelsCSM(Raster raster, Rectangle rectangle, int n, boolean bl) {
        boolean bl2;
        int[] nArray;
        int n2;
        int n3;
        Object object = null;
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        if (n == this.sampleType) {
            int n4;
            Object object2;
            DataBuffer dataBuffer = raster.getDataBuffer();
            int[] nArray2 = componentSampleModel.getBankIndices();
            switch (this.sampleType) {
                case 0: {
                    object2 = ((DataBufferByte)dataBuffer).getBankData();
                    byte[][] byArrayArray = new byte[this.numBands][];
                    for (n4 = 0; n4 < this.numBands; ++n4) {
                        byArrayArray[n4] = object2[nArray2[n4]];
                    }
                    object = byArrayArray;
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sArray = this.sampleType == 1 ? ((DataBufferUShort)dataBuffer).getBankData() : ((DataBufferShort)dataBuffer).getBankData();
                    short[][] sArrayArray = new short[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        sArrayArray[i] = sArray[nArray2[i]];
                    }
                    object = sArrayArray;
                    break;
                }
                case 3: {
                    int[][] nArray3 = ((DataBufferInt)dataBuffer).getBankData();
                    int[][] nArrayArray = new int[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        nArrayArray[i] = nArray3[nArray2[i]];
                    }
                    object = nArrayArray;
                    break;
                }
                case 4: {
                    float[][] fArray = DataBufferUtils.getBankDataFloat(dataBuffer);
                    float[][] fArrayArray = new float[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        fArrayArray[i] = fArray[nArray2[i]];
                    }
                    object = fArrayArray;
                    break;
                }
                case 5: {
                    double[][] dArray = DataBufferUtils.getBankDataDouble(dataBuffer);
                    double[][] dArrayArray = new double[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        dArrayArray[i] = dArray[nArray2[i]];
                    }
                    object = dArrayArray;
                }
            }
            n3 = componentSampleModel.getPixelStride();
            n2 = componentSampleModel.getScanlineStride();
            object2 = dataBuffer.getOffsets();
            int n5 = rectangle.x - raster.getSampleModelTranslateX();
            n4 = rectangle.y - raster.getSampleModelTranslateY();
            nArray = new int[this.numBands];
            for (int i = 0; i < this.numBands; ++i) {
                nArray[i] = componentSampleModel.getOffset(n5, n4, i) + object2[nArray2[i]];
            }
            bl2 = false;
        } else {
            switch (n) {
                case 3: {
                    return this.getPixelsInt(raster, rectangle, bl);
                }
                case 4: {
                    return this.getPixelsFloat(raster, rectangle, bl);
                }
                case 5: {
                    return this.getPixelsDouble(raster, rectangle, bl);
                }
            }
            int n6 = rectangle.width * rectangle.height * this.numBands;
            short[] sArray = new short[n6];
            if (!bl) {
                UnpackedImageData unpackedImageData = this.getPixelsCSM(raster, rectangle, this.sampleType, bl);
                byte[][] byArray = unpackedImageData.getByteData();
                for (int i = 0; i < this.numBands; ++i) {
                    byte[] byArray2 = byArray[i];
                    int n7 = unpackedImageData.getOffset(i);
                    int n8 = i;
                    for (int j = 0; j < rectangle.height; ++j) {
                        int n9 = n7;
                        n7 += unpackedImageData.lineStride;
                        for (int k = 0; k < rectangle.width; ++k) {
                            sArray[n8] = (short)(byArray2[n9] & 0xFF);
                            n9 += unpackedImageData.pixelStride;
                            n8 += this.numBands;
                        }
                    }
                }
            }
            object = this.repeatBand(sArray, this.numBands);
            n3 = this.numBands;
            n2 = n3 * rectangle.width;
            nArray = this.getInterleavedOffsets(this.numBands);
            bl2 = bl & raster instanceof WritableRaster;
        }
        return new UnpackedImageData(raster, rectangle, n, object, n3, n2, nArray, bl2);
    }

    private UnpackedImageData getPixelsInt(Raster raster, Rectangle rectangle, boolean bl) {
        int n = rectangle.width * rectangle.height * this.numBands;
        int[] nArray = bl ? new int[n] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
        return new UnpackedImageData(raster, rectangle, 3, this.repeatBand(nArray, this.numBands), this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl & raster instanceof WritableRaster);
    }

    private UnpackedImageData getPixelsFloat(Raster raster, Rectangle rectangle, boolean bl) {
        int n = rectangle.width * rectangle.height * this.numBands;
        float[] fArray = bl ? new float[n] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (float[])null);
        return new UnpackedImageData(raster, rectangle, 4, this.repeatBand(fArray, this.numBands), this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl & raster instanceof WritableRaster);
    }

    private UnpackedImageData getPixelsDouble(Raster raster, Rectangle rectangle, boolean bl) {
        int n = rectangle.width * rectangle.height * this.numBands;
        double[] dArray = bl ? new double[n] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (double[])null);
        return new UnpackedImageData(raster, rectangle, 5, this.repeatBand(dArray, this.numBands), this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl & raster instanceof WritableRaster);
    }

    private byte[][] repeatBand(byte[] byArray, int n) {
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byArrayArray[i] = byArray;
        }
        return byArrayArray;
    }

    private short[][] repeatBand(short[] sArray, int n) {
        short[][] sArrayArray = new short[n][];
        for (int i = 0; i < n; ++i) {
            sArrayArray[i] = sArray;
        }
        return sArrayArray;
    }

    private int[][] repeatBand(int[] nArray, int n) {
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = nArray;
        }
        return nArrayArray;
    }

    private float[][] repeatBand(float[] fArray, int n) {
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = fArray;
        }
        return fArrayArray;
    }

    private double[][] repeatBand(double[] dArray, int n) {
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = dArray;
        }
        return dArrayArray;
    }

    private int[] getInterleavedOffsets(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public void setPixels(UnpackedImageData unpackedImageData) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.setPixels(unpackedImageData, true);
    }

    public void setPixels(UnpackedImageData unpackedImageData, boolean bl) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!unpackedImageData.convertToDest) {
            return;
        }
        if (bl) {
            switch (this.sampleType) {
                case 0: {
                    this.clampByte(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 1: {
                    this.clampUShort(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 2: {
                    this.clampShort(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 3: {
                    this.clampInt(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 4: {
                    this.clampFloat(unpackedImageData.data, unpackedImageData.type);
                }
            }
        }
        WritableRaster writableRaster = (WritableRaster)unpackedImageData.raster;
        Rectangle rectangle = unpackedImageData.rect;
        int n = unpackedImageData.type;
        switch (n) {
            case 0: {
                byte[] byArray = unpackedImageData.getByteData(0);
                if (this.isMultiPixelPackedSM && this.transferType == 0) {
                    writableRaster.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, byArray);
                    break;
                }
                int n2 = byArray.length;
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = byArray[i] & 0xFF;
                }
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = unpackedImageData.getShortData(0);
                if (this.isComponentSM) {
                    UnpackedImageData unpackedImageData2 = this.getPixelsCSM(writableRaster, rectangle, 0, true);
                    byte[][] byArray = unpackedImageData2.getByteData();
                    for (int i = 0; i < this.numBands; ++i) {
                        byte[] byArray2 = byArray[i];
                        int n3 = unpackedImageData2.getOffset(i);
                        int n4 = i;
                        for (int j = 0; j < rectangle.height; ++j) {
                            int n5 = n3;
                            n3 += unpackedImageData2.lineStride;
                            for (int k = 0; k < rectangle.width; ++k) {
                                byArray2[n5] = (byte)sArray[n4];
                                n5 += unpackedImageData2.pixelStride;
                                n4 += this.numBands;
                            }
                        }
                    }
                    break;
                }
                if (this.isMultiPixelPackedSM && this.transferType == 1) {
                    writableRaster.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, sArray);
                    break;
                }
                int n6 = sArray.length;
                int[] nArray = new int[n6];
                if (n == 1) {
                    for (int i = 0; i < n6; ++i) {
                        nArray[i] = sArray[i] & 0xFFFF;
                    }
                } else {
                    for (int i = 0; i < n6; ++i) {
                        nArray[i] = sArray[i];
                    }
                }
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
                break;
            }
            case 3: {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, unpackedImageData.getIntData(0));
                break;
            }
            case 4: {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, unpackedImageData.getFloatData(0));
                break;
            }
            case 5: {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, unpackedImageData.getDoubleData(0));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void clampByte(Object object, int n) {
        switch (n) {
            case 1: {
                for (short[] sArray : (short[][])object) {
                    int n2 = sArray.length;
                    for (int i = 0; i < n2; ++i) {
                        int n3 = sArray[i] & 0xFFFF;
                        sArray[i] = (short)(n3 > 255 ? 255 : n3);
                    }
                }
                break;
            }
            case 2: {
                for (short[] sArray : (short[][])object) {
                    for (int n4 : sArray) {
                        sArray[var9_24] = (short)(n4 > 255 ? 255 : (n4 < 0 ? 0 : n4));
                    }
                }
                break;
            }
            case 3: {
                for (int[] nArray : (int[][])object) {
                    for (int n2 : nArray) {
                        nArray[var10_29] = n2 > 255 ? 255 : (n2 < 0 ? 0 : n2);
                    }
                }
                break;
            }
            case 4: {
                for (float[] fArray : (float[][])object) {
                    for (float f : fArray) {
                        fArray[dArray] = f > 255.0f ? 255.0f : (f < 0.0f ? 0.0f : f);
                    }
                }
                break;
            }
            case 5: {
                void var10_32;
                double[][] dArray = (double[][])object;
                int n3 = dArray.length;
                boolean bl = false;
                while (var10_32 < n3) {
                    for (double d : dArray[var10_32]) {
                        var11_35[var12_37] = d > 255.0 ? 255.0 : (d < 0.0 ? 0.0 : d);
                    }
                    ++var10_32;
                }
                break;
            }
        }
    }

    private void clampUShort(Object object, int n) {
        switch (n) {
            case 3: {
                for (int[] nArray : (int[][])object) {
                    for (int n2 : nArray) {
                        nArray[var8_15] = n2 > 65535 ? 65535 : (n2 < 0 ? 0 : n2);
                    }
                }
                break;
            }
            case 4: {
                for (float[] fArray : (float[][])object) {
                    for (float f : fArray) {
                        fArray[var9_19] = f > 65535.0f ? 65535.0f : (f < 0.0f ? 0.0f : f);
                    }
                }
                break;
            }
            case 5: {
                for (double[] dArray : (double[][])object) {
                    for (double d : dArray) {
                        dArray[var10_22] = d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d);
                    }
                }
                break;
            }
        }
    }

    private void clampShort(Object object, int n) {
        switch (n) {
            case 3: {
                for (int[] nArray : (int[][])object) {
                    for (int n2 : nArray) {
                        nArray[var8_15] = n2 > Short.MAX_VALUE ? Short.MAX_VALUE : (n2 < Short.MIN_VALUE ? Short.MIN_VALUE : n2);
                    }
                }
                break;
            }
            case 4: {
                for (float[] fArray : (float[][])object) {
                    for (float f : fArray) {
                        fArray[var9_19] = f > 32767.0f ? 32767.0f : (f < -32768.0f ? -32768.0f : f);
                    }
                }
                break;
            }
            case 5: {
                for (double[] dArray : (double[][])object) {
                    for (double d : dArray) {
                        dArray[var10_22] = d > 32767.0 ? 32767.0 : (d < -32768.0 ? -32768.0 : d);
                    }
                }
                break;
            }
        }
    }

    private void clampInt(Object object, int n) {
        switch (n) {
            case 4: {
                for (float[] fArray : (float[][])object) {
                    for (float f : fArray) {
                        fArray[var8_12] = f > 2.1474836E9f ? 2.1474836E9f : (f < -2.1474836E9f ? -2.1474836E9f : f);
                    }
                }
                break;
            }
            case 5: {
                for (double[] dArray : (double[][])object) {
                    for (double d : dArray) {
                        dArray[var9_15] = d > 2.147483647E9 ? 2.147483647E9 : (d < -2.147483648E9 ? -2.147483648E9 : d);
                    }
                }
                break;
            }
        }
    }

    private void clampFloat(Object object, int n) {
        switch (n) {
            case 5: {
                for (double[] dArray : (double[][])object) {
                    for (double d : dArray) {
                        dArray[var8_8] = d > 3.4028234663852886E38 ? 3.4028234663852886E38 : (d < -3.4028234663852886E38 ? -3.4028234663852886E38 : d);
                    }
                }
                break;
            }
        }
    }

    public PackedImageData getPackedPixels(Raster raster, Rectangle rectangle, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        byte[] byArray;
        boolean bl3;
        block16: {
            block14: {
                block15: {
                    if (!this.isPacked) {
                        throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor3"));
                    }
                    if (!raster.getBounds().contains(rectangle)) {
                        throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
                    }
                    if (!this.isMultiPixelPackedSM) break block14;
                    bl3 = bl;
                    if (!bl2) break block15;
                    byArray = ImageUtil.getPackedBinaryData(raster, rectangle);
                    n3 = (rectangle.width + 7) / 8;
                    n2 = 0;
                    n = 0;
                    break block16;
                }
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.sampleModel;
                DataBuffer dataBuffer = raster.getDataBuffer();
                int n4 = dataBuffer.getOffset();
                int n5 = rectangle.x - raster.getSampleModelTranslateX();
                int n6 = rectangle.y - raster.getSampleModelTranslateY();
                int n7 = multiPixelPackedSampleModel.getScanlineStride();
                int n8 = multiPixelPackedSampleModel.getOffset(n5, n6) + n4;
                int n9 = multiPixelPackedSampleModel.getOffset(n5 + rectangle.width - 1, n6) + n4;
                int n10 = n9 - n8 + 1;
                int n11 = multiPixelPackedSampleModel.getBitOffset(n5);
                switch (this.bufferType) {
                    case 0: {
                        byArray = ((DataBufferByte)dataBuffer).getData();
                        n3 = n7;
                        n = n8;
                        n2 = n11;
                        bl3 = false;
                        break;
                    }
                    case 1: {
                        n3 = n10 * 2;
                        n = n11 / 8;
                        n2 = n11 % 8;
                        byArray = new byte[n3 * rectangle.height];
                        short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                        int n12 = 0;
                        for (int i = 0; i < rectangle.height; ++i) {
                            for (int j = n8; j <= n9; ++j) {
                                short s = sArray[j];
                                byArray[n12++] = (byte)(s >>> 8 & 0xFF);
                                byArray[n12++] = (byte)(s & 0xFF);
                            }
                            n8 += n7;
                            n9 += n7;
                        }
                        break block16;
                    }
                    case 3: {
                        n3 = n10 * 4;
                        n = n11 / 8;
                        n2 = n11 % 8;
                        byArray = new byte[n3 * rectangle.height];
                        int[] nArray = ((DataBufferInt)dataBuffer).getData();
                        int n13 = 0;
                        for (int i = 0; i < rectangle.height; ++i) {
                            for (int j = n8; j <= n9; ++j) {
                                int n14 = nArray[j];
                                byArray[n13++] = (byte)(n14 >>> 24 & 0xFF);
                                byArray[n13++] = (byte)(n14 >>> 16 & 0xFF);
                                byArray[n13++] = (byte)(n14 >>> 8 & 0xFF);
                                byArray[n13++] = (byte)(n14 & 0xFF);
                            }
                            n8 += n7;
                            n9 += n7;
                        }
                        break block16;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                break block16;
            }
            n3 = (rectangle.width + 7) / 8;
            n = 0;
            n2 = 0;
            bl3 = bl & raster instanceof WritableRaster;
            byArray = new byte[n3 * rectangle.height];
            if (!bl) {
                int n15 = n3 * 8;
                int[] nArray = new int[n15];
                int n16 = 0;
                for (int i = 0; i < rectangle.height; ++i) {
                    nArray = raster.getPixels(rectangle.x, rectangle.y + i, rectangle.width, 1, nArray);
                    for (int j = 0; j < n15; j += 8) {
                        byArray[n16++] = (byte)(nArray[j] << 7 | nArray[j + 1] << 6 | nArray[j + 2] << 5 | nArray[j + 3] << 4 | nArray[j + 4] << 3 | nArray[j + 5] << 2 | nArray[j + 6] << 1 | nArray[j + 7]);
                    }
                }
            }
        }
        return new PackedImageData(raster, rectangle, byArray, n3, n, n2, bl2, bl3);
    }

    public void setPackedPixels(PackedImageData packedImageData) {
        block14: {
            byte[] byArray;
            Rectangle rectangle;
            Raster raster;
            block12: {
                block13: {
                    if (packedImageData == null) {
                        throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
                    }
                    if (!packedImageData.convertToDest) {
                        return;
                    }
                    raster = packedImageData.raster;
                    rectangle = packedImageData.rect;
                    byArray = packedImageData.data;
                    if (!this.isMultiPixelPackedSM) break block12;
                    if (!packedImageData.coercedZeroOffset) break block13;
                    ImageUtil.setPackedBinaryData(byArray, (WritableRaster)raster, rectangle);
                    break block14;
                }
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.sampleModel;
                DataBuffer dataBuffer = raster.getDataBuffer();
                int n = dataBuffer.getOffset();
                int n2 = rectangle.x - raster.getSampleModelTranslateX();
                int n3 = rectangle.y - raster.getSampleModelTranslateY();
                int n4 = multiPixelPackedSampleModel.getScanlineStride();
                int n5 = multiPixelPackedSampleModel.getOffset(n2, n3) + n;
                int n6 = multiPixelPackedSampleModel.getOffset(n2 + rectangle.width - 1, n3) + n;
                switch (this.bufferType) {
                    case 1: {
                        short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                        int n7 = 0;
                        for (int i = 0; i < rectangle.height; ++i) {
                            for (int j = n5; j <= n6; ++j) {
                                sArray[j] = (short)(byArray[n7++] << 8 | byArray[n7++]);
                            }
                            n5 += n4;
                            n6 += n4;
                        }
                        break block14;
                    }
                    case 3: {
                        int[] nArray = ((DataBufferInt)dataBuffer).getData();
                        int n8 = 0;
                        for (int i = 0; i < rectangle.height; ++i) {
                            for (int j = n5; j <= n6; ++j) {
                                nArray[j] = byArray[n8++] << 24 | byArray[n8++] << 16 | byArray[n8++] << 8 | byArray[n8++];
                            }
                            n5 += n4;
                            n6 += n4;
                        }
                        break;
                    }
                }
                break block14;
            }
            WritableRaster writableRaster = (WritableRaster)raster;
            int n = packedImageData.lineStride * 8;
            int[] nArray = new int[n];
            int n9 = 0;
            for (int i = 0; i < rectangle.height; ++i) {
                for (int j = 0; j < n; j += 8) {
                    nArray[j] = byArray[n9] >>> 7 & 1;
                    nArray[j + 1] = byArray[n9] >>> 6 & 1;
                    nArray[j + 2] = byArray[n9] >>> 5 & 1;
                    nArray[j + 3] = byArray[n9] >>> 4 & 1;
                    nArray[j + 4] = byArray[n9] >>> 3 & 1;
                    nArray[j + 5] = byArray[n9] >>> 2 & 1;
                    nArray[j + 6] = byArray[n9] >>> 1 & 1;
                    nArray[j + 7] = byArray[n9] & 1;
                    ++n9;
                }
                writableRaster.setPixels(rectangle.x, rectangle.y + i, rectangle.width, 1, nArray);
            }
        }
    }

    public UnpackedImageData getComponents(Raster raster, Rectangle rectangle, int n) {
        Object object;
        int n2;
        if (!this.hasCompatibleCM) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor5"));
        }
        if (!raster.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor1"));
        }
        if (n < this.componentType || this.componentType == 1 && n == 2) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor4"));
        }
        int n3 = rectangle.width * rectangle.height * this.numComponents;
        int[] nArray = new int[n3];
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        int n6 = 0;
        for (int i = rectangle.y; i < n5; ++i) {
            for (n2 = rectangle.x; n2 < n4; ++n2) {
                object = raster.getDataElements(n2, i, null);
                this.colorModel.getComponents(object, nArray, n6);
                n6 += this.numComponents;
            }
        }
        Object object2 = null;
        switch (n) {
            case 0: {
                byte[] byArray = new byte[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    byArray[n2] = (byte)(nArray[n2] & 0xFF);
                }
                object2 = this.repeatBand(byArray, this.numComponents);
                break;
            }
            case 1: {
                short[] sArray = new short[n3];
                for (int i = 0; i < n3; ++i) {
                    sArray[i] = (short)(nArray[i] & 0xFFFF);
                }
                object2 = this.repeatBand(sArray, this.numComponents);
                break;
            }
            case 2: {
                object = new short[n3];
                for (int i = 0; i < n3; ++i) {
                    object[i] = (short)nArray[i];
                }
                object2 = this.repeatBand((short[])object, this.numComponents);
                break;
            }
            case 3: {
                object2 = this.repeatBand(nArray, this.numComponents);
                break;
            }
            case 4: {
                float[] fArray = new float[n3];
                for (int i = 0; i < n3; ++i) {
                    fArray[i] = nArray[i];
                }
                object2 = this.repeatBand(fArray, this.numComponents);
                break;
            }
            case 5: {
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = nArray[i];
                }
                object2 = this.repeatBand(dArray, this.numComponents);
            }
        }
        return new UnpackedImageData(raster, rectangle, n, object2, this.numComponents, this.numComponents * rectangle.width, this.getInterleavedOffsets(this.numComponents), raster instanceof WritableRaster);
    }

    public void setComponents(UnpackedImageData unpackedImageData) {
        int n;
        int n2;
        int n3;
        int n4;
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!unpackedImageData.convertToDest) {
            return;
        }
        WritableRaster writableRaster = (WritableRaster)unpackedImageData.raster;
        Rectangle rectangle = unpackedImageData.rect;
        int n5 = unpackedImageData.type;
        int n6 = rectangle.width * rectangle.height * this.numComponents;
        int[] nArray = null;
        switch (n5) {
            case 0: {
                byte[] byArray = unpackedImageData.getByteData(0);
                nArray = new int[n6];
                for (n4 = 0; n4 < n6; ++n4) {
                    nArray[n4] = byArray[n4] & 0xFF;
                }
                break;
            }
            case 1: {
                short[] sArray = unpackedImageData.getShortData(0);
                nArray = new int[n6];
                for (n3 = 0; n3 < n6; ++n3) {
                    nArray[n3] = sArray[n3] & 0xFFFF;
                }
                break;
            }
            case 2: {
                short[] sArray = unpackedImageData.getShortData(0);
                nArray = new int[n6];
                for (n2 = 0; n2 < n6; ++n2) {
                    nArray[n2] = sArray[n2];
                }
                break;
            }
            case 3: {
                nArray = unpackedImageData.getIntData(0);
                break;
            }
            case 4: {
                float[] fArray = unpackedImageData.getFloatData(0);
                nArray = new int[n6];
                for (n = 0; n < n6; ++n) {
                    nArray[n] = (int)fArray[n];
                }
                break;
            }
            case 5: {
                double[] dArray = unpackedImageData.getDoubleData(0);
                nArray = new int[n6];
                for (int i = 0; i < n6; ++i) {
                    nArray[i] = (int)dArray[i];
                }
                break;
            }
        }
        int n7 = rectangle.x + rectangle.width;
        n4 = rectangle.y + rectangle.height;
        n3 = 0;
        for (n2 = rectangle.y; n2 < n4; ++n2) {
            for (n = rectangle.x; n < n7; ++n) {
                Object object = this.colorModel.getDataElements(nArray, n3, (Object)null);
                writableRaster.setDataElements(n, n2, object);
                n3 += this.numComponents;
            }
        }
    }

    public UnpackedImageData getComponentsRGB(Raster raster, Rectangle rectangle) {
        if (!this.hasCompatibleCM) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor5"));
        }
        if (!raster.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        int n = rectangle.width * rectangle.height;
        byte[][] byArray = new byte[4][n];
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        byte[] byArray5 = byArray[3];
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        if (this.isIndexCM) {
            IndexColorModel indexColorModel = (IndexColorModel)this.colorModel;
            int n4 = indexColorModel.getMapSize();
            byte[] byArray6 = new byte[n4];
            indexColorModel.getReds(byArray6);
            byte[] byArray7 = new byte[n4];
            indexColorModel.getGreens(byArray7);
            byte[] byArray8 = new byte[n4];
            indexColorModel.getBlues(byArray8);
            byte[] byArray9 = null;
            if (indexColorModel.hasAlpha()) {
                byArray9 = new byte[n4];
                indexColorModel.getAlphas(byArray9);
            }
            int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
            if (byArray9 == null) {
                int n5 = 0;
                for (int i = rectangle.y; i < n3; ++i) {
                    for (int j = rectangle.x; j < n2; ++j) {
                        int n6 = nArray[n5];
                        byArray2[n5] = byArray6[n6];
                        byArray3[n5] = byArray7[n6];
                        byArray4[n5] = byArray8[n6];
                        ++n5;
                    }
                }
            } else {
                int n7 = 0;
                for (int i = rectangle.y; i < n3; ++i) {
                    for (int j = rectangle.x; j < n2; ++j) {
                        int n8 = nArray[n7];
                        byArray2[n7] = byArray6[n8];
                        byArray3[n7] = byArray7[n8];
                        byArray4[n7] = byArray8[n8];
                        byArray5[n7] = byArray9[n8];
                        ++n7;
                    }
                }
            }
        } else {
            int n9 = 0;
            for (int i = rectangle.y; i < n3; ++i) {
                for (int j = rectangle.x; j < n2; ++j) {
                    Object object = raster.getDataElements(j, i, null);
                    byArray2[n9] = (byte)this.colorModel.getRed(object);
                    byArray3[n9] = (byte)this.colorModel.getGreen(object);
                    byArray4[n9] = (byte)this.colorModel.getBlue(object);
                    byArray5[n9] = (byte)this.colorModel.getAlpha(object);
                    ++n9;
                }
            }
        }
        return new UnpackedImageData(raster, rectangle, 0, byArray, 1, rectangle.width, new int[4], raster instanceof WritableRaster);
    }

    public void setComponentsRGB(UnpackedImageData unpackedImageData) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!unpackedImageData.convertToDest) {
            return;
        }
        byte[][] byArray = unpackedImageData.getByteData();
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        byte[] byArray5 = byArray[3];
        WritableRaster writableRaster = (WritableRaster)unpackedImageData.raster;
        Rectangle rectangle = unpackedImageData.rect;
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = 0;
        for (int i = rectangle.y; i < n2; ++i) {
            for (int j = rectangle.x; j < n; ++j) {
                int n4 = byArray5[n3] << 24 | byArray4[n3] << 16 | byArray3[n3] << 8 | byArray2[n3];
                Object object = this.colorModel.getDataElements(n4, null);
                writableRaster.setDataElements(j, i, object);
                ++n3;
            }
        }
    }
}

