/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PointOpImage;

public abstract class ColormapOpImage
extends PointOpImage {
    private boolean isInitialized = false;
    private boolean isColormapAccelerated = true;

    public ColormapOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl) {
        super(renderedImage, imageLayout, map, bl);
        Boolean bl2;
        Boolean bl3 = bl2 = map == null ? Boolean.TRUE : (Boolean)map.get(JAI.KEY_TRANSFORM_ON_COLORMAP);
        if (bl2 != null) {
            this.isColormapAccelerated = bl2;
        }
    }

    protected final boolean isColormapOperation() {
        return this.isColormapAccelerated;
    }

    protected final void initializeColormapOperation() {
        ColorModel colorModel = this.getSource(0).getColorModel();
        ColorModel colorModel2 = super.getColorModel();
        this.isColormapAccelerated &= colorModel != null && colorModel2 != null && colorModel instanceof IndexColorModel && colorModel2 instanceof IndexColorModel;
        this.isInitialized = true;
        if (this.isColormapAccelerated) {
            byte[] byArray;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel2;
            int n = indexColorModel.getMapSize();
            byte[][] byArray2 = new byte[3][n];
            indexColorModel.getReds(byArray2[0]);
            indexColorModel.getGreens(byArray2[1]);
            indexColorModel.getBlues(byArray2[2]);
            this.transformColormap(byArray2);
            for (int i = 0; i < 3; ++i) {
                int n2 = 255 >> 8 - indexColorModel.getComponentSize(i);
                if (n2 >= 255) continue;
                byArray = byArray2[i];
                for (int j = 0; j < n; ++j) {
                    if ((byArray[j] & 0xFF) <= n2) continue;
                    byArray[j] = (byte)n2;
                }
            }
            byte[] byArray3 = byArray2[0];
            byte[] byArray4 = byArray2[1];
            byArray = byArray2[2];
            int[] nArray = new int[n];
            if (indexColorModel.hasAlpha()) {
                byte[] byArray5 = new byte[n];
                indexColorModel.getAlphas(byArray5);
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (byArray5[i] & 0xFF) << 24 | (byArray3[i] & 0xFF) << 16 | (byArray4[i] & 0xFF) << 8 | byArray[i] & 0xFF;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (byArray3[i] & 0xFF) << 16 | (byArray4[i] & 0xFF) << 8 | byArray[i] & 0xFF;
                }
            }
            this.colorModel = new IndexColorModel(indexColorModel.getPixelSize(), n, nArray, 0, indexColorModel.hasAlpha(), indexColorModel.getTransparentPixel(), this.sampleModel.getTransferType());
        }
    }

    protected abstract void transformColormap(byte[][] var1);
}

