/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.util.Vector;
import javax.media.jai.PlanarImage;

public class PlanarImageProducer
implements ImageProducer {
    PlanarImage im;
    Vector consumers = new Vector();

    public PlanarImageProducer(PlanarImage planarImage) {
        this.im = planarImage.createSnapshot();
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (!this.consumers.contains(imageConsumer)) {
            this.consumers.add(imageConsumer);
        }
        this.produceImage();
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.remove(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (!this.consumers.contains(imageConsumer)) {
            this.consumers.add(imageConsumer);
        }
        this.produceImage();
    }

    private synchronized void produceImage() {
        Object object;
        int n;
        int n2 = this.consumers.size();
        int n3 = this.im.getMinX();
        int n4 = this.im.getMinY();
        int n5 = this.im.getWidth();
        int n6 = this.im.getHeight();
        int n7 = this.im.getSampleModel().getNumBands();
        int n8 = n5 * n7;
        ColorModel colorModel = this.im.getColorModel();
        int[] nArray = new int[n8];
        Rectangle rectangle = new Rectangle(n3, n4, n5, 1);
        for (n = 0; n < n2; ++n) {
            object = (ImageConsumer)this.consumers.elementAt(n);
            object.setHints(22);
        }
        for (n = n4; n < n4 + n6; ++n) {
            rectangle.y = n;
            object = this.im.getData(rectangle);
            ((Raster)object).getPixels(n3, n, n5, 1, nArray);
            for (int i = 0; i < n2; ++i) {
                ImageConsumer imageConsumer = (ImageConsumer)this.consumers.elementAt(i);
                imageConsumer.setPixels(0, n - n4, n5, 1, colorModel, nArray, 0, n8);
            }
        }
        for (n = 0; n < n2; ++n) {
            object = (ImageConsumer)this.consumers.elementAt(n);
            object.imageComplete(3);
        }
    }
}

