/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.TransposeOpImage;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;

final class TransposeBinaryOpImage
extends TransposeOpImage {
    private static ImageLayout layoutHelper(ImageLayout imageLayout, SampleModel sampleModel, ColorModel colorModel) {
        ImageLayout imageLayout2 = imageLayout != null ? (ImageLayout)imageLayout.clone() : new ImageLayout();
        imageLayout2.setSampleModel(sampleModel);
        imageLayout2.setColorModel(colorModel);
        return imageLayout2;
    }

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            }
        }
        return map2;
    }

    public TransposeBinaryOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n) {
        super(renderedImage, TransposeBinaryOpImage.configHelper(map), TransposeBinaryOpImage.layoutHelper(imageLayout, renderedImage.getSampleModel(), renderedImage.getColorModel()), n);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        int n = multiPixelPackedSampleModel.getScanlineStride();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 8;
        int n7 = raster.getSampleModel().getDataType();
        if (n7 == 1) {
            n6 = 16;
        } else if (n7 == 3) {
            n6 = 32;
        }
        PlanarImage planarImage = this.getSource(0);
        int n8 = planarImage.getMinX();
        int n9 = planarImage.getMinY();
        int n10 = planarImage.getWidth();
        int n11 = planarImage.getHeight();
        int n12 = n8 + n10 - 1;
        int n13 = n9 + n11 - 1;
        int[] nArray = new int[]{rectangle.x, rectangle.y};
        TransposeBinaryOpImage.mapPoint(nArray, n8, n9, n12, n13, this.type, false);
        n4 = nArray[0];
        n5 = nArray[1];
        switch (this.type) {
            case 0: {
                n2 = 1;
                n3 = -n6 * n;
                break;
            }
            case 1: {
                n2 = -1;
                n3 = n6 * n;
                break;
            }
            case 2: {
                n2 = n6 * n;
                n3 = 1;
                break;
            }
            case 3: {
                n2 = -n6 * n;
                n3 = -1;
                break;
            }
            case 4: {
                n2 = -n6 * n;
                n3 = 1;
                break;
            }
            case 5: {
                n2 = -1;
                n3 = -n6 * n;
                break;
            }
            case 6: {
                n2 = n6 * n;
                n3 = -1;
            }
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, rectangle, n2, n3, n4, n5);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, rectangle, n2, n3, n4, n5);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, rectangle, n2, n3, n4, n5);
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle, int n, int n2, int n3, int n4) {
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n5 = raster.getSampleModelTranslateX();
        int n6 = raster.getSampleModelTranslateY();
        int n7 = multiPixelPackedSampleModel.getDataBitOffset();
        int n8 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n9 = writableRaster.getMinX();
        int n10 = writableRaster.getMinY();
        int n11 = writableRaster.getSampleModelTranslateX();
        int n12 = writableRaster.getSampleModelTranslateY();
        int n13 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n14 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n15 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n16 = dataBufferByte2.getOffset();
        int n17 = rectangle.x;
        int n18 = rectangle.y;
        int n19 = rectangle.width;
        int n20 = rectangle.height;
        int n21 = 8 * (n4 - n6) * n8 + 8 * n15 + (n3 - n5) + n7;
        int n22 = 8 * (n18 - n12) * n14 + 8 * n16 + (n17 - n11) + n13;
        for (int i = 0; i < n20; ++i) {
            int n23;
            int n24;
            int n25;
            int n26;
            byte by;
            int n27;
            int n28 = n21;
            int n29 = n22;
            for (n27 = 0; n27 < n19 && (n29 & 7) != 0; ++n27) {
                by = byArray[n28 >> 3];
                n26 = by >> 7 - (n28 & 7) & 1;
                n25 = n29 >> 3;
                n24 = 7 - (n29 & 7);
                n23 = byArray2[n25];
                byArray2[n25] = (byte)(n23 |= n26 << n24);
                n28 += n;
                ++n29;
            }
            n25 = n29 >> 3;
            if ((n & 7) == 0) {
                n24 = 7 - (n28 & 7);
                int n30 = n28 >> 3;
                int n31 = n >> 3;
                while (n27 < n19 - 7) {
                    by = byArray[n30];
                    n26 = by >> n24 & 1;
                    n23 = n26 << 7;
                    by = byArray[n30 += n31];
                    n26 = by >> n24 & 1;
                    n23 |= n26 << 6;
                    by = byArray[n30 += n31];
                    n26 = by >> n24 & 1;
                    n23 |= n26 << 5;
                    by = byArray[n30 += n31];
                    n26 = by >> n24 & 1;
                    n23 |= n26 << 4;
                    by = byArray[n30 += n31];
                    n26 = by >> n24 & 1;
                    n23 |= n26 << 3;
                    by = byArray[n30 += n31];
                    n26 = by >> n24 & 1;
                    n23 |= n26 << 2;
                    by = byArray[n30 += n31];
                    n26 = by >> n24 & 1;
                    n23 |= n26 << 1;
                    by = byArray[n30 += n31];
                    n26 = by >> n24 & 1;
                    n30 += n31;
                    byArray2[n25] = (byte)(n23 |= n26);
                    n28 += 8 * n;
                    n29 += 8;
                    n27 += 8;
                    ++n25;
                }
            } else {
                while (n27 < n19 - 7) {
                    by = byArray[n28 >> 3];
                    n26 = by >> 7 - (n28 & 7) & 1;
                    n23 = n26 << 7;
                    by = byArray[(n28 += n) >> 3];
                    n26 = by >> 7 - (n28 & 7) & 1;
                    n23 |= n26 << 6;
                    by = byArray[(n28 += n) >> 3];
                    n26 = by >> 7 - (n28 & 7) & 1;
                    n23 |= n26 << 5;
                    by = byArray[(n28 += n) >> 3];
                    n26 = by >> 7 - (n28 & 7) & 1;
                    n23 |= n26 << 4;
                    by = byArray[(n28 += n) >> 3];
                    n26 = by >> 7 - (n28 & 7) & 1;
                    n23 |= n26 << 3;
                    by = byArray[(n28 += n) >> 3];
                    n26 = by >> 7 - (n28 & 7) & 1;
                    n23 |= n26 << 2;
                    by = byArray[(n28 += n) >> 3];
                    n26 = by >> 7 - (n28 & 7) & 1;
                    n23 |= n26 << 1;
                    by = byArray[(n28 += n) >> 3];
                    n26 = by >> 7 - (n28 & 7) & 1;
                    n28 += n;
                    byArray2[n25] = (byte)(n23 |= n26);
                    n29 += 8;
                    n27 += 8;
                    ++n25;
                }
            }
            while (n27 < n19) {
                by = byArray[n28 >> 3];
                n26 = by >> 7 - (n28 & 7) & 1;
                n25 = n29 >> 3;
                n24 = 7 - (n29 & 7);
                n23 = byArray2[n25];
                byArray2[n25] = (byte)(n23 |= n26 << n24);
                n28 += n;
                ++n29;
                ++n27;
            }
            n21 += n2;
            n22 += 8 * n14;
        }
    }

    private void shortLoop(Raster raster, Raster raster2, Rectangle rectangle, int n, int n2, int n3, int n4) {
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        int n5 = raster.getSampleModelTranslateX();
        int n6 = raster.getSampleModelTranslateY();
        int n7 = multiPixelPackedSampleModel.getDataBitOffset();
        int n8 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)raster2.getSampleModel();
        DataBufferUShort dataBufferUShort2 = (DataBufferUShort)raster2.getDataBuffer();
        int n9 = raster2.getMinX();
        int n10 = raster2.getMinY();
        int n11 = raster2.getSampleModelTranslateX();
        int n12 = raster2.getSampleModelTranslateY();
        int n13 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n14 = multiPixelPackedSampleModel2.getScanlineStride();
        short[] sArray = dataBufferUShort.getData();
        int n15 = dataBufferUShort.getOffset();
        short[] sArray2 = dataBufferUShort2.getData();
        int n16 = dataBufferUShort2.getOffset();
        int n17 = rectangle.x;
        int n18 = rectangle.y;
        int n19 = rectangle.width;
        int n20 = rectangle.height;
        int n21 = 16 * (n4 - n6) * n8 + 16 * n15 + (n3 - n5) + n7;
        int n22 = 16 * (n18 - n12) * n14 + 16 * n16 + (n17 - n11) + n13;
        for (int i = 0; i < n20; ++i) {
            int n23;
            int n24;
            int n25;
            int n26;
            short s;
            int n27;
            int n28 = n21;
            int n29 = n22;
            for (n27 = 0; n27 < n19 && (n29 & 0xF) != 0; ++n27) {
                s = sArray[n28 >> 4];
                n26 = s >> 15 - (n28 & 0xF) & 1;
                n25 = n29 >> 4;
                n24 = 15 - (n29 & 0xF);
                n23 = sArray2[n25];
                sArray2[n25] = (short)(n23 |= n26 << n24);
                n28 += n;
                ++n29;
            }
            n25 = n29 >> 4;
            if ((n & 0xF) == 0) {
                n24 = 15 - (n28 & 5);
                int n30 = n28 >> 4;
                int n31 = n >> 4;
                while (n27 < n19 - 15) {
                    n23 = 0;
                    for (int j = 15; j >= 0; --j) {
                        s = sArray[n30];
                        n26 = s >> n24 & 1;
                        n23 |= n26 << j;
                        n30 += n31;
                    }
                    sArray2[n25] = (short)n23;
                    n28 += 16 * n;
                    n29 += 16;
                    n27 += 16;
                    ++n25;
                }
            } else {
                while (n27 < n19 - 15) {
                    n23 = 0;
                    for (n24 = 15; n24 >= 0; --n24) {
                        s = sArray[n28 >> 4];
                        n26 = s >> 15 - (n28 & 0xF) & 1;
                        n23 |= n26 << n24;
                        n28 += n;
                    }
                    sArray2[n25] = (short)n23;
                    n29 += 15;
                    n27 += 16;
                    ++n25;
                }
            }
            while (n27 < n19) {
                s = sArray[n28 >> 4];
                n26 = s >> 15 - (n28 & 0xF) & 1;
                n25 = n29 >> 4;
                n24 = 15 - (n29 & 0xF);
                n23 = sArray2[n25];
                sArray2[n25] = (short)(n23 |= n26 << n24);
                n28 += n;
                ++n29;
                ++n27;
            }
            n21 += n2;
            n22 += 16 * n14;
        }
    }

    private void intLoop(Raster raster, Raster raster2, Rectangle rectangle, int n, int n2, int n3, int n4) {
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n5 = raster.getSampleModelTranslateX();
        int n6 = raster.getSampleModelTranslateY();
        int n7 = multiPixelPackedSampleModel.getDataBitOffset();
        int n8 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)raster2.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster2.getDataBuffer();
        int n9 = raster2.getMinX();
        int n10 = raster2.getMinY();
        int n11 = raster2.getSampleModelTranslateX();
        int n12 = raster2.getSampleModelTranslateY();
        int n13 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n14 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray = dataBufferInt.getData();
        int n15 = dataBufferInt.getOffset();
        int[] nArray2 = dataBufferInt2.getData();
        int n16 = dataBufferInt2.getOffset();
        int n17 = rectangle.x;
        int n18 = rectangle.y;
        int n19 = rectangle.width;
        int n20 = rectangle.height;
        int n21 = 32 * (n4 - n6) * n8 + 32 * n15 + (n3 - n5) + n7;
        int n22 = 32 * (n18 - n12) * n14 + 32 * n16 + (n17 - n11) + n13;
        for (int i = 0; i < n20; ++i) {
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            int n29 = n21;
            int n30 = n22;
            for (n28 = 0; n28 < n19 && (n30 & 0x1F) != 0; ++n28) {
                n27 = nArray[n29 >> 5];
                n26 = n27 >> 31 - (n29 & 0x1F) & 1;
                n25 = n30 >> 5;
                n24 = 31 - (n30 & 0x1F);
                n23 = nArray2[n25];
                nArray2[n25] = n23 |= n26 << n24;
                n29 += n;
                ++n30;
            }
            n25 = n30 >> 5;
            if ((n & 0x1F) == 0) {
                n24 = 31 - (n29 & 5);
                int n31 = n29 >> 5;
                int n32 = n >> 5;
                while (n28 < n19 - 31) {
                    n23 = 0;
                    for (int j = 31; j >= 0; --j) {
                        n27 = nArray[n31];
                        n26 = n27 >> n24 & 1;
                        n23 |= n26 << j;
                        n31 += n32;
                    }
                    nArray2[n25] = n23;
                    n29 += 32 * n;
                    n30 += 32;
                    n28 += 32;
                    ++n25;
                }
            } else {
                while (n28 < n19 - 31) {
                    n23 = 0;
                    for (n24 = 31; n24 >= 0; --n24) {
                        n27 = nArray[n29 >> 5];
                        n26 = n27 >> 31 - (n29 & 0x1F) & 1;
                        n23 |= n26 << n24;
                        n29 += n;
                    }
                    nArray2[n25] = n23;
                    n30 += 31;
                    n28 += 32;
                    ++n25;
                }
            }
            while (n28 < n19) {
                n27 = nArray[n29 >> 5];
                n26 = n27 >> 31 - (n29 & 0x1F) & 1;
                n25 = n30 >> 5;
                n24 = 31 - (n30 & 0x1F);
                n23 = nArray2[n25];
                nArray2[n25] = n23 |= n26 << n24;
                n29 += n;
                ++n30;
                ++n28;
            }
            n21 += n2;
            n22 += 32 * n14;
        }
    }
}

