/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class MagnitudePhaseOpImage
extends PointOpImage {
    public static final int MAGNITUDE = 1;
    public static final int MAGNITUDE_SQUARED = 2;
    public static final int PHASE = 3;
    protected int operationType;
    private double phaseGain = 1.0;
    private double phaseBias = 0.0;

    public MagnitudePhaseOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n) {
        super(renderedImage, imageLayout, map, true);
        int n2;
        this.operationType = n;
        boolean bl = false;
        int n3 = this.sampleModel.getTransferType();
        if (imageLayout != null && n3 != imageLayout.getSampleModel(renderedImage).getTransferType()) {
            n3 = imageLayout.getSampleModel(renderedImage).getTransferType();
            bl = true;
        }
        if ((n2 = this.sampleModel.getNumBands()) > renderedImage.getSampleModel().getNumBands() / 2) {
            n2 = renderedImage.getSampleModel().getNumBands() / 2;
            bl = true;
        }
        if (bl) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, n3, this.sampleModel.getWidth(), this.sampleModel.getHeight(), n2);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        if (n == 3) {
            switch (n3) {
                case 0: {
                    this.phaseGain = 40.58451048843331;
                    this.phaseBias = Math.PI;
                    break;
                }
                case 2: {
                    this.phaseGain = 5215.030020292134;
                    this.phaseBias = Math.PI;
                    break;
                }
                case 1: {
                    this.phaseGain = 10430.219195527361;
                    this.phaseBias = Math.PI;
                    break;
                }
                case 3: {
                    this.phaseGain = 3.4178263762906086E8;
                    this.phaseBias = Math.PI;
                    break;
                }
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rectangle.height, rectangle.width);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rectangle.height, rectangle.width);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rectangle.height, rectangle.width);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rectangle.height, rectangle.width);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rectangle.height, rectangle.width);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rectangle.height, rectangle.width);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("MagnitudePhaseOpImage0"));
            }
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, int n, int n2) {
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = this.sampleModel.getNumBands();
        for (int i = 0; i < n7; ++i) {
            int n8 = 2 * i;
            int n9 = n8 + 1;
            double[] dArray = rasterAccessor.getDoubleDataArray(n8);
            double[] dArray2 = rasterAccessor.getDoubleDataArray(n9);
            double[] dArray3 = rasterAccessor2.getDoubleDataArray(i);
            int n10 = rasterAccessor.getBandOffset(n8);
            int n11 = rasterAccessor.getBandOffset(n9);
            int n12 = rasterAccessor2.getBandOffset(i);
            int n13 = n10;
            int n14 = n11;
            int n15 = n12;
            for (int j = 0; j < n; ++j) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                switch (this.operationType) {
                    case 1: {
                        double d;
                        double d2;
                        int n19;
                        for (n19 = 0; n19 < n2; ++n19) {
                            d2 = dArray[n16];
                            d = dArray2[n17];
                            dArray3[n18] = Math.sqrt(d2 * d2 + d * d);
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 2: {
                        double d;
                        double d2;
                        int n19;
                        for (n19 = 0; n19 < n2; ++n19) {
                            d2 = dArray[n16];
                            d = dArray2[n17];
                            dArray3[n18] = d2 * d2 + d * d;
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 3: {
                        double d;
                        double d2;
                        int n19;
                        for (n19 = 0; n19 < n2; ++n19) {
                            d2 = dArray[n16];
                            d = dArray2[n17];
                            dArray3[n18] = Math.atan2(d, d2);
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                }
                n13 += n4;
                n14 += n4;
                n15 += n6;
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, int n, int n2) {
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = this.sampleModel.getNumBands();
        for (int i = 0; i < n7; ++i) {
            int n8 = 2 * i;
            int n9 = n8 + 1;
            float[] fArray = rasterAccessor.getFloatDataArray(n8);
            float[] fArray2 = rasterAccessor.getFloatDataArray(n9);
            float[] fArray3 = rasterAccessor2.getFloatDataArray(i);
            int n10 = rasterAccessor.getBandOffset(n8);
            int n11 = rasterAccessor.getBandOffset(n9);
            int n12 = rasterAccessor2.getBandOffset(i);
            int n13 = n10;
            int n14 = n11;
            int n15 = n12;
            for (int j = 0; j < n; ++j) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                switch (this.operationType) {
                    case 1: {
                        float f;
                        float f2;
                        int n19;
                        for (n19 = 0; n19 < n2; ++n19) {
                            f2 = fArray[n16];
                            f = fArray2[n17];
                            fArray3[n18] = ImageUtil.clampFloat(Math.sqrt(f2 * f2 + f * f));
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 2: {
                        float f;
                        float f2;
                        int n19;
                        for (n19 = 0; n19 < n2; ++n19) {
                            f2 = fArray[n16];
                            f = fArray2[n17];
                            fArray3[n18] = f2 * f2 + f * f;
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 3: {
                        float f;
                        float f2;
                        int n19;
                        for (n19 = 0; n19 < n2; ++n19) {
                            f2 = fArray[n16];
                            f = fArray2[n17];
                            fArray3[n18] = ImageUtil.clampFloat(Math.atan2(f, f2));
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                }
                n13 += n4;
                n14 += n4;
                n15 += n6;
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, int n, int n2) {
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = this.sampleModel.getNumBands();
        for (int i = 0; i < n7; ++i) {
            int n8 = 2 * i;
            int n9 = n8 + 1;
            int[] nArray = rasterAccessor.getIntDataArray(n8);
            int[] nArray2 = rasterAccessor.getIntDataArray(n9);
            int[] nArray3 = rasterAccessor2.getIntDataArray(i);
            int n10 = rasterAccessor.getBandOffset(n8);
            int n11 = rasterAccessor.getBandOffset(n9);
            int n12 = rasterAccessor2.getBandOffset(i);
            int n13 = n10;
            int n14 = n11;
            int n15 = n12;
            for (int j = 0; j < n; ++j) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                switch (this.operationType) {
                    case 1: {
                        int n19;
                        int n20;
                        int n21;
                        for (n21 = 0; n21 < n2; ++n21) {
                            n20 = nArray[n16];
                            n19 = nArray2[n17];
                            nArray3[n18] = ImageUtil.clampRoundInt(Math.sqrt(n20 * n20 + n19 * n19));
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 2: {
                        int n19;
                        int n20;
                        int n21;
                        for (n21 = 0; n21 < n2; ++n21) {
                            n20 = nArray[n16];
                            n19 = nArray2[n17];
                            nArray3[n18] = n20 * n20 + n19 * n19;
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 3: {
                        int n19;
                        int n20;
                        int n21;
                        for (n21 = 0; n21 < n2; ++n21) {
                            n20 = nArray[n16];
                            n19 = nArray2[n17];
                            nArray3[n18] = ImageUtil.clampRoundInt((Math.atan2(n19, n20) + this.phaseBias) * this.phaseGain);
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                }
                n13 += n4;
                n14 += n4;
                n15 += n6;
            }
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, int n, int n2) {
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = this.sampleModel.getNumBands();
        for (int i = 0; i < n7; ++i) {
            int n8 = 2 * i;
            int n9 = n8 + 1;
            short[] sArray = rasterAccessor.getShortDataArray(n8);
            short[] sArray2 = rasterAccessor.getShortDataArray(n9);
            short[] sArray3 = rasterAccessor2.getShortDataArray(i);
            int n10 = rasterAccessor.getBandOffset(n8);
            int n11 = rasterAccessor.getBandOffset(n9);
            int n12 = rasterAccessor2.getBandOffset(i);
            int n13 = n10;
            int n14 = n11;
            int n15 = n12;
            for (int j = 0; j < n; ++j) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                switch (this.operationType) {
                    case 1: {
                        int n19;
                        int n20;
                        int n21;
                        for (n21 = 0; n21 < n2; ++n21) {
                            n20 = sArray[n16] & 0xFFFF;
                            n19 = sArray2[n17] & 0xFFFF;
                            sArray3[n18] = ImageUtil.clampRoundUShort(Math.sqrt(n20 * n20 + n19 * n19));
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 2: {
                        int n19;
                        int n20;
                        int n21;
                        for (n21 = 0; n21 < n2; ++n21) {
                            n20 = sArray[n16] & 0xFFFF;
                            n19 = sArray2[n17] & 0xFFFF;
                            sArray3[n18] = ImageUtil.clampUShort(n20 * n20 + n19 * n19);
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 3: {
                        int n19;
                        int n20;
                        int n21;
                        for (n21 = 0; n21 < n2; ++n21) {
                            n20 = sArray[n16] & 0xFFFF;
                            n19 = sArray2[n17] & 0xFFFF;
                            sArray3[n18] = ImageUtil.clampRoundUShort((Math.atan2(n19, n20) + this.phaseBias) * this.phaseGain);
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                }
                n13 += n4;
                n14 += n4;
                n15 += n6;
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, int n, int n2) {
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = this.sampleModel.getNumBands();
        for (int i = 0; i < n7; ++i) {
            int n8 = 2 * i;
            int n9 = n8 + 1;
            short[] sArray = rasterAccessor.getShortDataArray(n8);
            short[] sArray2 = rasterAccessor.getShortDataArray(n9);
            short[] sArray3 = rasterAccessor2.getShortDataArray(i);
            int n10 = rasterAccessor.getBandOffset(n8);
            int n11 = rasterAccessor.getBandOffset(n9);
            int n12 = rasterAccessor2.getBandOffset(i);
            int n13 = n10;
            int n14 = n11;
            int n15 = n12;
            for (int j = 0; j < n; ++j) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                switch (this.operationType) {
                    case 1: {
                        short s;
                        short s2;
                        int n19;
                        for (n19 = 0; n19 < n2; ++n19) {
                            s2 = sArray[n16];
                            s = sArray2[n17];
                            sArray3[n18] = ImageUtil.clampRoundShort(Math.sqrt(s2 * s2 + s * s));
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 2: {
                        short s;
                        short s2;
                        int n19;
                        for (n19 = 0; n19 < n2; ++n19) {
                            s2 = sArray[n16];
                            s = sArray2[n17];
                            sArray3[n18] = ImageUtil.clampShort(s2 * s2 + s * s);
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 3: {
                        short s;
                        short s2;
                        int n19;
                        for (n19 = 0; n19 < n2; ++n19) {
                            s2 = sArray[n16];
                            s = sArray2[n17];
                            sArray3[n18] = ImageUtil.clampRoundShort((Math.atan2(s, s2) + this.phaseBias) * this.phaseGain);
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                }
                n13 += n4;
                n14 += n4;
                n15 += n6;
            }
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, int n, int n2) {
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = this.sampleModel.getNumBands();
        for (int i = 0; i < n7; ++i) {
            int n8 = 2 * i;
            int n9 = n8 + 1;
            byte[] byArray = rasterAccessor.getByteDataArray(n8);
            byte[] byArray2 = rasterAccessor.getByteDataArray(n9);
            byte[] byArray3 = rasterAccessor2.getByteDataArray(i);
            int n10 = rasterAccessor.getBandOffset(n8);
            int n11 = rasterAccessor.getBandOffset(n9);
            int n12 = rasterAccessor2.getBandOffset(i);
            int n13 = n10;
            int n14 = n11;
            int n15 = n12;
            for (int j = 0; j < n; ++j) {
                int n16 = n13;
                int n17 = n14;
                int n18 = n15;
                switch (this.operationType) {
                    case 1: {
                        int n19;
                        int n20;
                        int n21;
                        for (n21 = 0; n21 < n2; ++n21) {
                            n20 = byArray[n16] & 0xFF;
                            n19 = byArray2[n17] & 0xFF;
                            byArray3[n18] = ImageUtil.clampRoundByte(Math.sqrt(n20 * n20 + n19 * n19));
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 2: {
                        int n19;
                        int n20;
                        int n21;
                        for (n21 = 0; n21 < n2; ++n21) {
                            n20 = byArray[n16] & 0xFF;
                            n19 = byArray2[n17] & 0xFF;
                            byArray3[n18] = ImageUtil.clampByte(n20 * n20 + n19 * n19);
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                    case 3: {
                        int n19;
                        int n20;
                        int n21;
                        for (n21 = 0; n21 < n2; ++n21) {
                            n20 = byArray[n16] & 0xFF;
                            n19 = byArray2[n17] & 0xFF;
                            byArray3[n18] = ImageUtil.clampRoundByte((Math.atan2(n19, n20) + this.phaseBias) * this.phaseGain);
                            n16 += n3;
                            n17 += n3;
                            n18 += n5;
                        }
                        break;
                    }
                }
                n13 += n4;
                n14 += n4;
                n15 += n6;
            }
        }
    }
}

