/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class FilteredSubsampleOpImage
extends GeometricOpImage {
    protected int scaleX;
    protected int scaleY;
    protected int hParity;
    protected int vParity;
    protected float[] hKernel;
    protected float[] vKernel;

    private static float[] convolveFullKernels(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        int n2 = fArray2.length;
        float[] fArray3 = new float[n + n2 - 1];
        for (int i = 0; i < fArray3.length; ++i) {
            for (int j = Math.max(0, i - n2 + 1); j <= Math.min(i, n - 1); ++j) {
                int n3 = i;
                fArray3[n3] = fArray3[n3] + fArray[j] * fArray2[i - j];
            }
        }
        return fArray3;
    }

    private static float[] convolveSymmetricKernels(int n, int n2, float[] fArray, float[] fArray2) {
        int n3;
        int n4 = fArray.length;
        int n5 = fArray2.length;
        int n6 = 2 * n4 - n;
        int n7 = 2 * n5 - n2;
        int n8 = n6 + n7 - 1;
        float[] fArray3 = new float[n6];
        float[] fArray4 = new float[n7];
        float[] fArray5 = new float[(n8 + 1) / 2];
        for (n3 = 0; n3 < n6; ++n3) {
            fArray3[n3] = fArray[Math.abs(n3 - n4 + (n - 1) * (n3 / n4) + 1)];
        }
        for (n3 = 0; n3 < n7; ++n3) {
            fArray4[n3] = fArray2[Math.abs(n3 - n5 + (n2 - 1) * (n3 / n5) + 1)];
        }
        float[] fArray6 = FilteredSubsampleOpImage.convolveFullKernels(fArray3, fArray4);
        n3 = fArray6.length % 2;
        for (int i = 0; i < fArray5.length; ++i) {
            fArray5[i] = fArray6[n8 - fArray5.length - i - 1 + n3];
        }
        return fArray5;
    }

    private static float[] combineFilters(int n, int n2, float[] fArray) {
        if (n % 2 == 1) {
            return (float[])fArray.clone();
        }
        int n3 = 1;
        int n4 = 0;
        switch (n2) {
            case 0: {
                return (float[])fArray.clone();
            }
            case 1: {
                float[] fArray2 = new float[]{0.5f};
                return FilteredSubsampleOpImage.convolveSymmetricKernels(n3, n4, fArray, fArray2);
            }
            case 2: {
                float[] fArray3 = new float[]{0.5625f, -0.0625f};
                return FilteredSubsampleOpImage.convolveSymmetricKernels(n3, n4, fArray, fArray3);
            }
            case 3: {
                float[] fArray4 = new float[]{0.625f, -0.125f};
                return FilteredSubsampleOpImage.convolveSymmetricKernels(n3, n4, fArray, fArray4);
            }
        }
        throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample0"));
    }

    private static int filterParity(int n, int n2) {
        if (n % 2 == 1 || n2 == 0) {
            return 1;
        }
        return 0;
    }

    private static final ImageLayout layoutHelper(RenderedImage renderedImage, Interpolation interpolation, int n, int n2, int n3, ImageLayout imageLayout) {
        ImageLayout imageLayout2;
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample1"));
        }
        if (n3 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample2"));
        }
        Rectangle rectangle = FilteredSubsampleOpImage.forwardMapRect(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), n, n2);
        ImageLayout imageLayout3 = imageLayout2 = imageLayout == null ? new ImageLayout(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : (ImageLayout)imageLayout.clone();
        if (imageLayout != null) {
            imageLayout2.setWidth(rectangle.width);
            imageLayout2.setHeight(rectangle.height);
            imageLayout2.setMinX(rectangle.x);
            imageLayout2.setMinY(rectangle.y);
        }
        return imageLayout2;
    }

    public FilteredSubsampleOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, int n, int n2, float[] fArray, Interpolation interpolation) {
        super(FilteredSubsampleOpImage.vectorize(renderedImage), FilteredSubsampleOpImage.layoutHelper(renderedImage, interpolation, n, n2, fArray.length, imageLayout), map, true, borderExtender, interpolation, null);
        int n3;
        if (interpolation instanceof InterpolationNearest) {
            n3 = 0;
        } else if (interpolation instanceof InterpolationBilinear) {
            n3 = 1;
        } else if (interpolation instanceof InterpolationBicubic) {
            n3 = 2;
        } else if (interpolation instanceof InterpolationBicubic2) {
            n3 = 3;
        } else {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample3"));
        }
        this.hParity = FilteredSubsampleOpImage.filterParity(n, n3);
        this.vParity = FilteredSubsampleOpImage.filterParity(n2, n3);
        this.hKernel = FilteredSubsampleOpImage.combineFilters(n, n3, fArray);
        this.vKernel = FilteredSubsampleOpImage.combineFilters(n2, n3, fArray);
        this.scaleX = n;
        this.scaleY = n2;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() * (double)this.scaleX, point2D.getY() * (double)this.scaleY);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() / (double)this.scaleX, point2D.getY() / (double)this.scaleY);
        return point2D2;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample4"));
        }
        int n2 = rectangle.x + this.hKernel.length - this.hParity - this.scaleX / 2;
        int n3 = rectangle.y + this.vKernel.length - this.vParity - this.scaleY / 2;
        int n4 = rectangle.width - 2 * this.hKernel.length + this.hParity + 1;
        int n5 = rectangle.height - 2 * this.vKernel.length + this.vParity + 1;
        return FilteredSubsampleOpImage.forwardMapRect(n2, n3, n4, n5, this.scaleX, this.scaleY);
    }

    private static final Rectangle forwardMapRect(int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 1.0f / (float)n5;
        float f2 = 1.0f / (float)n6;
        n = Math.round((float)n * f);
        n2 = Math.round((float)n2 * f2);
        return new Rectangle(n, n2, Math.round((float)(n + n3) * f) - n, Math.round((float)(n2 + n4) * f2) - n2);
    }

    protected final Rectangle forwardMapRect(Rectangle rectangle, int n) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        float f = 1.0f / (float)this.scaleX;
        float f2 = 1.0f / (float)this.scaleY;
        n2 = Math.round((float)n2 * f);
        n3 = Math.round((float)n3 * f2);
        return new Rectangle(n2, n3, Math.round((float)(n2 + n4) * f) - n2, Math.round((float)(n3 + n5) * f2) - n3);
    }

    protected final Rectangle backwardMapRect(Rectangle rectangle, int n) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        return new Rectangle(n2 * this.scaleX, n3 * this.scaleY, (n2 + n4) * this.scaleX - n2, (n3 + n5) * this.scaleY - n3);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample4"));
        }
        int n2 = rectangle.x * this.scaleX - this.hKernel.length + this.hParity + this.scaleX / 2;
        int n3 = rectangle.y * this.scaleY - this.vKernel.length + this.vParity + this.scaleY / 2;
        int n4 = rectangle.width * this.scaleX + 2 * this.hKernel.length - this.hParity - 1;
        int n5 = rectangle.height * this.scaleY + 2 * this.vKernel.length - this.vParity - 1;
        return new Rectangle(n2, n3, n4, n5);
    }

    public void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], this.mapDestRect(rectangle, 0), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor2, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor2, rasterAccessor);
                break;
            }
            default: {
                throw new IllegalArgumentException(JaiI18N.getString("FilteredSubsample5"));
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    protected void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        float f = this.vKernel[0];
        float f2 = this.hKernel[0];
        for (int i = 0; i < n3; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            for (int j = 0; j < this.scaleY * n2; j += this.scaleY) {
                int n14 = n13;
                for (int k = 0; k < this.scaleX * n; k += this.scaleX) {
                    int n15;
                    float f3;
                    int n16 = k * n6 + j * n7 + n12;
                    int n17 = n16 + n11;
                    int n18 = n16 + n10;
                    int n19 = n17 + n10;
                    float f4 = 0.0f;
                    for (int i2 = this.vKernel.length - 1; i2 > this.vParity - 1; --i2) {
                        int n20 = n16;
                        int n21 = n17;
                        int n22 = n18;
                        int n23 = n19;
                        for (int i3 = this.hKernel.length - 1; i3 > this.hParity - 1; --i3) {
                            f3 = this.hKernel[i3] * this.vKernel[i2];
                            f4 += f3 * (float)((byArray4[n20] & 0xFF) + (byArray4[n21] & 0xFF) + (byArray4[n22] & 0xFF) + (byArray4[n23] & 0xFF));
                            n20 += n6;
                            n21 -= n6;
                            n22 += n6;
                            n23 -= n6;
                        }
                        n16 += n7;
                        n17 += n7;
                        n18 -= n7;
                        n19 -= n7;
                    }
                    if (this.hParity == 1) {
                        int n24 = (k + this.hKernel.length - 1) * n6 + j * n7 + n12;
                        n15 = this.vKernel.length - 1;
                        for (int i4 = n24 + n10; n24 < i4; n24 += n7, i4 -= n7) {
                            f3 = f2 * this.vKernel[n15--];
                            f4 += f3 * (float)((byArray4[n24] & 0xFF) + (byArray4[i4] & 0xFF));
                        }
                    }
                    if (this.vParity == 1) {
                        int n25 = k * n6 + (j + this.vKernel.length - 1) * n7 + n12;
                        n15 = this.hKernel.length - 1;
                        for (int i5 = n25 + n11; n25 < i5; n25 += n6, i5 -= n6) {
                            f3 = f * this.hKernel[n15--];
                            f4 += f3 * (float)((byArray4[n25] & 0xFF) + (byArray4[i5] & 0xFF));
                        }
                        if (this.hParity == 1) {
                            f4 += f * f2 * (float)(byArray4[n25] & 0xFF);
                        }
                    }
                    if ((double)f4 < 0.0) {
                        f4 = 0.0f;
                    }
                    if ((double)f4 > 255.0) {
                        f4 = 255.0f;
                    }
                    byArray3[n14] = (byte)((double)f4 + 0.5);
                    n14 += n4;
                }
                n13 += n5;
            }
        }
    }

    protected void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        float f = this.vKernel[0];
        float f2 = this.hKernel[0];
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            for (int j = 0; j < this.scaleY * n2; j += this.scaleY) {
                int n14 = n13;
                for (int k = 0; k < this.scaleX * n; k += this.scaleX) {
                    int n15;
                    float f3;
                    int n16;
                    int n17 = k * n6 + j * n7 + n12;
                    int n18 = n17 + n11;
                    int n19 = n17 + n10;
                    int n20 = n18 + n10;
                    float f4 = 0.0f;
                    for (n16 = this.vKernel.length - 1; n16 > this.vParity - 1; --n16) {
                        int n21 = n17;
                        int n22 = n18;
                        int n23 = n19;
                        int n24 = n20;
                        for (int i2 = this.hKernel.length - 1; i2 > this.hParity - 1; --i2) {
                            f3 = this.hKernel[i2] * this.vKernel[n16];
                            f4 += f3 * (float)((sArray4[n21] & 0xFFFF) + (sArray4[n22] & 0xFFFF) + (sArray4[n23] & 0xFFFF) + (sArray4[n24] & 0xFFFF));
                            n21 += n6;
                            n22 -= n6;
                            n23 += n6;
                            n24 -= n6;
                        }
                        n17 += n7;
                        n18 += n7;
                        n19 -= n7;
                        n20 -= n7;
                    }
                    if (this.hParity == 1) {
                        int n25 = (k + this.hKernel.length - 1) * n6 + j * n7 + n12;
                        n15 = this.vKernel.length - 1;
                        for (int i3 = n25 + n10; n25 < i3; n25 += n7, i3 -= n7) {
                            f3 = f2 * this.vKernel[n15--];
                            f4 += f3 * (float)((sArray4[n25] & 0xFFFF) + (sArray4[i3] & 0xFFFF));
                        }
                    }
                    if (this.vParity == 1) {
                        int n26 = k * n6 + (j + this.vKernel.length - 1) * n7 + n12;
                        n15 = this.hKernel.length - 1;
                        for (int i4 = n26 + n11; n26 < i4; n26 += n6, i4 -= n6) {
                            f3 = f * this.hKernel[n15--];
                            f4 += f3 * (float)((sArray4[n26] & 0xFFFF) + (sArray4[i4] & 0xFFFF));
                        }
                        if (this.hParity == 1) {
                            f4 += f * f2 * (float)(sArray4[n26] & 0xFFFF);
                        }
                    }
                    sArray3[n14] = (short)((n16 = (int)((double)f4 + 0.5)) > 65535 ? 65535 : (n16 < 0 ? 0 : n16));
                    n14 += n4;
                }
                n13 += n5;
            }
        }
    }

    protected void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        float f = this.vKernel[0];
        float f2 = this.hKernel[0];
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            for (int j = 0; j < this.scaleY * n2; j += this.scaleY) {
                int n14 = n13;
                for (int k = 0; k < this.scaleX * n; k += this.scaleX) {
                    int n15;
                    float f3;
                    int n16 = k * n6 + j * n7 + n12;
                    int n17 = n16 + n11;
                    int n18 = n16 + n10;
                    int n19 = n17 + n10;
                    float f4 = 0.0f;
                    for (int i2 = this.vKernel.length - 1; i2 > this.vParity - 1; --i2) {
                        int n20 = n16;
                        int n21 = n17;
                        int n22 = n18;
                        int n23 = n19;
                        for (int i3 = this.hKernel.length - 1; i3 > this.hParity - 1; --i3) {
                            f3 = this.hKernel[i3] * this.vKernel[i2];
                            f4 += f3 * (float)(sArray4[n20] + sArray4[n21] + sArray4[n22] + sArray4[n23]);
                            n20 += n6;
                            n21 -= n6;
                            n22 += n6;
                            n23 -= n6;
                        }
                        n16 += n7;
                        n17 += n7;
                        n18 -= n7;
                        n19 -= n7;
                    }
                    if (this.hParity == 1) {
                        int n24 = (k + this.hKernel.length - 1) * n6 + j * n7 + n12;
                        n15 = this.vKernel.length - 1;
                        for (int i4 = n24 + n10; n24 < i4; n24 += n7, i4 -= n7) {
                            f3 = f2 * this.vKernel[n15--];
                            f4 += f3 * (float)(sArray4[n24] + sArray4[i4]);
                        }
                    }
                    if (this.vParity == 1) {
                        int n25 = k * n6 + (j + this.vKernel.length - 1) * n7 + n12;
                        n15 = this.hKernel.length - 1;
                        for (int i5 = n25 + n11; n25 < i5; n25 += n6, i5 -= n6) {
                            f3 = f * this.hKernel[n15--];
                            f4 += f3 * (float)(sArray4[n25] + sArray4[i5]);
                        }
                        if (this.hParity == 1) {
                            f4 += f * f2 * (float)sArray4[n25];
                        }
                    }
                    sArray3[n14] = ImageUtil.clampShort((int)((double)f4 + 0.5));
                    n14 += n4;
                }
                n13 += n5;
            }
        }
    }

    protected void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        double d = this.vKernel[0];
        double d2 = this.hKernel[0];
        for (int i = 0; i < n3; ++i) {
            int[] nArray5 = nArray[i];
            int[] nArray6 = nArray3[i];
            int n12 = nArray4[i];
            int n13 = nArray2[i];
            for (int j = 0; j < this.scaleY * n2; j += this.scaleY) {
                int n14 = n13;
                for (int k = 0; k < this.scaleX * n; k += this.scaleX) {
                    int n15;
                    double d3;
                    int n16 = k * n6 + j * n7 + n12;
                    int n17 = n16 + n11;
                    int n18 = n16 + n10;
                    int n19 = n17 + n10;
                    double d4 = 0.0;
                    for (int i2 = this.vKernel.length - 1; i2 > this.vParity - 1; --i2) {
                        int n20 = n16;
                        int n21 = n17;
                        int n22 = n18;
                        int n23 = n19;
                        for (int i3 = this.hKernel.length - 1; i3 > this.hParity - 1; --i3) {
                            d3 = this.hKernel[i3] * this.vKernel[i2];
                            d4 += d3 * (double)((long)nArray6[n20] + (long)nArray6[n21] + (long)nArray6[n22] + (long)nArray6[n23]);
                            n20 += n6;
                            n21 -= n6;
                            n22 += n6;
                            n23 -= n6;
                        }
                        n16 += n7;
                        n17 += n7;
                        n18 -= n7;
                        n19 -= n7;
                    }
                    if (this.hParity == 1) {
                        int n24 = (k + this.hKernel.length - 1) * n6 + j * n7 + n12;
                        n15 = this.vKernel.length - 1;
                        for (int i4 = n24 + n10; n24 < i4; n24 += n7, i4 -= n7) {
                            d3 = d2 * (double)this.vKernel[n15--];
                            d4 += d3 * (double)((long)nArray6[n24] + (long)nArray6[i4]);
                        }
                    }
                    if (this.vParity == 1) {
                        int n25 = k * n6 + (j + this.vKernel.length - 1) * n7 + n12;
                        n15 = this.hKernel.length - 1;
                        for (int i5 = n25 + n11; n25 < i5; n25 += n6, i5 -= n6) {
                            d3 = d * (double)this.hKernel[n15--];
                            d4 += d3 * (double)((long)nArray6[n25] + (long)nArray6[i5]);
                        }
                        if (this.hParity == 1) {
                            d4 += d * d2 * (double)nArray6[n25];
                        }
                    }
                    nArray5[n14] = ImageUtil.clampInt((int)(d4 + 0.5));
                    n14 += n4;
                }
                n13 += n5;
            }
        }
    }

    protected void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        double d = this.vKernel[0];
        double d2 = this.hKernel[0];
        for (int i = 0; i < n3; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            for (int j = 0; j < this.scaleY * n2; j += this.scaleY) {
                int n14 = n13;
                for (int k = 0; k < this.scaleX * n; k += this.scaleX) {
                    int n15;
                    double d3;
                    int n16 = k * n6 + j * n7 + n12;
                    int n17 = n16 + n11;
                    int n18 = n16 + n10;
                    int n19 = n17 + n10;
                    double d4 = 0.0;
                    for (int i2 = this.vKernel.length - 1; i2 > this.vParity - 1; --i2) {
                        int n20 = n16;
                        int n21 = n17;
                        int n22 = n18;
                        int n23 = n19;
                        for (int i3 = this.hKernel.length - 1; i3 > this.hParity - 1; --i3) {
                            d3 = this.hKernel[i3] * this.vKernel[i2];
                            d4 += d3 * ((double)fArray4[n20] + (double)fArray4[n21] + (double)fArray4[n22] + (double)fArray4[n23]);
                            n20 += n6;
                            n21 -= n6;
                            n22 += n6;
                            n23 -= n6;
                        }
                        n16 += n7;
                        n17 += n7;
                        n18 -= n7;
                        n19 -= n7;
                    }
                    if (this.hParity == 1) {
                        int n24 = (k + this.hKernel.length - 1) * n6 + j * n7 + n12;
                        n15 = this.vKernel.length - 1;
                        for (int i4 = n24 + n10; n24 < i4; n24 += n7, i4 -= n7) {
                            d3 = d2 * (double)this.vKernel[n15--];
                            d4 += d3 * ((double)fArray4[n24] + (double)fArray4[i4]);
                        }
                    }
                    if (this.vParity == 1) {
                        int n25 = k * n6 + (j + this.vKernel.length - 1) * n7 + n12;
                        n15 = this.hKernel.length - 1;
                        for (int i5 = n25 + n11; n25 < i5; n25 += n6, i5 -= n6) {
                            d3 = d * (double)this.hKernel[n15--];
                            d4 += d3 * ((double)fArray4[n25] + (double)fArray4[i5]);
                        }
                        if (this.hParity == 1) {
                            d4 += d * d2 * (double)fArray4[n25];
                        }
                    }
                    fArray3[n14] = ImageUtil.clampFloat(d4);
                    n14 += n4;
                }
                n13 += n5;
            }
        }
    }

    protected void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 2 * this.hKernel.length - this.hParity;
        int n9 = 2 * this.vKernel.length - this.vParity;
        int n10 = (n9 - 1) * n7;
        int n11 = (n8 - 1) * n6;
        double d = this.vKernel[0];
        double d2 = this.hKernel[0];
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            for (int j = 0; j < this.scaleY * n2; j += this.scaleY) {
                int n14 = n13;
                for (int k = 0; k < this.scaleX * n; k += this.scaleX) {
                    int n15;
                    double d3;
                    int n16 = k * n6 + j * n7 + n12;
                    int n17 = n16 + n11;
                    int n18 = n16 + n10;
                    int n19 = n17 + n10;
                    double d4 = 0.0;
                    for (int i2 = this.vKernel.length - 1; i2 > this.vParity - 1; --i2) {
                        int n20 = n16;
                        int n21 = n17;
                        int n22 = n18;
                        int n23 = n19;
                        for (int i3 = this.hKernel.length - 1; i3 > this.hParity - 1; --i3) {
                            d3 = this.hKernel[i3] * this.vKernel[i2];
                            d4 += d3 * (dArray4[n20] + dArray4[n21] + dArray4[n22] + dArray4[n23]);
                            n20 += n6;
                            n21 -= n6;
                            n22 += n6;
                            n23 -= n6;
                        }
                        n16 += n7;
                        n17 += n7;
                        n18 -= n7;
                        n19 -= n7;
                    }
                    if (this.hParity == 1) {
                        int n24 = (k + this.hKernel.length - 1) * n6 + j * n7 + n12;
                        n15 = this.vKernel.length - 1;
                        for (int i4 = n24 + n10; n24 < i4; n24 += n7, i4 -= n7) {
                            d3 = d2 * (double)this.vKernel[n15--];
                            d4 += d3 * (dArray4[n24] + dArray4[i4]);
                        }
                    }
                    if (this.vParity == 1) {
                        int n25 = k * n6 + (j + this.vKernel.length - 1) * n7 + n12;
                        n15 = this.hKernel.length - 1;
                        for (int i5 = n25 + n11; n25 < i5; n25 += n6, i5 -= n6) {
                            d3 = d * (double)this.hKernel[n15--];
                            d4 += d3 * (dArray4[n25] + dArray4[i5]);
                        }
                        if (this.hParity == 1) {
                            d4 += d * d2 * dArray4[n25];
                        }
                    }
                    dArray3[n14] = d4;
                    n14 += n4;
                }
                n13 += n5;
            }
        }
    }
}

