/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AndConstOpImage
extends ColormapOpImage {
    protected int[] constants;

    public AndConstOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int[] nArray) {
        super(renderedImage, imageLayout, map, true);
        int n = this.getSampleModel().getNumBands();
        if (nArray.length < n) {
            this.constants = new int[n];
            for (int i = 0; i < n; ++i) {
                this.constants[i] = nArray[0];
            }
        } else {
            this.constants = (int[])nArray.clone();
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        for (int i = 0; i < 3; ++i) {
            byte[] byArray2 = byArray[i];
            int n = byArray2.length;
            int n2 = i < this.constants.length ? this.constants[i] : this.constants[0];
            for (int j = 0; j < n; ++j) {
                byArray2[j] = ImageUtil.clampRoundByte(byArray2[j] & 0xFF & n2);
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: 
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
            }
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        for (int i = 0; i < n3; ++i) {
            int n8 = this.constants[i];
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n9 = nArray[i];
            int n10 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n11 = n9;
                int n12 = n10;
                n9 += n4;
                n10 += n6;
                for (int k = 0; k < n; ++k) {
                    byArray3[n11] = (byte)(byArray4[n12] & n8);
                    n11 += n5;
                    n12 += n7;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        for (int i = 0; i < n3; ++i) {
            int n8 = this.constants[i];
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n9 = nArray[i];
            int n10 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n11 = n9;
                int n12 = n10;
                n9 += n4;
                n10 += n6;
                for (int k = 0; k < n; ++k) {
                    sArray3[n11] = (short)(sArray4[n12] & n8);
                    n11 += n5;
                    n12 += n7;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        for (int i = 0; i < n3; ++i) {
            int n8 = this.constants[i];
            int[] nArray5 = nArray2[i];
            int[] nArray6 = nArray4[i];
            int n9 = nArray[i];
            int n10 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                int n11 = n9;
                int n12 = n10;
                n9 += n4;
                n10 += n6;
                for (int k = 0; k < n; ++k) {
                    nArray5[n11] = nArray6[n12] & n8;
                    n11 += n5;
                    n12 += n7;
                }
            }
        }
    }
}

