/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AffineGeneralOpImage
extends AffineOpImage {
    private int subsampleBits;
    private int shiftvalue;
    private int interp_width;
    private int interp_height;
    private int interp_left;
    private int interp_top;
    private int interp_right;
    private int interp_bottom;

    public AffineGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.shiftvalue = 1 << this.subsampleBits;
        this.interp_width = interpolation.getWidth();
        this.interp_height = interpolation.getHeight();
        this.interp_left = interpolation.getLeftPadding();
        this.interp_top = interpolation.getTopPadding();
        this.interp_right = this.interp_width - this.interp_left - 1;
        this.interp_bottom = this.interp_height - this.interp_top - 1;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        byte[] byArray3 = new byte[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            byArray3[n3] = (byte)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            for (int i = n10; i < n12; ++i) {
                int n19;
                if ((float)n15 >= f + (float)this.interp_left && (float)n15 < f3 - (float)this.interp_right && (float)n16 >= f2 + (float)this.interp_top && (float)n16 < f4 - (float)this.interp_bottom) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        byte[] byArray4 = byArray2[n19];
                        int n20 = nArray3[n19];
                        int n21 = this.interp_left * n7 + this.interp_top * n8;
                        n21 = n17 + n18 - n21;
                        int n22 = 0;
                        int n23 = 0;
                        for (int j = 0; j < this.interp_height; ++j) {
                            int n24 = n21;
                            for (int k = 0; k < this.interp_width; ++k) {
                                nArray[n23][n22++] = byArray4[n21 + n20] & 0xFF;
                                n21 += n7;
                            }
                            ++n23;
                            n22 = 0;
                            n21 = n24 + n8;
                        }
                        int n25 = (int)(f7 * (float)this.shiftvalue);
                        int n26 = (int)(f8 * (float)this.shiftvalue);
                        int n27 = this.interp.interpolate(nArray, n25, n26);
                        int n28 = n27 < 0 ? 0 : (n27 > 255 ? 255 : n27);
                        byArray[n19][n14 + nArray2[n19]] = (byte)(n28 & 0xFF);
                    }
                } else if (this.setBackground) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        byArray[n19][n14 + nArray2[n19]] = byArray3[n19];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        int[][] nArray = new int[this.interp_height][this.interp_width];
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int[] nArray5 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        int[] nArray6 = new int[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            nArray6[n3] = (int)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            for (int i = n10; i < n12; ++i) {
                int n19;
                if ((float)n15 >= f + (float)this.interp_left && (float)n15 < f3 - (float)this.interp_right && (float)n16 >= f2 + (float)this.interp_top && (float)n16 < f4 - (float)this.interp_bottom) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        int[] nArray7 = nArray4[n19];
                        int n20 = nArray5[n19];
                        int n21 = this.interp_left * n7 + this.interp_top * n8;
                        n21 = n17 + n18 - n21;
                        int n22 = 0;
                        int n23 = 0;
                        for (int j = 0; j < this.interp_height; ++j) {
                            int n24 = n21;
                            for (int k = 0; k < this.interp_width; ++k) {
                                nArray[n23][n22++] = nArray7[n21 + n20];
                                n21 += n7;
                            }
                            ++n23;
                            n22 = 0;
                            n21 = n24 + n8;
                        }
                        int n25 = (int)(f7 * (float)this.shiftvalue);
                        int n26 = (int)(f8 * (float)this.shiftvalue);
                        int n27 = this.interp.interpolate(nArray, n25, n26);
                        int n28 = n27 < Integer.MIN_VALUE ? Integer.MIN_VALUE : (n27 > Integer.MAX_VALUE ? Integer.MAX_VALUE : n27);
                        nArray2[n19][n14 + nArray3[n19]] = n28;
                    }
                } else if (this.setBackground) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        nArray2[n19][n14 + nArray3[n19]] = nArray6[n19];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            sArray3[n3] = (short)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            for (int i = n10; i < n12; ++i) {
                int n19;
                if ((float)n15 >= f + (float)this.interp_left && (float)n15 < f3 - (float)this.interp_right && (float)n16 >= f2 + (float)this.interp_top && (float)n16 < f4 - (float)this.interp_bottom) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        short[] sArray4 = sArray2[n19];
                        int n20 = nArray3[n19];
                        int n21 = this.interp_left * n7 + this.interp_top * n8;
                        n21 = n17 + n18 - n21;
                        int n22 = 0;
                        int n23 = 0;
                        for (int j = 0; j < this.interp_height; ++j) {
                            int n24 = n21;
                            for (int k = 0; k < this.interp_width; ++k) {
                                nArray[n23][n22++] = sArray4[n21 + n20];
                                n21 += n7;
                            }
                            ++n23;
                            n22 = 0;
                            n21 = n24 + n8;
                        }
                        int n25 = (int)(f7 * (float)this.shiftvalue);
                        int n26 = (int)(f8 * (float)this.shiftvalue);
                        int n27 = this.interp.interpolate(nArray, n25, n26);
                        int n28 = n27 < Short.MIN_VALUE ? Short.MIN_VALUE : (n27 > Short.MAX_VALUE ? Short.MAX_VALUE : (int)((short)n27));
                        sArray[n19][n14 + nArray2[n19]] = n28;
                    }
                } else if (this.setBackground) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        sArray[n19][n14 + nArray2[n19]] = sArray3[n19];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int[][] nArray = new int[this.interp_height][this.interp_width];
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            sArray3[n3] = (short)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            for (int i = n10; i < n12; ++i) {
                int n19;
                if ((float)n15 >= f + (float)this.interp_left && (float)n15 < f3 - (float)this.interp_right && (float)n16 >= f2 + (float)this.interp_top && (float)n16 < f4 - (float)this.interp_bottom) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        short[] sArray4 = sArray2[n19];
                        int n20 = nArray3[n19];
                        int n21 = this.interp_left * n7 + this.interp_top * n8;
                        n21 = n17 + n18 - n21;
                        int n22 = 0;
                        int n23 = 0;
                        for (int j = 0; j < this.interp_height; ++j) {
                            int n24 = n21;
                            for (int k = 0; k < this.interp_width; ++k) {
                                nArray[n23][n22++] = sArray4[n21 + n20] & 0xFFFF;
                                n21 += n7;
                            }
                            ++n23;
                            n22 = 0;
                            n21 = n24 + n8;
                        }
                        int n25 = (int)(f7 * (float)this.shiftvalue);
                        int n26 = (int)(f8 * (float)this.shiftvalue);
                        int n27 = this.interp.interpolate(nArray, n25, n26);
                        int n28 = n27 < 0 ? 0 : (n27 > 65535 ? 65535 : n27);
                        sArray[n19][n14 + nArray2[n19]] = (short)(n28 & 0xFFFF);
                    }
                } else if (this.setBackground) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        sArray[n19][n14 + nArray2[n19]] = sArray3[n19];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        float[][] fArray = new float[this.interp_height][this.interp_width];
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray3 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        float[] fArray4 = new float[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            fArray4[n3] = (float)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            for (int i = n10; i < n12; ++i) {
                int n19;
                if ((float)n15 >= f + (float)this.interp_left && (float)n15 < f3 - (float)this.interp_right && (float)n16 >= f2 + (float)this.interp_top && (float)n16 < f4 - (float)this.interp_bottom) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        float f9;
                        float[] fArray5 = fArray3[n19];
                        int n20 = nArray2[n19];
                        int n21 = this.interp_left * n7 + this.interp_top * n8;
                        n21 = n17 + n18 - n21;
                        int n22 = 0;
                        int n23 = 0;
                        for (int j = 0; j < this.interp_height; ++j) {
                            int n24 = n21;
                            for (int k = 0; k < this.interp_width; ++k) {
                                fArray[n23][n22++] = fArray5[n21 + n20];
                                n21 += n7;
                            }
                            ++n23;
                            n22 = 0;
                            n21 = n24 + n8;
                        }
                        fArray2[n19][n14 + nArray[n19]] = f9 = this.interp.interpolate(fArray, f7, f8);
                    }
                } else if (this.setBackground) {
                    for (n19 = 0; n19 < n9; ++n19) {
                        fArray2[n19][n14 + nArray[n19]] = fArray4[n19];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    f7 = (float)((double)f7 + this.fracdx);
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    f8 = (float)((double)f8 + this.fracdy);
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        double[][] dArray = new double[this.interp_height][this.interp_width];
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray3 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        for (int i = n10; i < n12; ++i) {
            int n13 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)i + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            double d = ((Point2D)float_2).getX();
            double d2 = ((Point2D)float_2).getY();
            int n14 = (int)Math.floor(d -= 0.5);
            int n15 = (int)Math.floor(d2 -= 0.5);
            double d3 = d - (double)n14;
            double d4 = d2 - (double)n15;
            int n16 = (n14 - n) * n6;
            int n17 = (n15 - n2) * n7;
            for (int j = n9; j < n11; ++j) {
                int n18;
                if ((float)n14 >= f + (float)this.interp_left && (float)n14 < f3 - (float)this.interp_right && (float)n15 >= f2 + (float)this.interp_top && (float)n15 < f4 - (float)this.interp_bottom) {
                    for (n18 = 0; n18 < n8; ++n18) {
                        double d5;
                        double[] dArray4 = dArray3[n18];
                        int n19 = nArray2[n18];
                        int n20 = this.interp_left * n6 + this.interp_top * n7;
                        n20 = n16 + n17 - n20;
                        int n21 = 0;
                        int n22 = 0;
                        for (int k = 0; k < this.interp_height; ++k) {
                            int n23 = n20;
                            for (int i2 = 0; i2 < this.interp_width; ++i2) {
                                dArray[n22][n21++] = dArray4[n20 + n19];
                                n20 += n6;
                            }
                            ++n22;
                            n21 = 0;
                            n20 = n23 + n7;
                        }
                        dArray2[n18][n13 + nArray[n18]] = d5 = this.interp.interpolate(dArray, (float)d3, (float)d4);
                    }
                } else if (this.setBackground) {
                    for (n18 = 0; n18 < n8; ++n18) {
                        dArray2[n18][n13 + nArray[n18]] = this.backgroundValues[n18];
                    }
                }
                if (d3 < this.fracdx1) {
                    n14 += this.incx;
                    d3 += this.fracdx;
                } else {
                    n14 += this.incx1;
                    d3 -= this.fracdx1;
                }
                if (d4 < this.fracdy1) {
                    n15 += this.incy;
                    d4 += this.fracdy;
                } else {
                    n15 += this.incy1;
                    d4 -= this.fracdy1;
                }
                n16 = (n14 - n) * n6;
                n17 = (n15 - n2) * n7;
                n13 += n4;
            }
            n3 += n5;
        }
    }
}

