/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AddCollectionOpImage
extends PointOpImage {
    private byte[][] byteTable = null;

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        this.byteTable = new byte[256][256];
        for (int i = 0; i < 256; ++i) {
            byte[] byArray = this.byteTable[i];
            for (int j = 0; j < 256; ++j) {
                byArray[j] = ImageUtil.clampBytePositive(i + j);
            }
        }
    }

    public AddCollectionOpImage(Collection collection, Map map, ImageLayout imageLayout) {
        super(AddCollectionOpImage.vectorize(collection), imageLayout, map, true);
    }

    private static Vector vectorize(Collection collection) {
        if (collection instanceof Vector) {
            return (Vector)collection;
        }
        Vector vector = new Vector(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        return vector;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        int n = this.getNumSources();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[n], this.getColorModel());
        RasterAccessor[] rasterAccessorArray = new RasterAccessor[n];
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle2 = this.mapDestRect(rectangle, i);
            rasterAccessorArray[i] = new RasterAccessor(rasterArray[i], rectangle2, rasterFormatTagArray[i], this.getSourceImage(i).getColorModel());
        }
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessorArray, rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessorArray, rasterAccessor);
            }
        }
        if (rasterAccessor.needsClamping()) {
            rasterAccessor.clampDataArrays();
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        this.initByteTable();
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n6 = this.getNumSources();
        for (int i = 0; i < n6; ++i) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[i];
            int n7 = rasterAccessor2.getScanlineStride();
            int n8 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
            for (int j = 0; j < n3; ++j) {
                int n9 = nArray[j];
                int n10 = nArray2[j];
                byte[] byArray3 = byArray[j];
                byte[] byArray4 = byArray2[j];
                for (int k = 0; k < n2; ++k) {
                    int n11 = n9;
                    int n12 = n10;
                    n9 += n4;
                    n10 += n7;
                    for (int i2 = 0; i2 < n; ++i2) {
                        byArray3[n11] = this.byteTable[byArray3[n11] & 0xFF][byArray4[n12] & 0xFF];
                        n11 += n5;
                        n12 += n8;
                    }
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n6 = this.getNumSources();
        for (int i = 0; i < n6; ++i) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[i];
            int n7 = rasterAccessor2.getScanlineStride();
            int n8 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            short[][] sArray2 = rasterAccessor2.getShortDataArrays();
            for (int j = 0; j < n3; ++j) {
                int n9 = nArray[j];
                int n10 = nArray2[j];
                short[] sArray3 = sArray[j];
                short[] sArray4 = sArray2[j];
                for (int k = 0; k < n2; ++k) {
                    int n11 = n9;
                    int n12 = n10;
                    n9 += n4;
                    n10 += n7;
                    for (int i2 = 0; i2 < n; ++i2) {
                        sArray3[n11] = ImageUtil.clampUShortPositive((sArray3[n11] & 0xFFFF) + (sArray4[n12] & 0xFFFF));
                        n11 += n5;
                        n12 += n8;
                    }
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n6 = this.getNumSources();
        for (int i = 0; i < n6; ++i) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[i];
            int n7 = rasterAccessor2.getScanlineStride();
            int n8 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            short[][] sArray2 = rasterAccessor2.getShortDataArrays();
            for (int j = 0; j < n3; ++j) {
                int n9 = nArray[j];
                int n10 = nArray2[j];
                short[] sArray3 = sArray[j];
                short[] sArray4 = sArray2[j];
                for (int k = 0; k < n2; ++k) {
                    int n11 = n9;
                    int n12 = n10;
                    n9 += n4;
                    n10 += n7;
                    for (int i2 = 0; i2 < n; ++i2) {
                        sArray3[n11] = ImageUtil.clampShort(sArray3[n11] + sArray4[n12]);
                        n11 += n5;
                        n12 += n8;
                    }
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n6 = this.getNumSources();
        for (int i = 0; i < n6; ++i) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[i];
            int n7 = rasterAccessor2.getScanlineStride();
            int n8 = rasterAccessor2.getPixelStride();
            int[] nArray3 = rasterAccessor2.getBandOffsets();
            int[][] nArray4 = rasterAccessor2.getIntDataArrays();
            for (int j = 0; j < n3; ++j) {
                int n9 = nArray[j];
                int n10 = nArray3[j];
                int[] nArray5 = nArray2[j];
                int[] nArray6 = nArray4[j];
                for (int k = 0; k < n2; ++k) {
                    int n11 = n9;
                    int n12 = n10;
                    n9 += n4;
                    n10 += n7;
                    for (int i2 = 0; i2 < n; ++i2) {
                        nArray5[n11] = ImageUtil.clampInt((long)nArray5[n11] + (long)nArray6[n12]);
                        n11 += n5;
                        n12 += n8;
                    }
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n6 = this.getNumSources();
        for (int i = 0; i < n6; ++i) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[i];
            int n7 = rasterAccessor2.getScanlineStride();
            int n8 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
            for (int j = 0; j < n3; ++j) {
                int n9 = nArray[j];
                int n10 = nArray2[j];
                float[] fArray3 = fArray[j];
                float[] fArray4 = fArray2[j];
                for (int k = 0; k < n2; ++k) {
                    int n11 = n9;
                    int n12 = n10;
                    n9 += n4;
                    n10 += n7;
                    for (int i2 = 0; i2 < n; ++i2) {
                        fArray3[n11] = ImageUtil.clampFloat((double)fArray3[n11] + (double)fArray4[n12]);
                        n11 += n5;
                        n12 += n8;
                    }
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor) {
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n6 = this.getNumSources();
        for (int i = 0; i < n6; ++i) {
            RasterAccessor rasterAccessor2 = rasterAccessorArray[i];
            int n7 = rasterAccessor2.getScanlineStride();
            int n8 = rasterAccessor2.getPixelStride();
            int[] nArray2 = rasterAccessor2.getBandOffsets();
            double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
            for (int j = 0; j < n3; ++j) {
                int n9 = nArray[j];
                int n10 = nArray2[j];
                double[] dArray3 = dArray[j];
                double[] dArray4 = dArray2[j];
                for (int k = 0; k < n2; ++k) {
                    int n11 = n9;
                    int n12 = n10;
                    n9 += n4;
                    n10 += n7;
                    for (int i2 = 0; i2 < n; ++i2) {
                        dArray3[n11] = dArray3[n11] + dArray4[n12];
                        n11 += n5;
                        n12 += n8;
                    }
                }
            }
        }
    }
}

