/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibUtils;
import com.sun.media.jai.util.ImageUtil;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import com.sun.medialib.mlib.mediaLibImageInterpTable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.WarpOpImage;
import javax.media.jai.WarpPolynomial;

final class MlibWarpPolynomialTableOpImage
extends WarpOpImage {
    private double[] xCoeffs;
    private double[] yCoeffs;
    private mediaLibImageInterpTable mlibInterpTableI = null;
    private mediaLibImageInterpTable mlibInterpTableF = null;
    private mediaLibImageInterpTable mlibInterpTableD = null;
    private double preScaleX;
    private double preScaleY;
    private double postScaleX;
    private double postScaleY;

    public MlibWarpPolynomialTableOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, WarpPolynomial warpPolynomial, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, warpPolynomial, dArray);
        float[] fArray = warpPolynomial.getXCoeffs();
        float[] fArray2 = warpPolynomial.getYCoeffs();
        int n = fArray.length;
        this.xCoeffs = new double[n];
        this.yCoeffs = new double[n];
        for (int i = 0; i < n; ++i) {
            this.xCoeffs[i] = fArray[i];
            this.yCoeffs[i] = fArray2[i];
        }
        this.preScaleX = warpPolynomial.getPreScaleX();
        this.preScaleY = warpPolynomial.getPreScaleY();
        this.postScaleX = warpPolynomial.getPostScaleX();
        this.postScaleY = warpPolynomial.getPostScaleY();
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        Rectangle rectangle2 = super.backwardMapRect(rectangle, n);
        rectangle2.setBounds(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
        return rectangle2;
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.computableBounds);
        Rectangle rectangle3 = rectangle.intersection(this.getBounds());
        if (rectangle2.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle3, this.backgroundValues);
            }
            return writableRaster;
        }
        Rectangle rectangle4 = this.backwardMapRect(rectangle2, 0).intersection(this.getSourceImage(0).getBounds());
        if (rectangle4.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle3, this.backgroundValues);
            }
            return writableRaster;
        }
        if (!rectangle3.equals(rectangle2)) {
            ImageUtil.fillBordersWithBackgroundValues(rectangle3, rectangle2, writableRaster, this.backgroundValues);
        }
        int n3 = this.interp == null ? 0 : this.interp.getLeftPadding();
        int n4 = this.interp == null ? 0 : this.interp.getRightPadding();
        int n5 = this.interp == null ? 0 : this.interp.getTopPadding();
        int n6 = this.interp == null ? 0 : this.interp.getBottomPadding();
        rectangle4 = new Rectangle(rectangle4.x - n3, rectangle4.y - n5, rectangle4.width + n3 + n4, rectangle4.height + n5 + n6);
        Raster[] rasterArray = new Raster[]{this.getBorderExtender() != null ? this.getSourceImage(0).getExtendedData(rectangle4, this.extender) : this.getSourceImage(0).getData(rectangle4)};
        this.computeRect(rasterArray, writableRaster, rectangle2);
        if (this.getSourceImage(0).overlapsMultipleTiles(rectangle4)) {
            this.recycleTile(rasterArray[0]);
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, raster.getBounds(), n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (this.mlibInterpTableI == null) {
                    InterpolationTable interpolationTable = (InterpolationTable)this.interp;
                    this.mlibInterpTableI = new mediaLibImageInterpTable(3, interpolationTable.getWidth(), interpolationTable.getHeight(), interpolationTable.getLeftPadding(), interpolationTable.getTopPadding(), interpolationTable.getSubsampleBitsH(), interpolationTable.getSubsampleBitsV(), interpolationTable.getPrecisionBits(), (Object)interpolationTable.getHorizontalTableData(), (Object)interpolationTable.getVerticalTableData());
                }
                if (this.setBackground) {
                    for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                        Image.PolynomialWarpTable2((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.xCoeffs, (double[])this.yCoeffs, (double)rectangle.x, (double)rectangle.y, (double)raster.getMinX(), (double)raster.getMinY(), (double)this.preScaleX, (double)this.preScaleY, (double)this.postScaleX, (double)this.postScaleY, (mediaLibImageInterpTable)this.mlibInterpTableI, (int)0, (int[])this.intBackgroundValues);
                    }
                } else {
                    for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                        Image.PolynomialWarpTable((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.xCoeffs, (double[])this.yCoeffs, (double)rectangle.x, (double)rectangle.y, (double)raster.getMinX(), (double)raster.getMinY(), (double)this.preScaleX, (double)this.preScaleY, (double)this.postScaleX, (double)this.postScaleY, (mediaLibImageInterpTable)this.mlibInterpTableI, (int)0);
                        MlibUtils.clampImage(mediaLibImageArray2[i], this.getColorModel());
                    }
                }
                break;
            }
            case 4: {
                if (this.mlibInterpTableF == null) {
                    InterpolationTable interpolationTable = (InterpolationTable)this.interp;
                    this.mlibInterpTableF = new mediaLibImageInterpTable(4, interpolationTable.getWidth(), interpolationTable.getHeight(), interpolationTable.getLeftPadding(), interpolationTable.getTopPadding(), interpolationTable.getSubsampleBitsH(), interpolationTable.getSubsampleBitsV(), interpolationTable.getPrecisionBits(), (Object)interpolationTable.getHorizontalTableDataFloat(), (Object)interpolationTable.getVerticalTableDataFloat());
                }
                if (this.setBackground) {
                    for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                        Image.PolynomialWarpTable2_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.xCoeffs, (double[])this.yCoeffs, (double)rectangle.x, (double)rectangle.y, (double)raster.getMinX(), (double)raster.getMinY(), (double)this.preScaleX, (double)this.preScaleY, (double)this.postScaleX, (double)this.postScaleY, (mediaLibImageInterpTable)this.mlibInterpTableD, (int)0, (double[])this.backgroundValues);
                    }
                } else {
                    for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                        Image.PolynomialWarpTable_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.xCoeffs, (double[])this.yCoeffs, (double)rectangle.x, (double)rectangle.y, (double)raster.getMinX(), (double)raster.getMinY(), (double)this.preScaleX, (double)this.preScaleY, (double)this.postScaleX, (double)this.postScaleY, (mediaLibImageInterpTable)this.mlibInterpTableD, (int)0);
                    }
                }
                break;
            }
            case 5: {
                if (this.mlibInterpTableD == null) {
                    InterpolationTable interpolationTable = (InterpolationTable)this.interp;
                    this.mlibInterpTableD = new mediaLibImageInterpTable(5, interpolationTable.getWidth(), interpolationTable.getHeight(), interpolationTable.getLeftPadding(), interpolationTable.getTopPadding(), interpolationTable.getSubsampleBitsH(), interpolationTable.getSubsampleBitsV(), interpolationTable.getPrecisionBits(), (Object)interpolationTable.getHorizontalTableDataDouble(), (Object)interpolationTable.getVerticalTableDataDouble());
                }
                if (this.setBackground) {
                    for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                        Image.PolynomialWarpTable2_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.xCoeffs, (double[])this.yCoeffs, (double)rectangle.x, (double)rectangle.y, (double)raster.getMinX(), (double)raster.getMinY(), (double)this.preScaleX, (double)this.preScaleY, (double)this.postScaleX, (double)this.postScaleY, (mediaLibImageInterpTable)this.mlibInterpTableD, (int)0, (double[])this.backgroundValues);
                    }
                } else {
                    for (int i = 0; i < mediaLibImageArray2.length; ++i) {
                        Image.PolynomialWarpTable_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.xCoeffs, (double[])this.yCoeffs, (double)rectangle.x, (double)rectangle.y, (double)raster.getMinX(), (double)raster.getMinY(), (double)this.preScaleX, (double)this.preScaleY, (double)this.postScaleX, (double)this.postScaleY, (mediaLibImageInterpTable)this.mlibInterpTableD, (int)0);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

