/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGHuffmanTable;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.util.Arrays;

public class JPEGParam
implements JPEGEncodeParam {
    private float quality = 0.75f;
    private int colorID = -1;
    private int width;
    private int height;
    private int numBands;
    private boolean imageInfoValid = false;
    private boolean tableInfoValid = false;
    private JPEGQTable[] qTable = new JPEGQTable[4];
    private JPEGHuffmanTable[] acHuffmanTable = new JPEGHuffmanTable[4];
    private JPEGHuffmanTable[] dcHuffmanTable = new JPEGHuffmanTable[4];
    private int restartInterval = 0;
    private int[] horizontalSubsampleComponents;
    private int[] verticalSubsampleComponents;
    private byte[][][] markers = new byte[16][][];
    private byte[][] commentMarker = null;
    private static int[] components = new int[]{0, 1, 3, 3, 4, 3, 4, 4, 4, 4, 4, 4};
    private int[] qTableComponentMapping;
    private int[] acHuffmanComponentMapping;
    private int[] dcHuffmanComponentMapping;
    private byte APP0_MARKER_NUM_BYTES = (byte)14;

    public JPEGParam(JPEGEncodeParam jPEGEncodeParam) {
        this((JPEGDecodeParam)jPEGEncodeParam);
    }

    public JPEGParam(JPEGDecodeParam jPEGDecodeParam) {
        this(jPEGDecodeParam.getEncodedColorID(), jPEGDecodeParam.getNumComponents());
        Object object;
        int n;
        this.setTableInfoValid(jPEGDecodeParam.isTableInfoValid());
        this.setImageInfoValid(jPEGDecodeParam.isImageInfoValid());
        this.setRestartInterval(jPEGDecodeParam.getRestartInterval());
        for (n = 0; n < 4; ++n) {
            this.qTable[n] = jPEGDecodeParam.getQTable(n);
            this.acHuffmanTable[n] = jPEGDecodeParam.getACHuffmanTable(n);
            this.dcHuffmanTable[n] = jPEGDecodeParam.getDCHuffmanTable(n);
        }
        for (n = 0; n < this.getNumComponents(); ++n) {
            this.setQTableComponentMapping(n, jPEGDecodeParam.getQTableComponentMapping(n));
            this.setACHuffmanComponentMapping(n, jPEGDecodeParam.getACHuffmanComponentMapping(n));
            this.setDCHuffmanComponentMapping(n, jPEGDecodeParam.getDCHuffmanComponentMapping(n));
        }
        for (n = 224; n < 239; ++n) {
            object = jPEGDecodeParam.getMarkerData(n);
            Object object2 = null;
            if (object != null) {
                object2 = new byte[((byte[][])object).length][];
                for (int i = 0; i < ((byte[][])object).length; ++i) {
                    object2[i] = Arrays.copyOf(object[i], object[i].length);
                }
            }
            this.setMarkerData(n, (byte[][])object2);
        }
        byte[][] byArray = jPEGDecodeParam.getMarkerData(254);
        object = null;
        if (byArray != null) {
            object = new byte[byArray.length][];
            for (int i = 0; i < byArray.length; ++i) {
                object[i] = Arrays.copyOf(byArray[i], byArray[i].length);
            }
            this.setMarkerData(254, (byte[][])object);
        }
    }

    public JPEGParam(int n) {
        this(n, components[n]);
    }

    public JPEGParam(int n, int n2) {
        if (n < 0 || n >= 12 || n != 0 && n2 != components[n]) {
            throw new IllegalArgumentException();
        }
        this.colorID = n;
        this.numBands = n2;
        this.initialize();
    }

    private void initialize() {
        this.qTable[0] = JPEGQTable.StdLuminance;
        this.qTable[1] = JPEGQTable.StdChrominance;
        this.acHuffmanTable[0] = JPEGHuffmanTable.StdACLuminance;
        this.acHuffmanTable[1] = JPEGHuffmanTable.StdACChrominance;
        this.dcHuffmanTable[0] = JPEGHuffmanTable.StdDCLuminance;
        this.dcHuffmanTable[1] = JPEGHuffmanTable.StdDCChrominance;
        this.qTableComponentMapping = new int[this.getNumComponents()];
        this.acHuffmanComponentMapping = new int[this.getNumComponents()];
        this.dcHuffmanComponentMapping = new int[this.getNumComponents()];
        this.horizontalSubsampleComponents = new int[this.getNumComponents()];
        this.verticalSubsampleComponents = new int[this.getNumComponents()];
        this.setTableInfoValid(true);
        this.setImageInfoValid(true);
        this.setMarkerData(224, this.arrayAdd(this.getMarkerData(224), this.createAPP0MarkerData()));
    }

    private byte[] createAPP0MarkerData() {
        byte[] byArray = null;
        switch (this.colorID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                byArray = new byte[this.APP0_MARKER_NUM_BYTES];
                byArray[0] = 74;
                byArray[1] = 70;
                byArray[2] = 73;
                byArray[3] = 70;
                byArray[4] = 0;
                byArray[5] = 1;
                byArray[6] = 2;
                byArray[7] = 0;
                byArray[8] = 0;
                byArray[9] = 1;
                byArray[10] = 0;
                byArray[11] = 1;
                byArray[12] = 0;
                byArray[13] = 0;
            }
        }
        return byArray;
    }

    public void setQuality(float f, boolean bl) {
        if ((double)f < 0.0) {
            f = 0.0f;
        } else if ((double)f > 1.0) {
            f = 1.0f;
        }
        this.quality = f;
        f = 1.0f - f;
        for (int i = 0; i < 4; ++i) {
            if (this.qTable[i] == null) continue;
            this.qTable[i] = this.qTable[i].getScaledInstance(f, bl);
        }
    }

    public Object clone() {
        JPEGParam jPEGParam = new JPEGParam(this);
        return jPEGParam;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHorizontalSubsampling(int n) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.horizontalSubsampleComponents[n];
    }

    public int getVerticalSubsampling(int n) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.verticalSubsampleComponents[n];
    }

    public JPEGQTable getQTable(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        return this.qTable[n];
    }

    public JPEGQTable getQTableForComponent(int n) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.qTable[this.qTableComponentMapping[n]];
    }

    public JPEGHuffmanTable getDCHuffmanTable(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        return this.dcHuffmanTable[n];
    }

    public JPEGHuffmanTable getDCHuffmanTableForComponent(int n) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.dcHuffmanTable[this.dcHuffmanComponentMapping[n]];
    }

    public JPEGHuffmanTable getACHuffmanTable(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        return this.acHuffmanTable[n];
    }

    public JPEGHuffmanTable getACHuffmanTableForComponent(int n) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.acHuffmanTable[this.acHuffmanComponentMapping[n]];
    }

    public int getDCHuffmanComponentMapping(int n) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.dcHuffmanComponentMapping[n];
    }

    public int getACHuffmanComponentMapping(int n) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.acHuffmanComponentMapping[n];
    }

    public int getQTableComponentMapping(int n) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        return this.qTableComponentMapping[n];
    }

    public boolean isImageInfoValid() {
        return this.imageInfoValid;
    }

    public boolean isTableInfoValid() {
        return this.tableInfoValid;
    }

    public boolean getMarker(int n) {
        byte[][] byArray = null;
        switch (n) {
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                byArray = this.markers[n - 224];
                break;
            }
            case 254: {
                byArray = this.commentMarker;
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker provided is invalid");
            }
        }
        return byArray != null && byArray.length > 0;
    }

    public byte[][] getMarkerData(int n) {
        byte[][] byArray = null;
        switch (n) {
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                byArray = this.markers[n - 224];
                break;
            }
            case 254: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker provided is invalid");
            }
        }
        return byArray;
    }

    public int getEncodedColorID() {
        return this.colorID;
    }

    public int getNumComponents() {
        return this.numBands;
    }

    public int getRestartInterval() {
        return this.restartInterval;
    }

    public int getDensityUnit() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("APP0 Marker not found.");
        }
        byte[] byArray = this.getValidAPP0Marker();
        if (byArray == null) {
            throw new IllegalArgumentException("No valid APP0 Marker found");
        }
        return byArray[7];
    }

    public int getXDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("APP0 Marker not found.");
        }
        byte[] byArray = this.getValidAPP0Marker();
        if (byArray == null) {
            throw new IllegalArgumentException("No valid APP0 Marker found");
        }
        int n = byArray[8] << 8;
        int n2 = byArray[9] & 0xFF;
        return n | n2;
    }

    public int getYDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("APP0 Marker not found.");
        }
        byte[] byArray = this.getValidAPP0Marker();
        if (byArray == null) {
            throw new IllegalArgumentException("No valid APP0 Marker found");
        }
        int n = byArray[10] << 8;
        int n2 = byArray[11] & 0xFF;
        return n | n2;
    }

    public void setHorizontalSubsampling(int n, int n2) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        this.horizontalSubsampleComponents[n] = n2;
    }

    public void setVerticalSubsampling(int n, int n2) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component");
        }
        this.verticalSubsampleComponents[n] = n2;
    }

    public void setQTable(int n, JPEGQTable jPEGQTable) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        this.qTable[n] = jPEGQTable;
    }

    public void setDCHuffmanTable(int n, JPEGHuffmanTable jPEGHuffmanTable) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        this.dcHuffmanTable[n] = jPEGHuffmanTable;
    }

    public void setACHuffmanTable(int n, JPEGHuffmanTable jPEGHuffmanTable) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("tableNum must be [0-3]");
        }
        this.acHuffmanTable[n] = jPEGHuffmanTable;
    }

    public void setACHuffmanComponentMapping(int n, int n2) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component specified.");
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Invalid table specified");
        }
        this.acHuffmanComponentMapping[n] = n2;
    }

    public void setDCHuffmanComponentMapping(int n, int n2) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component specified.");
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Invalid table specified");
        }
        this.dcHuffmanComponentMapping[n] = n2;
    }

    public void setQTableComponentMapping(int n, int n2) {
        if (n < 0 || n > this.getNumComponents()) {
            throw new IllegalArgumentException("Invalid component specified.");
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Invalid table specified");
        }
        this.qTableComponentMapping[n] = n2;
    }

    public void setImageInfoValid(boolean bl) {
        this.imageInfoValid = bl;
    }

    public void setTableInfoValid(boolean bl) {
        this.tableInfoValid = bl;
    }

    public void setMarkerData(int n, byte[][] byArray) {
        if (byArray == null) {
            return;
        }
        switch (n) {
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                this.markers[n - 224] = byArray;
                break;
            }
            case 254: {
                this.commentMarker = byArray;
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker provided is invalid");
            }
        }
    }

    public void addMarkerData(int n, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        switch (n) {
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                this.markers[n - 224] = this.arrayAdd(this.markers[n - 224], byArray);
                break;
            }
            case 254: {
                this.commentMarker = this.arrayAdd(this.commentMarker, byArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Marker provided is invalid");
            }
        }
    }

    public void setRestartInterval(int n) {
        this.restartInterval = n;
    }

    public void setDensityUnit(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid density unit.");
        }
        byte[] byArray = this.getValidAPP0Marker();
        if (byArray == null) {
            byArray = this.createAPP0MarkerData();
            this.markers[0] = this.arrayAdd(this.markers[0], byArray);
        }
        byArray[7] = (byte)n;
    }

    public void setXDensity(int n) {
        byte[] byArray = this.getValidAPP0Marker();
        if (byArray == null) {
            byArray = this.createAPP0MarkerData();
            this.markers[0] = this.arrayAdd(this.markers[0], byArray);
        }
        byte by = (byte)(n >>> 8 & 0xFF);
        byte by2 = (byte)(n & 0xFF);
        byArray[8] = by;
        byArray[9] = by2;
    }

    public void setYDensity(int n) {
        byte[] byArray = this.getValidAPP0Marker();
        if (byArray == null) {
            byArray = this.createAPP0MarkerData();
            this.markers[0] = this.arrayAdd(this.markers[0], byArray);
        }
        byte by = (byte)(n >>> 8 & 0xFF);
        byte by2 = (byte)(n & 0xFF);
        byArray[10] = by;
        byArray[11] = by2;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public float getQuality() {
        return this.quality;
    }

    private byte[][] arrayAdd(byte[][] byArray, byte[] byArray2) {
        Object object;
        if (byArray != null) {
            object = (byte[][])Arrays.copyOf(byArray, byArray.length + 1);
            object[byArray.length] = Arrays.copyOf(byArray2, byArray2.length);
        } else {
            object = new byte[][]{Arrays.copyOf(byArray2, byArray2.length)};
        }
        return object;
    }

    private byte[] getValidAPP0Marker() {
        byte[][] byArray = this.getMarkerData(224);
        for (int i = 0; i < byArray.length; ++i) {
            byte[] byArray2 = byArray[i];
            if (byArray2[0] != 74 || byArray2[1] != 70 || byArray2[2] != 73 || byArray2[3] != 70 || byArray2[4] != 0 || byArray2[5] > 1) continue;
            return byArray2;
        }
        return null;
    }
}

