/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import sun.awt.image.codec.JPEGParam;

public class JPEGImageEncoderImpl
implements JPEGImageEncoder {
    private static final String JPGMime = "image/jpeg";
    private ImageWriter JPGWriter;
    private JPEGEncodeParam param;
    private OutputStream out;

    public JPEGImageEncoderImpl(OutputStream outputStream) {
        this(outputStream, null);
    }

    public JPEGImageEncoderImpl(OutputStream outputStream, JPEGEncodeParam jPEGEncodeParam) {
        this.out = outputStream;
        this.setJPEGEncodeParam(jPEGEncodeParam);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(JPGMime);
        if (iterator.hasNext()) {
            this.JPGWriter = iterator.next();
        }
        this.JPGWriter.setOutput(new MemoryCacheImageOutputStream(outputStream));
    }

    public JPEGEncodeParam getDefaultJPEGEncodeParam(BufferedImage bufferedImage) throws ImageFormatException {
        return JPEGCodec.getDefaultJPEGEncodeParam(bufferedImage);
    }

    public JPEGEncodeParam getDefaultJPEGEncodeParam(int n, int n2) throws ImageFormatException {
        return JPEGCodec.getDefaultJPEGEncodeParam(n, n2);
    }

    public JPEGEncodeParam getDefaultJPEGEncodeParam(JPEGDecodeParam jPEGDecodeParam) throws ImageFormatException {
        return JPEGCodec.getDefaultJPEGEncodeParam(jPEGDecodeParam);
    }

    public JPEGEncodeParam getDefaultJPEGEncodeParam(Raster raster, int n) throws ImageFormatException {
        return JPEGCodec.getDefaultJPEGEncodeParam(raster, n);
    }

    public JPEGEncodeParam getJPEGEncodeParam() throws ImageFormatException {
        if (this.param == null) {
            return null;
        }
        return (JPEGEncodeParam)this.param.clone();
    }

    public void setJPEGEncodeParam(JPEGEncodeParam jPEGEncodeParam) {
        this.param = jPEGEncodeParam;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    private void encode(IIOImage iIOImage) throws IOException, ImageFormatException {
        if (this.JPGWriter == null) {
            throw new ImageFormatException("JPEG writer code not implemented in ImageIO");
        }
        JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(null);
        jPEGImageWriteParam.setCompressionMode(2);
        if (this.param != null && this.param instanceof JPEGParam) {
            JPEGParam jPEGParam = (JPEGParam)this.param;
            jPEGImageWriteParam.setCompressionQuality(jPEGParam.getQuality());
        } else {
            jPEGImageWriteParam.setCompressionQuality(0.75f);
        }
        this.JPGWriter.write(null, iIOImage, jPEGImageWriteParam);
    }

    public void encode(BufferedImage bufferedImage, JPEGEncodeParam jPEGEncodeParam) throws IOException, ImageFormatException {
        this.setJPEGEncodeParam(jPEGEncodeParam);
        this.encode(new IIOImage(bufferedImage, new ArrayList(), null));
    }

    public void encode(Raster raster, JPEGEncodeParam jPEGEncodeParam) throws IOException, ImageFormatException {
        this.setJPEGEncodeParam(jPEGEncodeParam);
        this.encode(new IIOImage(raster, new ArrayList(), null));
    }

    public void encode(BufferedImage bufferedImage) throws IOException, ImageFormatException {
        this.encode(bufferedImage, null);
    }

    public void encode(Raster raster) throws IOException, ImageFormatException {
        this.encode(raster, null);
    }

    public int getDefaultColorId(ColorModel colorModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n = colorSpace.getType();
        int n2 = -1;
        switch (n) {
            case 6: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = colorModel.hasAlpha() ? 6 : 2;
            }
            case 3: {
                try {
                    if (colorSpace == ColorSpace.getInstance(1002)) {
                        n2 = colorModel.hasAlpha() ? 10 : 5;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (n2 != -1) break;
                n2 = colorModel.hasAlpha() ? 7 : 3;
                break;
            }
            case 9: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }
}

