/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.SeekableOutputStream;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.CodecUtils;
import com.sun.media.jai.codecimpl.JPEGImageEncoder;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SingleTileRenderedImage;
import com.sun.media.jai.codecimpl.TIFFFaxEncoder;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_GROUP3_1D = 2;
    private static final int COMP_GROUP3_2D = 3;
    private static final int COMP_GROUP4 = 4;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private boolean isLittleEndian = false;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    private static final char[] intsToChars(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(nArray[i] & 0xFFFF);
        }
        return cArray;
    }

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        this.isLittleEndian = tIFFEncodeParam.getLittleEndian();
        this.writeFileHeader();
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n = this.encode(renderedImage2, tIFFEncodeParam2, n, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e = iterator.next();
                if (e instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int byteArrayOutputStream;
        int n4;
        int nArray4;
        TIFFField[] tIFFFieldArray;
        Object object;
        Object object2;
        int n7;
        int[] nArray;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        Object object4;
        byte[] byArray;
        byte[] byArray2;
        int n14;
        int n15;
        if (CodecUtils.isPackedByteImage(renderedImage)) {
            ColorModel colorModel = renderedImage.getColorModel();
            ComponentColorModel componentColorModel = RasterFactory.createComponentColorModel(0, colorModel.getColorSpace(), colorModel.hasAlpha(), colorModel.isAlphaPremultiplied(), colorModel.getTransparency());
            Point point = new Point(renderedImage.getMinX(), renderedImage.getMinY());
            WritableRaster writableRaster = Raster.createWritableRaster(((ColorModel)componentColorModel).createCompatibleSampleModel(renderedImage.getWidth(), renderedImage.getHeight()), point);
            writableRaster.setRect(renderedImage.getData());
            renderedImage = new SingleTileRenderedImage(writableRaster, componentColorModel);
        }
        int n16 = tIFFEncodeParam.getCompression();
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n17 = renderedImage.getMinX();
        int n18 = renderedImage.getMinY();
        int n19 = renderedImage.getWidth();
        int n20 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int[] nArray2 = sampleModel.getSampleSize();
        for (n15 = 1; n15 < nArray2.length; ++n15) {
            if (nArray2[n15] == nArray2[0]) continue;
            throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder0"));
        }
        n15 = sampleModel.getNumBands();
        if ((nArray2[0] == 1 || nArray2[0] == 4) && n15 != 1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder1"));
        }
        int n21 = sampleModel.getDataType();
        switch (n21) {
            case 0: {
                if (nArray2[0] == 1 || nArray2[0] == 4 || nArray2[0] == 8) break;
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder2"));
            }
            case 1: 
            case 2: {
                if (nArray2[0] == 16) break;
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder3"));
            }
            case 3: 
            case 4: {
                if (nArray2[0] == 32) break;
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder4"));
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder5"));
            }
        }
        boolean bl3 = n21 == 2 || n21 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && n21 != 0) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder6"));
        }
        IndexColorModel indexColorModel = null;
        int n22 = 0;
        int[] nArray3 = null;
        int n23 = -1;
        int n24 = 0;
        int n25 = 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            n14 = indexColorModel.getMapSize();
            if (nArray2[0] == 1 && n15 == 1) {
                if (n14 != 2) {
                    throw new IllegalArgumentException(JaiI18N.getString("TIFFImageEncoder7"));
                }
                byArray2 = new byte[n14];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n14];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n14];
                indexColorModel.getBlues((byte[])object4);
                n23 = (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 && (object4[0] & 0xFF) == 0 && (object4[1] & 0xFF) == 255 ? 1 : ((byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 && (object4[0] & 0xFF) == 255 && (object4[1] & 0xFF) == 0 ? 0 : 3);
            } else if (n15 == 1) {
                n23 = 3;
            }
        } else if (colorModel == null) {
            if (nArray2[0] == 1 && n15 == 1) {
                n23 = 1;
            } else {
                n23 = 8;
                if (n15 > 1) {
                    n24 = n15 - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    n23 = 5;
                    break;
                }
                case 6: {
                    n23 = 2;
                    break;
                }
                case 1: {
                    n23 = 7;
                    break;
                }
                case 5: {
                    if (n16 == 7 && tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                        n23 = 6;
                        break;
                    }
                    n23 = 4;
                    break;
                }
                case 3: {
                    n23 = 6;
                    break;
                }
                default: {
                    n23 = 8;
                }
            }
            if (n23 == 8) {
                n24 = n15 - 1;
            } else if (n15 > 1) {
                n24 = n15 - colorSpace.getNumComponents();
            }
            if (n24 == 1 && colorModel.hasAlpha()) {
                int n5 = n25 = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (n23 == -1) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder8"));
        }
        if (n16 == 7) {
            if (n23 == 3) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder11"));
            }
            if (nArray2[0] != 8 || n23 != 2 && n23 != 4 && n23 != 6) {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder9"));
            }
        }
        if (n23 != 0 && n23 != 1 && (n16 == 2 || n16 == 3 || n16 == 4)) {
            throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder12"));
        }
        n14 = -1;
        switch (n23) {
            case 0: {
                n14 = 0;
                break;
            }
            case 1: {
                n14 = 1;
                break;
            }
            case 2: 
            case 8: {
                n14 = 1;
                break;
            }
            case 3: {
                n14 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n22 = indexColorModel.getMapSize();
                byArray2 = new byte[n22];
                indexColorModel.getReds(byArray2);
                byArray = new byte[n22];
                indexColorModel.getGreens(byArray);
                object4 = new byte[n22];
                indexColorModel.getBlues((byte[])object4);
                n13 = 0;
                n12 = n22;
                n11 = 2 * n22;
                nArray3 = new int[n22 * 3];
                for (n10 = 0; n10 < n22; ++n10) {
                    nArray3[n13++] = byArray2[n10] << 8 & 0xFFFF;
                    nArray3[n12++] = byArray[n10] << 8 & 0xFFFF;
                    nArray3[n11++] = object4[n10] << 8 & 0xFFFF;
                }
                n22 *= 3;
                break;
            }
            case 4: {
                n14 = 2;
                break;
            }
            case 5: {
                n14 = 5;
                break;
            }
            case 6: {
                n14 = 6;
                break;
            }
            case 7: {
                n14 = 8;
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder8"));
            }
        }
        if (bl2) {
            n9 = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : renderedImage.getTileWidth();
            n8 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : renderedImage.getTileHeight();
        } else {
            n9 = n19;
            n8 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
        }
        object4 = null;
        if (n16 == 7) {
            object4 = tIFFEncodeParam.getJPEGEncodeParam();
            n13 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(0);
            n12 = ((JPEGEncodeParam)object4).getVerticalSubsampling(0);
            for (n11 = 1; n11 < n15; ++n11) {
                int n27;
                n10 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(n11);
                if (n10 > n13) {
                    n13 = n10;
                }
                if ((n27 = ((JPEGEncodeParam)object4).getVerticalSubsampling(n11)) <= n12) continue;
                n12 = n27;
            }
            n11 = 8 * n12;
            if ((n8 = (int)((float)n8 / (float)n11 + 0.5f) * n11) < n11) {
                n8 = n11;
            }
            if (bl2 && (n9 = (int)((float)n9 / (float)(n10 = 8 * n13) + 0.5f) * n10) < n10) {
                n9 = n10;
            }
        }
        n13 = bl2 ? (n19 + n9 - 1) / n9 * ((n20 + n8 - 1) / n8) : (int)Math.ceil((double)n20 / (double)n8);
        long[] lArray = new long[n13];
        long l = (long)Math.ceil((double)nArray2[0] / 8.0 * (double)n9 * (double)n15);
        long l2 = l * (long)n8;
        for (int i = 0; i < n13; ++i) {
            lArray[i] = l2;
        }
        if (!bl2) {
            long l3 = n20 - n8 * (n13 - 1);
            lArray[n13 - 1] = l3 * l;
        }
        long l4 = l2 * (long)(n13 - 1) + lArray[n13 - 1];
        long[] lArray2 = new long[n13];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n19}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n20}));
        treeSet.add(new TIFFField(258, 3, n15, TIFFImageEncoder.intsToChars(nArray2)));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)n16}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)n14}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n13, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n15}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n8}));
            treeSet.add(new TIFFField(279, 4, n13, lArray));
        }
        if (nArray3 != null) {
            treeSet.add(new TIFFField(320, 3, n22, TIFFImageEncoder.intsToChars(nArray3)));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n9}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n8}));
            treeSet.add(new TIFFField(324, 4, n13, lArray2));
            treeSet.add(new TIFFField(325, 4, n13, lArray));
        }
        if (n24 > 0) {
            nArray = new int[n24];
            for (n7 = 0; n7 < n24; ++n7) {
                nArray[n7] = n25;
            }
            treeSet.add(new TIFFField(338, 3, n24, TIFFImageEncoder.intsToChars(nArray)));
        }
        if (n21 != 0) {
            nArray = new int[n15];
            nArray[0] = n21 == 4 ? 3 : (n21 == 1 ? 1 : 2);
            for (n7 = 1; n7 < n15; ++n7) {
                nArray[n7] = nArray[0];
            }
            treeSet.add(new TIFFField(339, 3, n15, TIFFImageEncoder.intsToChars(nArray)));
        }
        boolean bl4 = tIFFEncodeParam.getReverseFillOrder();
        n7 = tIFFEncodeParam.getT4Encode2D() ? 1 : 0;
        boolean bl5 = tIFFEncodeParam.getT4PadEOLs();
        TIFFFaxEncoder tIFFFaxEncoder = null;
        if (!(n23 != 1 && n23 != 0 || n16 != 2 && n16 != 3 && n16 != 4)) {
            tIFFFaxEncoder = new TIFFFaxEncoder(bl4);
            treeSet.add(new TIFFField(266, 3, 1, new char[]{bl4 ? (char)'\u0002' : '\u0001'}));
            if (n16 == 3) {
                long l5 = 0L;
                if (n7 != 0) {
                    l5 |= 1L;
                }
                if (bl5) {
                    l5 |= 4L;
                }
                treeSet.add(new TIFFField(292, 4, 1, new long[]{l5}));
            } else if (n16 == 4) {
                treeSet.add(new TIFFField(293, 4, 1, new long[]{0L}));
            }
        }
        com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam = null;
        com.sun.image.codec.jpeg.JPEGImageEncoder jPEGImageEncoder = null;
        int n28 = 0;
        if (n16 == 7) {
            n28 = 0;
            switch (n23) {
                case 2: 
                case 3: {
                    n28 = 1;
                    break;
                }
                case 4: {
                    n28 = 2;
                    break;
                }
                case 6: {
                    n28 = 3;
                }
            }
            Raster object3 = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam(object3, n28);
            JPEGImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n15);
            if (((JPEGEncodeParam)object4).getWriteImageOnly()) {
                jPEGEncodeParam.setImageInfoValid(false);
                jPEGEncodeParam.setTableInfoValid(true);
                object2 = new ByteArrayOutputStream();
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)object2, jPEGEncodeParam);
                jPEGImageEncoder.encode(object3);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                treeSet.add(new TIFFField(347, 7, ((Object)object).length, object));
                jPEGImageEncoder = null;
            }
        }
        if (n23 == 6) {
            int n6;
            boolean n29 = true;
            int n26 = 1;
            if (n16 == 7) {
                int n27 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(0);
                n26 = ((JPEGEncodeParam)object4).getVerticalSubsampling(0);
                for (int i = 1; i < n15; ++i) {
                    int n30;
                    int n31 = ((JPEGEncodeParam)object4).getHorizontalSubsampling(i);
                    if (n31 > n6) {
                        n6 = n31;
                    }
                    if ((n30 = ((JPEGEncodeParam)object4).getVerticalSubsampling(i)) <= n26) continue;
                    n26 = n30;
                }
            }
            treeSet.add(new TIFFField(530, 3, 2, new char[]{(char)n6, (char)n26}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{n16 == 7 ? (char)'\u0001' : '\u0002'}));
            object = n16 == 7 ? (Object)new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}} : (Object)new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        if ((tIFFFieldArray = tIFFEncodeParam.getExtraFields()) != null) {
            object2 = new ArrayList<Integer>(treeSet.size());
            for (TIFFField tIFFField : treeSet) {
                ((ArrayList)object2).add(new Integer(tIFFField.getTag()));
            }
            for (TIFFField tIFFField : tIFFFieldArray) {
                Integer n32 = new Integer(tIFFField.getTag());
                if (((ArrayList)object2).contains(n32)) continue;
                treeSet.add(tIFFField);
                ((ArrayList)object2).add(n32);
            }
        }
        int n33 = this.getDirectorySize(treeSet);
        lArray2[0] = n + n33;
        object = null;
        byte[] byArray3 = null;
        File file = null;
        int n34 = 0;
        boolean bl6 = false;
        Deflater deflater = null;
        int n35 = -1;
        boolean bl7 = false;
        if (n16 == 1) {
            int n36;
            nArray4 = 0;
            if (nArray2[0] == 16 && lArray2[0] % 2L != 0L) {
                nArray4 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (nArray2[0] == 32 && lArray2[0] % 4L != 0L) {
                nArray4 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)nArray4;
            }
            for (n36 = 1; n36 < n13; ++n36) {
                lArray2[n36] = lArray2[n36 - 1] + lArray[n36 - 1];
            }
            if (!bl && (n34 = (int)(lArray2[0] + l4)) % 2 != 0) {
                ++n34;
                bl6 = true;
            }
            this.writeDirectory(n, treeSet, n34);
            if (nArray4 != 0) {
                for (n36 = 0; n36 < nArray4; ++n36) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                object = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (Exception exception) {
                    file = null;
                    this.output = new ByteArrayOutputStream((int)l4);
                }
            }
            nArray4 = 0;
            switch (n16) {
                case 2: {
                    nArray4 = (int)Math.ceil((double)((n9 + 1) / 2 * 9 + 2) / 8.0);
                    break;
                }
                case 3: 
                case 4: {
                    nArray4 = (int)Math.ceil((double)((n9 + 1) / 2 * 9 + 2) / 8.0);
                    nArray4 = n8 * (nArray4 + 2) + 12;
                    break;
                }
                case 32773: {
                    nArray4 = (int)(l2 + (l + 127L) / 128L * (long)n8);
                    break;
                }
                case 7: {
                    nArray4 = 0;
                    if (n23 != 6 || colorModel == null || colorModel.getColorSpace().getType() != 5) break;
                    bl7 = true;
                    break;
                }
                case 32946: {
                    nArray4 = (int)l2;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    nArray4 = 0;
                }
            }
            if (nArray4 != 0) {
                byArray3 = new byte[nArray4];
            }
        }
        int[] nArray5 = null;
        float[] fArray = null;
        boolean bl8 = nArray2[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n21 == 0 || nArray2[0] == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray4 = null;
        if (n16 != 7) {
            if (n21 == 0) {
                byArray4 = new byte[n8 * n9 * n15];
            } else if (bl3) {
                byArray4 = new byte[2 * n8 * n9 * n15];
            } else if (n21 == 3 || n21 == 4) {
                byArray4 = new byte[4 * n8 * n9 * n15];
            }
        }
        int n37 = n18 + n20;
        int n38 = n17 + n19;
        int n39 = 0;
        for (n4 = n18; n4 < n37; n4 += n8) {
            byteArrayOutputStream = bl2 ? n8 : Math.min(n8, n37 - n4);
            n3 = byteArrayOutputStream * n9 * n15;
            block55: for (n2 = n17; n2 < n38; n2 += n9) {
                int n40;
                int componentSampleModel;
                int n52;
                Raster raster = renderedImage.getData(new Rectangle(n2, n4, n9, byteArrayOutputStream));
                boolean bl9 = false;
                if (n16 != 7) {
                    if (bl8) {
                        if (nArray2[0] == 8) {
                            ComponentSampleModel n56 = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray6 = n56.getBankIndices();
                            int[] nArray7 = n56.getBandOffsets();
                            n52 = n56.getPixelStride();
                            componentSampleModel = n56.getScanlineStride();
                            if (n52 != n15 || (long)componentSampleModel != l) {
                                bl9 = false;
                            } else {
                                bl9 = true;
                                for (n40 = 0; bl9 && n40 < n15; ++n40) {
                                    if (nArray6[n40] == 0 && nArray7[n40] == n40) continue;
                                    bl9 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl9 = true;
                            }
                        }
                    }
                    if (!bl9) {
                        if (n21 == 4) {
                            fArray = raster.getPixels(n2, n4, n9, byteArrayOutputStream, fArray);
                        } else {
                            nArray5 = raster.getPixels(n2, n4, n9, byteArrayOutputStream, nArray5);
                        }
                    }
                }
                int n41 = 0;
                int n42 = 0;
                switch (nArray2[0]) {
                    case 1: {
                        int n43;
                        int n44;
                        int n58;
                        if (bl9) {
                            byte[] n53 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n40 = multiPixelPackedSampleModel.getScanlineStride();
                            n58 = multiPixelPackedSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n4 - raster.getSampleModelTranslateY());
                            if (n40 == (int)l) {
                                System.arraycopy(n53, n58, byArray4, 0, (int)l * byteArrayOutputStream);
                            } else {
                                n44 = 0;
                                for (n43 = 0; n43 < byteArrayOutputStream; ++n43) {
                                    System.arraycopy(n53, n58, byArray4, n44, (int)l);
                                    n58 += n40;
                                    n44 += (int)l;
                                }
                            }
                        } else {
                            int n45 = 0;
                            for (n52 = 0; n52 < byteArrayOutputStream; ++n52) {
                                for (componentSampleModel = 0; componentSampleModel < n9 / 8; ++componentSampleModel) {
                                    n41 = nArray5[n45++] << 7 | nArray5[n45++] << 6 | nArray5[n45++] << 5 | nArray5[n45++] << 4 | nArray5[n45++] << 3 | nArray5[n45++] << 2 | nArray5[n45++] << 1 | nArray5[n45++];
                                    byArray4[n42++] = (byte)n41;
                                }
                                if (n9 % 8 <= 0) continue;
                                n41 = 0;
                                for (componentSampleModel = 0; componentSampleModel < n9 % 8; ++componentSampleModel) {
                                    n41 |= nArray5[n45++] << 7 - componentSampleModel;
                                }
                                byArray4[n42++] = (byte)n41;
                            }
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, byteArrayOutputStream * ((n9 + 7) / 8));
                            continue block55;
                        }
                        if (n16 == 2) {
                            int n54 = (n9 + 7) / 8;
                            int n46 = 0;
                            n40 = 0;
                            for (n58 = 0; n58 < byteArrayOutputStream; ++n58) {
                                n44 = tIFFFaxEncoder.encodeRLE(byArray4, n46, 0, n9, byArray3);
                                this.output.write(byArray3, 0, n44);
                                n46 += n54;
                                n40 += n44;
                            }
                            lArray[n39++] = n40;
                            continue block55;
                        }
                        if (n16 == 3) {
                            int n55 = tIFFFaxEncoder.encodeT4(n7 == 0, bl5, byArray4, (n9 + 7) / 8, 0, n9, byteArrayOutputStream, byArray3);
                            lArray[n39++] = n55;
                            this.output.write(byArray3, 0, n55);
                            continue block55;
                        }
                        if (n16 == 4) {
                            int byArray6 = tIFFFaxEncoder.encodeT6(byArray4, (n9 + 7) / 8, 0, n9, byteArrayOutputStream, byArray3);
                            lArray[n39++] = byArray6;
                            this.output.write(byArray3, 0, byArray6);
                            continue block55;
                        }
                        if (n16 == 32773) {
                            int l6 = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n39++] = l6;
                            this.output.write(byArray3, 0, l6);
                            continue block55;
                        }
                        if (n16 != 32946) continue block55;
                        int n47 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n39++] = n47;
                        this.output.write(byArray3, 0, n47);
                        continue block55;
                    }
                    case 4: {
                        int n48 = 0;
                        for (n52 = 0; n52 < byteArrayOutputStream; ++n52) {
                            for (componentSampleModel = 0; componentSampleModel < n9 / 2; ++componentSampleModel) {
                                n41 = nArray5[n48++] << 4 | nArray5[n48++];
                                byArray4[n42++] = (byte)n41;
                            }
                            if (n9 % 2 != 1) continue;
                            n41 = nArray5[n48++] << 4;
                            byArray4[n42++] = (byte)n41;
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, byteArrayOutputStream * ((n9 + 1) / 2));
                            continue block55;
                        }
                        if (n16 == 32773) {
                            n52 = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n39++] = n52;
                            this.output.write(byArray3, 0, n52);
                            continue block55;
                        }
                        if (n16 != 32946) continue block55;
                        n52 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n39++] = n52;
                        this.output.write(byArray3, 0, n52);
                        continue block55;
                    }
                    case 8: {
                        int n43;
                        int n44;
                        if (n16 != 7) {
                            if (bl9) {
                                byte[] byArray5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)raster.getSampleModel();
                                n40 = componentSampleModel2.getOffset(n2 - raster.getSampleModelTranslateX(), n4 - raster.getSampleModelTranslateY());
                                int n59 = componentSampleModel2.getScanlineStride();
                                if (n59 == (int)l) {
                                    System.arraycopy(byArray5, n40, byArray4, 0, (int)l * byteArrayOutputStream);
                                } else {
                                    n44 = 0;
                                    for (n43 = 0; n43 < byteArrayOutputStream; ++n43) {
                                        System.arraycopy(byArray5, n40, byArray4, n44, (int)l);
                                        n40 += n59;
                                        n44 += (int)l;
                                    }
                                }
                            } else {
                                for (n52 = 0; n52 < n3; ++n52) {
                                    byArray4[n52] = (byte)nArray5[n52];
                                }
                            }
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, n3);
                            continue block55;
                        }
                        if (n16 == 32773) {
                            n52 = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n39++] = n52;
                            this.output.write(byArray3, 0, n52);
                            continue block55;
                        }
                        if (n16 == 7) {
                            long l3 = this.getOffset(this.output);
                            if (jPEGImageEncoder == null || jPEGEncodeParam.getWidth() != raster.getWidth() || jPEGEncodeParam.getHeight() != raster.getHeight()) {
                                jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam(raster, n28);
                                JPEGImageEncoder.modifyEncodeParam((JPEGEncodeParam)object4, jPEGEncodeParam, n15);
                                jPEGImageEncoder = JPEGCodec.createJPEGEncoder(this.output, jPEGEncodeParam);
                            }
                            if (bl7) {
                                WritableRaster writableRaster = null;
                                if (raster instanceof WritableRaster) {
                                    writableRaster = (WritableRaster)raster;
                                } else {
                                    writableRaster = raster.createCompatibleWritableRaster();
                                    writableRaster.setRect(raster);
                                }
                                if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
                                    writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                                }
                                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
                                jPEGImageEncoder.encode(bufferedImage);
                            } else {
                                jPEGImageEncoder.encode(raster.createTranslatedChild(0, 0));
                            }
                            long l5 = this.getOffset(this.output);
                            lArray[n39++] = (int)(l5 - l3);
                            continue block55;
                        }
                        if (n16 != 32946) continue block55;
                        n52 = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n39++] = n52;
                        this.output.write(byArray3, 0, n52);
                        continue block55;
                    }
                    case 16: {
                        n52 = 0;
                        for (componentSampleModel = 0; componentSampleModel < n3; ++componentSampleModel) {
                            n40 = (short)nArray5[componentSampleModel];
                            byArray4[n52++] = (byte)((n40 & 0xFF00) >> 8);
                            byArray4[n52++] = (byte)(n40 & 0xFF);
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, n3 * 2);
                            continue block55;
                        }
                        if (n16 == 32773) {
                            componentSampleModel = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n39++] = componentSampleModel;
                            this.output.write(byArray3, 0, componentSampleModel);
                            continue block55;
                        }
                        if (n16 != 32946) continue block55;
                        componentSampleModel = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n39++] = componentSampleModel;
                        this.output.write(byArray3, 0, componentSampleModel);
                        continue block55;
                    }
                    case 32: {
                        if (n21 == 3) {
                            componentSampleModel = 0;
                            for (n40 = 0; n40 < n3; ++n40) {
                                int n49 = nArray5[n40];
                                byArray4[componentSampleModel++] = (byte)((n49 & 0xFF000000) >> 24);
                                byArray4[componentSampleModel++] = (byte)((n49 & 0xFF0000) >> 16);
                                byArray4[componentSampleModel++] = (byte)((n49 & 0xFF00) >> 8);
                                byArray4[componentSampleModel++] = (byte)(n49 & 0xFF);
                            }
                        } else {
                            componentSampleModel = 0;
                            for (n40 = 0; n40 < n3; ++n40) {
                                int n50 = Float.floatToIntBits(fArray[n40]);
                                byArray4[componentSampleModel++] = (byte)((n50 & 0xFF000000) >> 24);
                                byArray4[componentSampleModel++] = (byte)((n50 & 0xFF0000) >> 16);
                                byArray4[componentSampleModel++] = (byte)((n50 & 0xFF00) >> 8);
                                byArray4[componentSampleModel++] = (byte)(n50 & 0xFF);
                            }
                        }
                        if (n16 == 1) {
                            this.output.write(byArray4, 0, n3 * 4);
                            continue block55;
                        }
                        if (n16 == 32773) {
                            componentSampleModel = TIFFImageEncoder.compressPackBits(byArray4, byteArrayOutputStream, (int)l, byArray3);
                            lArray[n39++] = componentSampleModel;
                            this.output.write(byArray3, 0, componentSampleModel);
                            continue block55;
                        }
                        if (n16 != 32946) continue block55;
                        componentSampleModel = TIFFImageEncoder.deflate(deflater, byArray4, byArray3);
                        lArray[n39++] = componentSampleModel;
                        this.output.write(byArray3, 0, componentSampleModel);
                    }
                }
            }
        }
        if (n16 == 1) {
            if (bl6) {
                this.output.write(0);
            }
        } else {
            n4 = 0;
            for (byteArrayOutputStream = 1; byteArrayOutputStream < n13; ++byteArrayOutputStream) {
                n3 = (int)lArray[byteArrayOutputStream - 1];
                n4 += n3;
                lArray2[byteArrayOutputStream] = lArray2[byteArrayOutputStream - 1] + (long)n3;
            }
            int n51 = n34 = bl ? 0 : n + n33 + (n4 += (int)lArray[n13 - 1]);
            if (n34 % 2 != 0) {
                ++n34;
                bl6 = true;
            }
            if (object == null) {
                if (bl6) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l6 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n);
                this.writeDirectory(n, treeSet, n34);
                seekableOutputStream.seek(l6);
            } else if (file != null) {
                int n52;
                this.output.close();
                FileInputStream fileInputStream = new FileInputStream(file);
                this.output = object;
                this.writeDirectory(n, treeSet, n34);
                byte[] byArray6 = new byte[8192];
                for (n2 = 0; n2 < n4 && (n52 = fileInputStream.read(byArray6)) != -1; n2 += n52) {
                    this.output.write(byArray6, 0, n52);
                }
                fileInputStream.close();
                file.delete();
                if (bl6) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream2 = (ByteArrayOutputStream)this.output;
                this.output = object;
                this.writeDirectory(n, treeSet, n34);
                byteArrayOutputStream2.writeTo(this.output);
                if (bl6) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return n34;
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n = sortedSet.size();
        int n2 = 2 + n * 12 + 4;
        for (TIFFField tIFFField : sortedSet) {
            int n3 = TIFFImageEncoder.getValueSize(tIFFField);
            if (n3 <= 4) continue;
            n2 += n3;
        }
        return n2;
    }

    private void writeFileHeader() throws IOException {
        if (this.isLittleEndian) {
            this.output.write(73);
            this.output.write(73);
        } else {
            this.output.write(77);
            this.output.write(77);
        }
        this.writeUnsignedShort(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n, SortedSet sortedSet, int n2) throws IOException {
        int n3 = sortedSet.size();
        long l = n + 12 * n3 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n3);
        for (TIFFField tIFFField : sortedSet) {
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            int n7 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n5 == 2 ? (long)n7 : (long)n6);
            if (n7 > 4) {
                this.writeLong(l);
                l += (long)n7;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n2);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.writeValues((TIFFField)arrayList.get(i));
        }
    }

    private static final int getValueSize(TIFFField tIFFField) {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        int n3 = 0;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = tIFFField.getAsString(i).getBytes();
                n3 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n3;
            }
        } else {
            n3 = n2 * sizeOfType[n];
        }
        return n3;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                int n3;
                byte[] byArray = tIFFField.getAsBytes();
                for (n3 = 0; n3 < n2; ++n3) {
                    this.output.write(byArray[n3]);
                }
                for (n3 = 0; n3 < 4 - n2; ++n3) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n4;
                char[] cArray = tIFFField.getAsChars();
                for (n4 = 0; n4 < n2; ++n4) {
                    this.writeUnsignedShort(cArray[n4]);
                }
                for (n4 = 0; n4 < 2 - n2; ++n4) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 8: {
                int n5;
                short[] sArray = tIFFField.getAsShorts();
                for (n5 = 0; n5 < n2; ++n5) {
                    this.writeUnsignedShort(sArray[n5]);
                }
                for (n5 = 0; n5 < 2 - n2; ++n5) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                this.writeLong(tIFFField.getAsLong(0));
                break;
            }
            case 9: {
                this.writeLong(tIFFField.getAsInt(0));
                break;
            }
            case 11: {
                this.writeLong(Float.floatToIntBits(tIFFField.getAsFloat(0)));
                break;
            }
            case 2: {
                int n6;
                int n7 = 0;
                for (n6 = 0; n6 < n2; ++n6) {
                    byte[] byArray = tIFFField.getAsString(n6).getBytes();
                    this.output.write(byArray);
                    n7 += byArray.length;
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                    ++n7;
                }
                for (n6 = 0; n6 < 4 - n7; ++n6) {
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i = 0; i < n2; ++i) {
                    this.output.write(byArray[i]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(cArray[i]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(sArray[i]);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
            case 9: {
                int[] nArray = tIFFField.getAsInts();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(nArray[i]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i = 0; i < n2; ++i) {
                    int n3 = Float.floatToIntBits(fArray[i]);
                    this.writeLong(n3);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i = 0; i < n2; ++i) {
                    long l = Double.doubleToLongBits(dArray[i]);
                    this.writeLong((int)(l >> 32));
                    this.writeLong((int)(l & 0xFFFFFFFFFFFFFFFFL));
                }
                break;
            }
            case 5: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i][0]);
                    this.writeLong(lArray[i][1]);
                }
                break;
            }
            case 10: {
                int[][] nArray = tIFFField.getAsSRationals();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(nArray[i][0]);
                    this.writeLong(nArray[i][1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    byte[] byArray = tIFFField.getAsString(i).getBytes();
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeUnsignedShort(int n) throws IOException {
        if (this.isLittleEndian) {
            this.output.write(n & 0xFF);
            this.output.write((n & 0xFF00) >>> 8);
        } else {
            this.output.write((n & 0xFF00) >>> 8);
            this.output.write(n & 0xFF);
        }
    }

    private void writeLong(long l) throws IOException {
        if (this.isLittleEndian) {
            this.output.write((int)l & 0xFF);
            this.output.write((int)((l & 0xFF00L) >>> 8));
            this.output.write((int)((l & 0xFF0000L) >>> 16));
            this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        } else {
            this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
            this.output.write((int)((l & 0xFF0000L) >>> 16));
            this.output.write((int)((l & 0xFF00L) >>> 8));
            this.output.write((int)l & 0xFF);
        }
    }

    private long getOffset(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).size();
        }
        if (outputStream instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)outputStream).getFilePointer();
        }
        throw new IllegalStateException();
    }

    private static int compressPackBits(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 = TIFFImageEncoder.packBits(byArray, n3, n2, byArray2, n4);
            n3 += n2;
        }
        return n4;
    }

    private static int packBits(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 1;
        int n5 = n4 - 1;
        while (n <= n4) {
            int n6;
            byte by = byArray[n];
            for (n6 = 1; n6 < 127 && n < n4 && byArray[n] == byArray[n + 1]; ++n6, ++n) {
            }
            if (n6 > 1) {
                ++n;
                byArray2[n3++] = (byte)(-(n6 - 1));
                byArray2[n3++] = by;
            }
            int n7 = n3;
            for (n6 = 0; n6 < 128 && (n < n4 && byArray[n] != byArray[n + 1] || n < n5 && byArray[n] != byArray[n + 2]); ++n6) {
                byArray2[++n3] = byArray[n++];
            }
            if (n6 > 0) {
                byArray2[n7] = (byte)(n6 - 1);
                ++n3;
            }
            if (n != n4) continue;
            if (n6 > 0 && n6 < 128) {
                int n8 = n7;
                byArray2[n8] = (byte)(byArray2[n8] + 1);
                byArray2[n3++] = byArray[n++];
                continue;
            }
            byArray2[n3++] = 0;
            byArray2[n3++] = byArray[n++];
        }
        return n3;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        deflater.reset();
        return n;
    }
}

