/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codecimpl.TIFFImageDecoder;
import com.sun.media.jai.codecimpl.TIFFImageEncoder;
import java.awt.image.RenderedImage;
import java.io.OutputStream;

public final class TIFFCodec
extends ImageCodec {
    public String getFormatName() {
        return "tiff";
    }

    public Class getEncodeParamClass() {
        return TIFFEncodeParam.class;
    }

    public Class getDecodeParamClass() {
        return TIFFDecodeParam.class;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        return new TIFFImageEncoder(outputStream, imageEncodeParam);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new TIFFImageDecoder(seekableStream, imageDecodeParam);
    }

    public int getNumHeaderBytes() {
        return 4;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        if (byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42 && byArray[3] == 0) {
            return true;
        }
        return byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && byArray[3] == 42;
    }
}

