/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.JPEGDecodeParam;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.NoMarkStream;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.util.ImagingException;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;

class JPEGImage
extends SimpleRenderedImage {
    private static final Object LOCK = new Object();
    private Raster theTile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPEGImage(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        if (inputStream.markSupported()) {
            inputStream = new NoMarkStream(inputStream);
        }
        BufferedImage bufferedImage = null;
        Object object = LOCK;
        synchronized (object) {
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder(inputStream);
            try {
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
            }
            catch (ImageFormatException imageFormatException) {
                String string = JaiI18N.getString("JPEGImageDecoder1");
                this.sendExceptionToListener(string, imageFormatException);
            }
            catch (IOException iOException) {
                String string = JaiI18N.getString("JPEGImageDecoder1");
                this.sendExceptionToListener(string, iOException);
            }
        }
        this.minX = 0;
        this.minY = 0;
        this.tileWidth = this.width = bufferedImage.getWidth();
        this.tileHeight = this.height = bufferedImage.getHeight();
        if ((imageDecodeParam == null || imageDecodeParam instanceof JPEGDecodeParam && ((JPEGDecodeParam)imageDecodeParam).getDecodeToCSM()) && !(bufferedImage.getSampleModel() instanceof ComponentSampleModel)) {
            int n = -1;
            int n2 = bufferedImage.getSampleModel().getNumBands();
            if (n2 == 1) {
                n = 10;
            } else if (n2 == 3) {
                n = 5;
            } else if (n2 == 4) {
                n = 6;
            } else {
                throw new RuntimeException(JaiI18N.getString("JPEGImageDecoder3"));
            }
            BufferedImage bufferedImage2 = new BufferedImage(this.width, this.height, n);
            bufferedImage2.getWritableTile(0, 0).setRect(bufferedImage.getWritableTile(0, 0));
            bufferedImage2.releaseWritableTile(0, 0);
            bufferedImage = bufferedImage2;
        }
        this.sampleModel = bufferedImage.getSampleModel();
        this.colorModel = bufferedImage.getColorModel();
        this.theTile = bufferedImage.getWritableTile(0, 0);
    }

    public synchronized Raster getTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGImageDecoder4"));
        }
        return this.theTile;
    }

    public void dispose() {
        this.theTile = null;
    }

    private void sendExceptionToListener(String string, Exception exception) {
        ImagingListenerProxy.errorOccurred(string, new ImagingException(string, exception), this, false);
    }
}

