/*
 * Decompiled with CFR 0.152.
 */
package com.sun.image.codec.jpeg;

import java.util.Arrays;

public class JPEGQTable {
    public static final JPEGQTable StdLuminance;
    public static final JPEGQTable StdChrominance;
    private int[] table;

    public JPEGQTable(int[] nArray) {
        if (nArray == null || nArray.length != 64) {
            throw new IllegalArgumentException("Not a valid table.");
        }
        this.table = Arrays.copyOf(nArray, nArray.length);
    }

    public int[] getTable() {
        return Arrays.copyOf(this.table, this.table.length);
    }

    public JPEGQTable getScaledInstance(float f, boolean bl) {
        int n = bl ? 255 : Short.MAX_VALUE;
        int[] nArray = new int[this.table.length];
        for (int i = 0; i < this.table.length; ++i) {
            int n2 = Math.round((float)this.table[i] * f);
            nArray[i] = n2 < 1 ? 1 : (n2 > n ? n : n2);
        }
        return new JPEGQTable(nArray);
    }

    static {
        int[] nArray = new int[]{16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99};
        StdLuminance = new JPEGQTable(nArray);
        int[] nArray2 = new int[]{17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        StdChrominance = new JPEGQTable(nArray2);
    }
}

