/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.PlanetaryGrid;

public class SeadasGrid {
    public static final int MAX_NUM_BINS = 0x7FFFFFFE;
    private final PlanetaryGrid baseGrid;

    public SeadasGrid(PlanetaryGrid baseGrid) {
        if (!SeadasGrid.isCompatibleBaseGrid(baseGrid)) {
            throw new IllegalArgumentException("Base grid has more than 2147483646 bins");
        }
        this.baseGrid = baseGrid;
    }

    public static boolean isCompatibleBaseGrid(PlanetaryGrid baseGrid) {
        return baseGrid.getNumBins() <= 0x7FFFFFFEL;
    }

    public int getNumRows() {
        return this.baseGrid.getNumRows();
    }

    public int getNumCols(int rowIndex) {
        return this.baseGrid.getNumCols(rowIndex);
    }

    public int getFirstBinIndex(int rowIndex) {
        return (int)(this.baseGrid.getFirstBinIndex(rowIndex) + 1L);
    }

    public int convertRowIndex(int rowIndex) {
        return this.baseGrid.getNumRows() - rowIndex - 1;
    }

    public int convertBinIndex(long beamBinIndex) {
        int rowIndex1 = this.baseGrid.getRowIndex(beamBinIndex);
        long binIndex1 = this.baseGrid.getFirstBinIndex(rowIndex1);
        long colIndex = beamBinIndex - binIndex1;
        int rowIndex2 = this.baseGrid.getNumRows() - (rowIndex1 + 1);
        long binIndex2 = this.baseGrid.getFirstBinIndex(rowIndex2);
        return (int)(binIndex2 + colIndex + 1L);
    }

    public long reverseBinIndex(long seadasBinIndex) {
        long zeroBaseIndex = seadasBinIndex - 1L;
        int rowIndex1 = this.baseGrid.getRowIndex(zeroBaseIndex);
        long binIndex1 = this.baseGrid.getFirstBinIndex(rowIndex1);
        long colIndex = zeroBaseIndex - binIndex1;
        int rowIndex2 = this.baseGrid.getNumRows() - (rowIndex1 + 1);
        long binIndex2 = this.baseGrid.getFirstBinIndex(rowIndex2);
        return binIndex2 + colIndex;
    }
}

