/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import com.bc.ceres.core.Assert;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.DataPeriod;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.VariableContext;
import org.locationtech.jts.geom.Geometry;

public class BinningContextImpl
implements BinningContext {
    private final PlanetaryGrid planetaryGrid;
    private final BinManager binManager;
    private final int superSampling;
    private final int maxDistanceOnEarth;
    private final CompositingType compositingType;
    private final DataPeriod dataPeriod;
    private final Geometry region;

    public BinningContextImpl(PlanetaryGrid planetaryGrid, BinManager binManager, CompositingType compositingType, int superSampling, int maxDistanceOnEarth, DataPeriod dataPeriod, Geometry region) {
        Assert.notNull((Object)planetaryGrid, (String)"planetaryGrid");
        Assert.notNull((Object)binManager, (String)"binManager");
        Assert.notNull((Object)((Object)compositingType), (String)"compositingType");
        this.planetaryGrid = planetaryGrid;
        this.binManager = binManager;
        this.compositingType = compositingType;
        this.superSampling = superSampling;
        this.maxDistanceOnEarth = maxDistanceOnEarth;
        this.dataPeriod = dataPeriod;
        this.region = region;
    }

    @Override
    public VariableContext getVariableContext() {
        return this.getBinManager().getVariableContext();
    }

    @Override
    public PlanetaryGrid getPlanetaryGrid() {
        return this.planetaryGrid;
    }

    @Override
    public BinManager getBinManager() {
        return this.binManager;
    }

    @Override
    public CompositingType getCompositingType() {
        return this.compositingType;
    }

    @Override
    public Integer getSuperSampling() {
        return this.superSampling;
    }

    @Override
    public Integer getMaxDistanceOnEarth() {
        return this.maxDistanceOnEarth;
    }

    @Override
    public DataPeriod getDataPeriod() {
        return this.dataPeriod;
    }

    @Override
    public Geometry getRegion() {
        return this.region;
    }
}

