/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.metadata;

import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;

class Utilities {
    Utilities() {
    }

    static MetadataElement createSourceMetaElement(String productName, int index) {
        MetadataElement productElement = new MetadataElement("source." + Integer.toString(index));
        MetadataAttribute nameAttribute = new MetadataAttribute("name", (ProductData)new ProductData.ASCII(productName), true);
        productElement.addAttribute(nameAttribute);
        return productElement;
    }

    static MetadataElement getProcessingGraphElement(Product product) {
        MetadataElement metadataRoot = product.getMetadataRoot();
        return metadataRoot.getElement("Processing_Graph");
    }

    static String extractProductName(Product product) {
        MetadataElement processingGraphElement = Utilities.getProcessingGraphElement(product);
        String productName = Utilities.extractProductName(processingGraphElement);
        if (StringUtils.isNullOrEmpty((String)productName)) {
            productName = product.getName();
        }
        return productName;
    }

    static String extractProductName(MetadataElement processingGraphElement) {
        MetadataAttribute sourceProductAttribute;
        MetadataElement sourcesElement;
        MetadataElement nodeElement;
        if (processingGraphElement != null && (nodeElement = processingGraphElement.getElement("node.0")) != null && (sourcesElement = nodeElement.getElement("sources")) != null && (sourceProductAttribute = sourcesElement.getAttribute("sourceProduct")) != null) {
            return sourceProductAttribute.getData().getElemString();
        }
        return null;
    }
}

