/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.core.Assert;
import java.util.Date;
import org.esa.snap.binning.operator.BinningProductFilter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;

class TimeRangeProductFilter
extends BinningProductFilter {
    private final Date rangeStart;
    private final Date rangeEnd;

    TimeRangeProductFilter(BinningProductFilter parent, ProductData.UTC rangeStart, ProductData.UTC rangeEnd) {
        this.setParent(parent);
        Assert.notNull((Object)rangeStart, (String)"rangeStart");
        Assert.notNull((Object)rangeEnd, (String)"rangeEnd");
        this.rangeStart = rangeStart.getAsDate();
        this.rangeEnd = rangeEnd.getAsDate();
    }

    @Override
    protected boolean acceptForBinning(Product product) {
        ProductData.UTC productStart = product.getStartTime();
        ProductData.UTC productEnd = product.getEndTime();
        if (productStart == null && productEnd == null) {
            return true;
        }
        if (productStart == null || productEnd == null) {
            boolean isDateInRange;
            Date productDate = productStart != null ? productStart.getAsDate() : productEnd.getAsDate();
            boolean bl = isDateInRange = productDate.after(this.rangeStart) && productDate.before(this.rangeEnd);
            if (!isDateInRange) {
                this.setReason("Does not match the time range.");
            }
            return isDateInRange;
        }
        if (productEnd.getAsDate().after(this.rangeStart) && productStart.getAsDate().before(this.rangeEnd)) {
            return true;
        }
        this.setReason("Does not match the time range.");
        return false;
    }
}

