/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import org.esa.snap.binning.DataPeriod;
import org.esa.snap.binning.operator.BinningProductFilter;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;

class SpatialDataDaySourceProductFilter
extends BinningProductFilter {
    private final DataPeriod dataPeriod;

    public SpatialDataDaySourceProductFilter(BinningProductFilter parent, DataPeriod dataPeriod) {
        this.setParent(parent);
        this.dataPeriod = dataPeriod;
    }

    @Override
    protected boolean acceptForBinning(Product product) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        ProductData.UTC firstScanLineTime = ProductUtils.getScanLineTime((Product)product, (double)0.0);
        ProductData.UTC lastScanLineTime = ProductUtils.getScanLineTime((Product)product, (double)(product.getSceneRasterHeight() - 1));
        if (firstScanLineTime == null || lastScanLineTime == null) {
            String message = String.format("not accepting product '%s': missing time coding", product.getName());
            this.setReason(message);
            return false;
        }
        double firstLon = geoCoding.getGeoPos((PixelPos)new PixelPos((double)0.0, (double)0.0), null).lon;
        DataPeriod.Membership topLeft = this.dataPeriod.getObservationMembership(firstLon, firstScanLineTime.getMJD());
        double lastLon = geoCoding.getGeoPos((PixelPos)new PixelPos((double)((double)(product.getSceneRasterWidth() - 1)), (double)0.0), null).lon;
        DataPeriod.Membership topRight = this.dataPeriod.getObservationMembership(lastLon, firstScanLineTime.getMJD());
        firstLon = geoCoding.getGeoPos((PixelPos)new PixelPos((double)0.0, (double)((double)(product.getSceneRasterHeight() - 1))), null).lon;
        DataPeriod.Membership bottomLeft = this.dataPeriod.getObservationMembership(firstLon, lastScanLineTime.getMJD());
        lastLon = geoCoding.getGeoPos((PixelPos)new PixelPos((double)((double)(product.getSceneRasterWidth() - 1)), (double)((double)(product.getSceneRasterHeight() - 1))), null).lon;
        DataPeriod.Membership bottomRight = this.dataPeriod.getObservationMembership(lastLon, lastScanLineTime.getMJD());
        String message = String.format("accepting product '%s': topLeftMembership=%s, topRightMembership=%s, bottomLeftMembership=%s, bottomRightMembership=%s, startTime=%s, endTime=%s", new Object[]{product.getName(), topLeft, topRight, bottomLeft, bottomRight, product.getStartTime(), product.getEndTime()});
        if (topLeft == topRight && topRight == bottomLeft && bottomLeft == bottomRight && topLeft != DataPeriod.Membership.CURRENT_PERIOD) {
            String msg = "not " + message;
            SystemUtils.LOG.finer(msg);
            this.setReason(msg);
            return false;
        }
        SystemUtils.LOG.finer(message);
        return true;
    }
}

