/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.operator.AbstractBinWriter;
import org.esa.snap.binning.support.SeadasGrid;
import org.esa.snap.core.datamodel.ProductData;
import org.locationtech.jts.geom.Geometry;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

class SeaDASLevel3BinWriter
extends AbstractBinWriter {
    private static final int BUFFER_SIZE = 4096;
    private BinningContext binningContext;
    private SeadasGrid seadasGrid;
    private PlanetaryGrid planetaryGrid;

    public SeaDASLevel3BinWriter(Geometry region, ProductData.UTC startTime, ProductData.UTC stopTime) {
        super(region, startTime, stopTime);
    }

    @Override
    public void setBinningContext(BinningContext binningContext) {
        this.binningContext = binningContext;
        this.planetaryGrid = binningContext.getPlanetaryGrid();
        this.seadasGrid = new SeadasGrid(this.planetaryGrid);
    }

    @Override
    public void write(Map<String, String> metadataProperties, List<TemporalBin> temporalBins) throws IOException {
        NetcdfFileWriter netcdfFile = NetcdfFileWriter.createNew((String)this.getTargetFilePath(), (boolean)false);
        netcdfFile.setLargeFile(true);
        netcdfFile.addGlobalAttribute("title", "Level-3 Binned Data");
        netcdfFile.addGlobalAttribute("super_sampling", (Number)this.binningContext.getSuperSampling());
        if (this.getRegion() != null) {
            netcdfFile.addGlobalAttribute("region", this.getRegion().toText());
        }
        this.writeGlobalTimeCoverageMetadata(netcdfFile);
        this.writeGlobalCommonMetadata(metadataProperties, netcdfFile);
        this.writeGlobalSEAGridMetadata(netcdfFile, this.planetaryGrid.getNumRows());
        Dimension binIndexDim = netcdfFile.addDimension("bin_index", this.planetaryGrid.getNumRows());
        Dimension binListDim = netcdfFile.addDimension("bin_list", temporalBins.size());
        Variable rowNumVar = netcdfFile.addVariable("bi_row_num", DataType.INT, Arrays.asList(binIndexDim));
        rowNumVar.addAttribute(new Attribute("comment", "zero-based index of row corresponding to each 'bin_index' record."));
        Variable vsizeVar = netcdfFile.addVariable("bi_vsize", DataType.DOUBLE, Arrays.asList(binIndexDim));
        vsizeVar.addAttribute(new Attribute("comment", "north-south extent (degrees latitude) of bins for each row."));
        Variable hsizeVar = netcdfFile.addVariable("bi_hsize", DataType.DOUBLE, Arrays.asList(binIndexDim));
        hsizeVar.addAttribute(new Attribute("comment", "east-west extent (degrees longitude) of bins for each row;\nranges from 360/SEAGrid_bins for the two equatorial rows to 120 for the two polar rows."));
        Variable startNumVar = netcdfFile.addVariable("bi_start_num", DataType.INT, Arrays.asList(binIndexDim));
        startNumVar.addAttribute(new Attribute("comment", "1-based bin number of first bin in the grid for each row (see bi_begin);\nalways the same set of values for the set of rows."));
        startNumVar.addAttribute(new Attribute("missing_value", (Number)0));
        startNumVar.addAttribute(new Attribute("_FillValue", (Number)0));
        Variable beginOffsetVar = netcdfFile.addVariable("bi_begin_offset", DataType.INT, Arrays.asList(binIndexDim));
        beginOffsetVar.addAttribute(new Attribute("comment", "0-based offset of the first data-containing bin in for each row."));
        beginOffsetVar.addAttribute(new Attribute("missing_value", (Number)-1));
        beginOffsetVar.addAttribute(new Attribute("_FillValue", (Number)-1));
        Variable beginVar = netcdfFile.addVariable("bi_begin", DataType.INT, Arrays.asList(binIndexDim));
        beginVar.addAttribute(new Attribute("comment", "1-based bin number of first data-containing bin for each row (see bi_start_num)."));
        beginVar.addAttribute(new Attribute("missing_value", (Number)0));
        beginVar.addAttribute(new Attribute("_FillValue", (Number)0));
        Variable extendVar = netcdfFile.addVariable("bi_extent", DataType.INT, Arrays.asList(binIndexDim));
        extendVar.addAttribute(new Attribute("comment", "number of bins actually stored (i.e. containing data for each row)."));
        Variable maxVar = netcdfFile.addVariable("bi_max", DataType.INT, Arrays.asList(binIndexDim));
        maxVar.addAttribute(new Attribute("comment", "the maximum number of bin for each row; ranges from 3 for the two polar rows to SEAGrid_bins for the two equatorial bins."));
        Variable binNumVar = netcdfFile.addVariable("bl_bin_num", DataType.INT, Arrays.asList(binListDim));
        Variable numObsVar = netcdfFile.addVariable("bl_nobs", DataType.INT, Arrays.asList(binListDim));
        Variable numScenesVar = netcdfFile.addVariable("bl_nscenes", DataType.INT, Arrays.asList(binListDim));
        BinManager binManager = this.binningContext.getBinManager();
        String[] resultFeatureNames = binManager.getResultFeatureNames();
        ArrayList<Variable> featureVars = new ArrayList<Variable>(resultFeatureNames.length);
        for (String featureName : resultFeatureNames) {
            Variable featureVar = netcdfFile.addVariable("bl_" + featureName, DataType.FLOAT, Arrays.asList(binListDim));
            featureVar.addAttribute(new Attribute("_FillValue", (Number)Float.valueOf(Float.NaN)));
            featureVars.add(featureVar);
        }
        netcdfFile.create();
        try {
            this.writeBinIndexVariables(netcdfFile, rowNumVar, vsizeVar, hsizeVar, startNumVar, maxVar);
            this.writeBinListVariables(netcdfFile, binNumVar, numObsVar, numScenesVar, featureVars, beginOffsetVar, beginVar, extendVar, temporalBins);
        }
        catch (InvalidRangeException e) {
            throw new IOException(e);
        }
        finally {
            netcdfFile.close();
        }
    }

    private void writeBinIndexVariables(NetcdfFileWriter netcdfFile, Variable rowNumVar, Variable vsizeVar, Variable hsizeVar, Variable startNumVar, Variable maxVar) throws IOException, InvalidRangeException {
        this.writeBinIndexVariable(netcdfFile, rowNumVar, new AbstractBinWriter.BinIndexElementSetter(){

            @Override
            public void setArray(Array array, int rowIndex, SeadasGrid grid) {
                array.setInt(rowIndex, rowIndex);
            }
        });
        this.writeBinIndexVariable(netcdfFile, startNumVar, new AbstractBinWriter.BinIndexElementSetter(){

            @Override
            public void setArray(Array array, int rowIndex, SeadasGrid grid) {
                array.setInt(rowIndex, grid.getFirstBinIndex(SeaDASLevel3BinWriter.this.seadasGrid.convertRowIndex(rowIndex)));
            }
        });
        this.writeBinIndexVariable(netcdfFile, vsizeVar, new AbstractBinWriter.BinIndexElementSetter(){

            @Override
            public void setArray(Array array, int rowIndex, SeadasGrid grid) {
                array.setDouble(rowIndex, 180.0 / (double)grid.getNumRows());
            }
        });
        this.writeBinIndexVariable(netcdfFile, hsizeVar, new AbstractBinWriter.BinIndexElementSetter(){

            @Override
            public void setArray(Array array, int rowIndex, SeadasGrid grid) {
                array.setDouble(rowIndex, 360.0 / (double)grid.getNumCols(SeaDASLevel3BinWriter.this.seadasGrid.convertRowIndex(rowIndex)));
            }
        });
        this.writeBinIndexVariable(netcdfFile, maxVar, new AbstractBinWriter.BinIndexElementSetter(){

            @Override
            public void setArray(Array array, int rowIndex, SeadasGrid grid) {
                array.setInt(rowIndex, grid.getNumCols(SeaDASLevel3BinWriter.this.seadasGrid.convertRowIndex(rowIndex)));
            }
        });
    }

    private void writeBinListVariables(NetcdfFileWriter netcdfFile, Variable binNumVar, Variable numObsVar, Variable numScenesVar, List<Variable> featureVars, Variable beginOffsetVar, Variable beginVar, Variable extendVar, List<TemporalBin> temporalBins) throws IOException, InvalidRangeException {
        ArrayList<AbstractBinWriter.BinListVar> binListVars = new ArrayList<AbstractBinWriter.BinListVar>();
        binListVars.add(new AbstractBinWriter.BinListVar(binNumVar, new AbstractBinWriter.BinListElementSetter(){

            @Override
            public void setArray(Array array, int binIndex, TemporalBin bin) {
                array.setInt(binIndex, SeaDASLevel3BinWriter.this.seadasGrid.convertBinIndex(bin.getIndex()));
            }
        }));
        binListVars.add(new AbstractBinWriter.BinListVar(numObsVar, new AbstractBinWriter.BinListElementSetter(){

            @Override
            public void setArray(Array array, int binIndex, TemporalBin bin) {
                array.setInt(binIndex, bin.getNumObs());
            }
        }));
        binListVars.add(new AbstractBinWriter.BinListVar(numScenesVar, new AbstractBinWriter.BinListElementSetter(){

            @Override
            public void setArray(Array array, int binIndex, TemporalBin bin) {
                array.setInt(binIndex, bin.getNumPasses());
            }
        }));
        int featureIndex = 0;
        while (featureIndex < featureVars.size()) {
            final int k = featureIndex++;
            binListVars.add(new AbstractBinWriter.BinListVar(featureVars.get(k), new AbstractBinWriter.BinListElementSetter(){

                @Override
                public void setArray(Array array, int binIndex, TemporalBin bin) {
                    array.setFloat(binIndex, bin.getFeatureValues()[k]);
                }
            }));
        }
        final int[] binRowBeginOffsets = new int[this.planetaryGrid.getNumRows()];
        final long[] binRowBegins = new long[this.planetaryGrid.getNumRows()];
        final int[] binRowExtends = new int[this.planetaryGrid.getNumRows()];
        Arrays.fill(binRowBeginOffsets, -1);
        Arrays.fill(binRowBegins, -1L);
        Arrays.fill(binRowExtends, 0);
        this.writeBinListVariable0(netcdfFile, temporalBins, binListVars, binRowBeginOffsets, binRowBegins, binRowExtends);
        this.writeBinIndexVariable(netcdfFile, beginOffsetVar, new AbstractBinWriter.BinIndexElementSetter(){

            @Override
            public void setArray(Array array, int rowIndex, SeadasGrid grid) {
                array.setInt(rowIndex, binRowBeginOffsets[SeaDASLevel3BinWriter.this.seadasGrid.convertRowIndex(rowIndex)]);
            }
        });
        this.writeBinIndexVariable(netcdfFile, beginVar, new AbstractBinWriter.BinIndexElementSetter(){

            @Override
            public void setArray(Array array, int rowIndex, SeadasGrid grid) {
                long id = binRowBegins[SeaDASLevel3BinWriter.this.seadasGrid.convertRowIndex(rowIndex)];
                if (id == -1L) {
                    array.setInt(rowIndex, 0);
                } else {
                    array.setInt(rowIndex, SeaDASLevel3BinWriter.this.seadasGrid.convertBinIndex(id));
                }
            }
        });
        this.writeBinIndexVariable(netcdfFile, extendVar, new AbstractBinWriter.BinIndexElementSetter(){

            @Override
            public void setArray(Array array, int rowIndex, SeadasGrid grid) {
                array.setInt(rowIndex, binRowExtends[SeaDASLevel3BinWriter.this.seadasGrid.convertRowIndex(rowIndex)]);
            }
        });
    }

    private void writeBinIndexVariable(NetcdfFileWriter netcdfFile, Variable variable, AbstractBinWriter.BinIndexElementSetter setter) throws IOException, InvalidRangeException {
        this.getLogger().info("Writing bin index variable " + variable.getFullName());
        int numRows = this.seadasGrid.getNumRows();
        Array array = Array.factory((DataType)variable.getDataType(), (int[])new int[]{numRows});
        for (int row = 0; row < numRows; ++row) {
            setter.setArray(array, row, this.seadasGrid);
        }
        netcdfFile.write(variable.getFullName(), array);
    }

    private void writeBinListVariable0(NetcdfFileWriter netcdfFile, List<TemporalBin> temporalBins, List<AbstractBinWriter.BinListVar> vars, int[] binRowBeginOffsets, long[] binRowBegins, int[] binRowExtends) throws IOException, InvalidRangeException {
        this.getLogger().info("Writing bin list variables");
        int[] origin = new int[1];
        int bufferIndex = 0;
        int lastRowIndex = -1;
        int rowIndex = -1;
        ArrayList<TemporalBin> rowBins = new ArrayList<TemporalBin>(2 * this.planetaryGrid.getNumRows());
        for (int i = temporalBins.size() - 1; i >= 0; --i) {
            TemporalBin temporalBin = temporalBins.get(i);
            long id = temporalBin.getIndex();
            rowIndex = this.planetaryGrid.getRowIndex(id);
            if (rowIndex == lastRowIndex) {
                rowBins.add(temporalBin);
                continue;
            }
            if (!rowBins.isEmpty()) {
                bufferIndex = this.writeRowBins(netcdfFile, rowBins, vars, origin, bufferIndex, lastRowIndex, binRowBeginOffsets, binRowBegins, binRowExtends);
                rowBins.clear();
            }
            rowBins.add(temporalBin);
            lastRowIndex = rowIndex;
        }
        if (!rowBins.isEmpty()) {
            bufferIndex = this.writeRowBins(netcdfFile, rowBins, vars, origin, bufferIndex, rowIndex, binRowBeginOffsets, binRowBegins, binRowExtends);
        }
        if (bufferIndex > 0) {
            SeaDASLevel3BinWriter.writeBinListVars(netcdfFile, vars, origin, bufferIndex);
        }
    }

    private int writeRowBins(NetcdfFileWriter netcdfFile, ArrayList<TemporalBin> rowBins, List<AbstractBinWriter.BinListVar> vars, int[] origin, int bufferIndex, int rowIndex, int[] binRowBeginOffsets, long[] binRowBegins, int[] binRowExtends) throws IOException, InvalidRangeException {
        int offset = origin[0] + bufferIndex;
        Collections.reverse(rowBins);
        for (TemporalBin rowBin : rowBins) {
            if (bufferIndex == 4096) {
                SeaDASLevel3BinWriter.writeBinListVars(netcdfFile, vars, origin);
                bufferIndex = 0;
                origin[0] = origin[0] + 4096;
            }
            SeaDASLevel3BinWriter.setBinListVarsArrayElement(vars, rowBin, bufferIndex);
            ++bufferIndex;
        }
        binRowBeginOffsets[rowIndex] = offset;
        binRowBegins[rowIndex] = rowBins.get(0).getIndex();
        binRowExtends[rowIndex] = rowBins.size();
        return bufferIndex;
    }
}

