/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.esa.snap.binning.operator.BinningProductFilter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.GeoUtils;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;

class RegionProductFilter
extends BinningProductFilter {
    private final Geometry region;
    private final GeometryFactory factory;

    public RegionProductFilter(BinningProductFilter parent, Geometry region) {
        this.setParent(parent);
        this.region = region;
        this.factory = new GeometryFactory();
    }

    @Override
    protected boolean acceptForBinning(Product product) {
        GeneralPath[] geoBoundaryPaths;
        for (GeneralPath geoBoundaryPath : geoBoundaryPaths = GeoUtils.createGeoBoundaryPaths((Product)product)) {
            Geometry boundary = this.getPolygon(geoBoundaryPath);
            if (!boundary.intersects(this.region)) continue;
            return true;
        }
        this.setReason("Does not intersect the region.");
        return false;
    }

    private Geometry getPolygon(GeneralPath geoBoundaryPath) {
        Geometry boundary = JTS.toGeometry((Shape)geoBoundaryPath, (GeometryFactory)this.factory);
        if (boundary instanceof LinearRing) {
            boundary = this.factory.createPolygon((LinearRing)boundary, null);
        }
        return boundary;
    }
}

