/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.operator.BinWriter;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.binning.support.SeadasGrid;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.locationtech.jts.geom.Geometry;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public abstract class AbstractBinWriter
implements BinWriter {
    private static final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final int BUFFER_SIZE = 4096;
    private final Geometry region;
    private final ProductData.UTC startTime;
    private final ProductData.UTC stopTime;
    private File targetFilePath;
    private Logger logger;

    public AbstractBinWriter(Geometry region, ProductData.UTC startTime, ProductData.UTC stopTime) {
        this.region = region;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.logger = SystemUtils.LOG;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setTargetFileTemplatePath(String targetFileTemplatePath) {
        this.targetFilePath = FileUtils.exchangeExtension((File)new File(targetFileTemplatePath), (String)"-bins.nc");
    }

    @Override
    public String getTargetFilePath() {
        return this.targetFilePath.getAbsolutePath();
    }

    Geometry getRegion() {
        return this.region;
    }

    protected void writeGlobalSEAGridMetadata(NetcdfFileWriter netcdfFile, int numRows) {
        netcdfFile.addGlobalAttribute("SEAGrid_bins", (Number)(2 * numRows));
        netcdfFile.addGlobalAttribute("SEAGrid_radius", (Number)SEAGrid.RE);
        netcdfFile.addGlobalAttribute("SEAGrid_max_north", (Number)90.0);
        netcdfFile.addGlobalAttribute("SEAGrid_max_south", (Number)-90.0);
        netcdfFile.addGlobalAttribute("SEAGrid_seam_lon", (Number)-180.0);
    }

    protected void writeGlobalCommonMetadata(Map<String, String> metadataProperties, NetcdfFileWriter netcdfFile) {
        for (String name : metadataProperties.keySet()) {
            String value = metadataProperties.get(name);
            try {
                netcdfFile.addGlobalAttribute(name, value);
            }
            catch (Exception e) {
                this.logger.warning(String.format("Failed to write metadata property to '%s': %s = %s", this.targetFilePath.getAbsolutePath(), name, value));
            }
        }
    }

    static String toDateString(ProductData.UTC utc) {
        return utc != null ? dateFormat.format(utc.getAsDate()) : "";
    }

    protected void writeGlobalTimeCoverageMetadata(NetcdfFileWriter netcdfFile) {
        String startTimeString = AbstractBinWriter.toDateString(this.startTime);
        String stopTimeString = AbstractBinWriter.toDateString(this.stopTime);
        netcdfFile.addGlobalAttribute("start_time", startTimeString);
        netcdfFile.addGlobalAttribute("stop_time", stopTimeString);
        netcdfFile.addGlobalAttribute("time_coverage_start", startTimeString);
        netcdfFile.addGlobalAttribute("time_coverage_end", stopTimeString);
    }

    protected static void setBinListVarsArrayElement(List<BinListVar> vars, TemporalBin temporalBin, int bufferIndex) {
        for (BinListVar var : vars) {
            var.setter.setArray(var.buffer, bufferIndex, temporalBin);
        }
    }

    protected static void writeBinListVars(NetcdfFileWriter netcdfFile, List<BinListVar> vars, int[] origin) throws IOException, InvalidRangeException {
        for (BinListVar var : vars) {
            netcdfFile.write(var.variable.getFullName(), origin, var.buffer);
        }
    }

    protected static void writeBinListVars(NetcdfFileWriter netcdfFile, List<BinListVar> vars, int[] origin, int bufferIndex) throws IOException, InvalidRangeException {
        int[] origin0 = new int[]{0};
        int[] shape = new int[]{bufferIndex};
        for (BinListVar var : vars) {
            String fullName = var.variable.getFullName();
            Array valuesToWrite = var.buffer.sectionNoReduce(origin0, shape, null);
            netcdfFile.write(fullName, origin, valuesToWrite);
        }
    }

    protected static class BinListVar {
        private final Variable variable;
        private final BinListElementSetter setter;
        private final Array buffer;

        protected BinListVar(Variable variable, BinListElementSetter setter) {
            this.variable = variable;
            this.setter = setter;
            this.buffer = Array.factory((DataType)variable.getDataType(), (int[])new int[]{4096});
        }
    }

    protected static interface BinListElementSetter {
        public void setArray(Array var1, int var2, TemporalBin var3);
    }

    protected static interface BinIndexElementSetter {
        public void setArray(Array var1, int var2, SeadasGrid var3);
    }
}

