/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.cellprocessor;

import org.esa.snap.binning.CellProcessor;
import org.esa.snap.binning.CellProcessorConfig;
import org.esa.snap.binning.CellProcessorDescriptor;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.core.gpf.annotations.Parameter;

public class FeatureSelection
extends CellProcessor {
    private final int[] varIndexes;

    public FeatureSelection(VariableContext varCtx, String ... featureNames) {
        super(FeatureSelection.getOutputFeatureNames(featureNames));
        String[] inputFeatureNames = FeatureSelection.getInputFeatureNames(featureNames);
        this.varIndexes = new int[inputFeatureNames.length];
        for (int i = 0; i < inputFeatureNames.length; ++i) {
            String name = inputFeatureNames[i];
            int variableIndex = varCtx.getVariableIndex(name);
            if (variableIndex == -1) {
                throw new IllegalArgumentException("unknown feature name: " + name);
            }
            this.varIndexes[i] = variableIndex;
        }
    }

    private static String[] getInputFeatureNames(String[] featureNames) {
        return FeatureSelection.getFeatureNames(featureNames, 1);
    }

    private static String[] getOutputFeatureNames(String[] featureNames) {
        return FeatureSelection.getFeatureNames(featureNames, 0);
    }

    private static String[] getFeatureNames(String[] featureNames, int index) {
        String[] result = new String[featureNames.length];
        for (int i = 0; i < featureNames.length; ++i) {
            String featureName = featureNames[i];
            if (featureName.contains("=")) {
                featureName = featureName.split("=")[index];
            }
            result[i] = featureName.trim();
        }
        return result;
    }

    @Override
    public void compute(Vector inputVector, WritableVector outputVector) {
        for (int i = 0; i < this.varIndexes.length; ++i) {
            outputVector.set(i, inputVector.get(this.varIndexes[i]));
        }
    }

    public static class Descriptor
    implements CellProcessorDescriptor {
        public static final String NAME = "Selection";

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public CellProcessor createCellProcessor(VariableContext varCtx, CellProcessorConfig cellProcessorConfig) {
            Config config = (Config)cellProcessorConfig;
            return new FeatureSelection(varCtx, config.varNames);
        }

        @Override
        public CellProcessorConfig createConfig() {
            return new Config(new String[0]);
        }
    }

    public static class Config
    extends CellProcessorConfig {
        @Parameter(notEmpty=true, notNull=true)
        private String[] varNames;

        public Config(String ... varNames) {
            super("Selection");
            this.varNames = varNames;
        }
    }
}

