/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.cellprocessor;

import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.support.BinTracer;

public class CellProcessorChain {
    private final BinManager binManager;
    private final BinTracer binTracer;

    public CellProcessorChain(BinningContext binningContext) {
        this.binManager = binningContext.getBinManager();
        this.binTracer = this.binManager.getBinTracer();
    }

    public TemporalBin process(TemporalBin temporalBin) {
        if (this.binManager.hasPostProcessor()) {
            WritableVector temporalVector = temporalBin.toVector();
            TemporalBin processBin = this.binManager.createProcessBin(temporalBin.getIndex());
            this.binManager.postProcess(temporalVector, processBin.toVector());
            processBin.setNumObs(temporalBin.getNumObs());
            processBin.setNumPasses(temporalBin.getNumPasses());
            long binIndex = temporalBin.getIndex();
            if (BinTracer.traceThis(this.binTracer, binIndex)) {
                this.binTracer.tracePost(temporalBin, processBin);
            }
            return processBin;
        }
        return temporalBin;
    }
}

