/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.aggregators;

import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.AggregatorDescriptor;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.util.StringUtils;

public class AggregatorMeanObs
extends AbstractAggregator {
    private final int varIndex;

    public AggregatorMeanObs(VariableContext varCtx, String varName) {
        super("MEAN_OBS", AggregatorMeanObs.createFeatureNames(varName, "mean", "sigma", "counts"), AggregatorMeanObs.createFeatureNames(varName, "mean", "sigma", "counts"), AggregatorMeanObs.createFeatureNames(varName, "mean", "sigma", "counts"));
        this.varIndex = varCtx.getVariableIndex(varName);
    }

    @Override
    public void initSpatial(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
        vector.set(1, 0.0f);
        vector.set(2, 0.0f);
    }

    @Override
    public void aggregateSpatial(BinContext ctx, Observation observationVector, WritableVector spatialVector) {
        float value = observationVector.get(this.varIndex);
        if (!Float.isNaN(value)) {
            spatialVector.set(0, spatialVector.get(0) + value);
            spatialVector.set(1, spatialVector.get(1) + value * value);
            spatialVector.set(2, spatialVector.get(2) + 1.0f);
        }
    }

    @Override
    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
    }

    @Override
    public void initTemporal(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
        vector.set(1, 0.0f);
        vector.set(2, 0.0f);
    }

    @Override
    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        float sum = spatialVector.get(0);
        if (!Float.isNaN(sum)) {
            float sumSqr = spatialVector.get(1);
            float counts = spatialVector.get(2);
            temporalVector.set(0, temporalVector.get(0) + sum);
            temporalVector.set(1, temporalVector.get(1) + sumSqr);
            temporalVector.set(2, temporalVector.get(2) + counts);
        }
    }

    @Override
    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
    }

    @Override
    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        double sum = temporalVector.get(0);
        double sumSqr = temporalVector.get(1);
        double counts = temporalVector.get(2);
        if (counts > 0.0) {
            double mean = sum / counts;
            double sigmaSqr = sumSqr / counts - mean * mean;
            double sigma = sigmaSqr > 0.0 ? Math.sqrt(sigmaSqr) : 0.0;
            outputVector.set(0, (float)mean);
            outputVector.set(1, (float)sigma);
            outputVector.set(2, (float)counts);
        } else {
            outputVector.set(0, Float.NaN);
            outputVector.set(1, Float.NaN);
            outputVector.set(2, 0.0f);
        }
    }

    public static class Descriptor
    implements AggregatorDescriptor {
        public static final String NAME = "MEAN_OBS";

        @Override
        public Aggregator createAggregator(VariableContext varCtx, AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            String targetName = StringUtils.isNotNullAndNotEmpty((String)config.targetName) ? config.targetName : config.varName;
            return new AggregatorMeanObs(varCtx, targetName);
        }

        @Override
        public String[] getSourceVarNames(AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            return new String[]{config.varName};
        }

        @Override
        public String[] getTargetVarNames(AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            if (StringUtils.isNullOrEmpty((String)config.targetName)) {
                return AbstractAggregator.createFeatureNames(config.varName, "mean", "sigma", "counts");
            }
            return AbstractAggregator.createFeatureNames(config.targetName, "mean", "sigma", "counts");
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public AggregatorConfig createConfig() {
            return new Config();
        }
    }

    public static class Config
    extends AggregatorConfig {
        @Parameter(label="Source band name", notEmpty=true, notNull=true, description="The source band used for aggregation.")
        String varName;
        @Parameter(label="Target band name prefix (optional)", description="The name prefix for the resulting bands. If empty, the source band name is used.")
        String targetName;

        public Config() {
            this(null, null);
        }

        public Config(String varName, String targetName) {
            super("MEAN_OBS");
            this.varName = varName;
            this.targetName = targetName;
        }
    }
}

