/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.aggregators;

import java.util.Arrays;
import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.AggregatorDescriptor;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WeightFn;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.util.StringUtils;

public class AggregatorAverageML
extends AbstractAggregator {
    public static final double EPS = 1.0E-9;
    private final int varIndex;
    private final WeightFn weightFn;
    private final boolean outputSums;

    public AggregatorAverageML(VariableContext ctx, String varName, double weightCoeff) {
        this(ctx, varName, varName, weightCoeff, false);
    }

    public AggregatorAverageML(VariableContext ctx, String varName, String targetName, double weightCoeff, boolean outputSums) {
        super("AVG_ML", AggregatorAverageML.createFeatureNames(varName, "sum", "sum_sq"), AggregatorAverageML.createFeatureNames(varName, "sum", "sum_sq", "weights"), outputSums ? AggregatorAverageML.createFeatureNames(targetName, "sum", "sum_sq", "weights") : AggregatorAverageML.createFeatureNames(targetName, "mean", "sigma", "median", "mode"));
        this.outputSums = outputSums;
        this.varIndex = ctx.getVariableIndex(varName);
        this.weightFn = WeightFn.createPow(weightCoeff);
    }

    @Override
    public void initSpatial(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
        vector.set(1, 0.0f);
    }

    @Override
    public void initTemporal(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
        vector.set(1, 0.0f);
        vector.set(2, 0.0f);
    }

    @Override
    public void aggregateSpatial(BinContext ctx, Observation observationVector, WritableVector spatialVector) {
        double x = observationVector.get(this.varIndex);
        double logX = Math.log(x > 1.0E-9 ? x : 1.0E-9);
        spatialVector.set(0, spatialVector.get(0) + (float)logX);
        spatialVector.set(1, spatialVector.get(1) + (float)(logX * logX));
    }

    @Override
    public void completeSpatial(BinContext ctx, int numObs, WritableVector numSpatialObs) {
        float w = this.weightFn.eval(numObs);
        numSpatialObs.set(0, numSpatialObs.get(0) / w);
        numSpatialObs.set(1, numSpatialObs.get(1) / w);
    }

    @Override
    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        temporalVector.set(0, temporalVector.get(0) + spatialVector.get(0));
        temporalVector.set(1, temporalVector.get(1) + spatialVector.get(1));
        temporalVector.set(2, temporalVector.get(2) + this.weightFn.eval(numSpatialObs));
    }

    @Override
    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
    }

    @Override
    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        double sumX = temporalVector.get(0);
        double sumXX = temporalVector.get(1);
        double sumW = temporalVector.get(2);
        if (this.outputSums) {
            outputVector.set(0, (float)sumX);
            outputVector.set(1, (float)sumXX);
            outputVector.set(2, (float)sumW);
        } else {
            double avLogs = sumX / sumW;
            double vrLogs = sumXX / sumW - avLogs * avLogs;
            double mean = Math.exp(avLogs + 0.5 * vrLogs);
            double expVrLogs = Math.exp(vrLogs);
            double sigma = mean * (expVrLogs > 1.0 ? Math.sqrt(expVrLogs - 1.0) : 0.0);
            double median = Math.exp(avLogs);
            double mode = Math.exp(avLogs - vrLogs);
            outputVector.set(0, (float)mean);
            outputVector.set(1, (float)sigma);
            outputVector.set(2, (float)median);
            outputVector.set(3, (float)mode);
        }
    }

    public String toString() {
        return "AggregatorAverageML{varIndex=" + this.varIndex + ", weightFn=" + this.weightFn + ", spatialFeatureNames=" + Arrays.toString(this.getSpatialFeatureNames()) + ", temporalFeatureNames=" + Arrays.toString(this.getTemporalFeatureNames()) + ", outputFeatureNames=" + Arrays.toString(this.getOutputFeatureNames()) + "}";
    }

    public static class Descriptor
    implements AggregatorDescriptor {
        public static final String NAME = "AVG_ML";

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public AggregatorConfig createConfig() {
            return new Config();
        }

        @Override
        public Aggregator createAggregator(VariableContext varCtx, AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            boolean outputSums = config.outputSums != null ? config.outputSums : false;
            String targetName = StringUtils.isNotNullAndNotEmpty((String)config.targetName) ? config.targetName : config.varName;
            double weightCoeff = config.weightCoeff != null ? config.weightCoeff : 0.5;
            return new AggregatorAverageML(varCtx, config.varName, targetName, weightCoeff, outputSums);
        }

        @Override
        public String[] getSourceVarNames(AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            return new String[]{config.varName};
        }

        @Override
        public String[] getTargetVarNames(AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            boolean outputSums = config.outputSums != null ? config.outputSums : false;
            String targetName = StringUtils.isNotNullAndNotEmpty((String)config.targetName) ? config.targetName : config.varName;
            return outputSums ? AbstractAggregator.createFeatureNames(targetName, "sum", "sum_sq", "weights") : AbstractAggregator.createFeatureNames(targetName, "mean", "sigma", "median", "mode");
        }
    }

    public static class Config
    extends AggregatorConfig {
        @Parameter(label="Source band name", notEmpty=true, notNull=true, description="The source band used for aggregation.")
        String varName;
        @Parameter(label="Target band name prefix (optional)", description="The name prefix for the resulting bands. If empty, the source band name is used.")
        String targetName;
        @Parameter(defaultValue="0.5", description="The number of spatial observation to the power of this value \nwill define the weighting factor of the sums.")
        Double weightCoeff;
        @Parameter(defaultValue="false", description="If true, the result will include the sum of all values.")
        Boolean outputSums;

        public Config() {
            this(null, null, 0.0, false);
        }

        public Config(String varName, String targetName, double weightCoeff, boolean outputSums) {
            super("AVG_ML");
            this.varName = varName;
            this.targetName = targetName;
            this.weightCoeff = weightCoeff;
            this.outputSums = outputSums;
        }
    }
}

