/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

public abstract class WeightFn {
    public static WeightFn createPow(double c) {
        if (c == 0.0) {
            return new One();
        }
        if (c == 0.5) {
            return new Sqrt();
        }
        if (c == 1.0) {
            return new Ident();
        }
        return new Pow(c);
    }

    public abstract float eval(int var1);

    private static final class Pow
    extends WeightFn {
        private final double c;

        private Pow(double c) {
            this.c = c;
        }

        @Override
        public float eval(int numObs) {
            return (float)Math.pow(numObs, this.c);
        }
    }

    private static final class Sqrt
    extends WeightFn {
        private Sqrt() {
        }

        @Override
        public float eval(int numObs) {
            return (float)Math.sqrt(numObs);
        }
    }

    private static final class One
    extends WeightFn {
        private One() {
        }

        @Override
        public float eval(int numObs) {
            return 1.0f;
        }
    }

    private static final class Ident
    extends WeightFn {
        private Ident() {
        }

        @Override
        public float eval(int numObs) {
            return numObs;
        }
    }
}

