/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.esa.snap.binning.Bin;

public class TemporalBin
extends Bin {
    int numPasses;

    public TemporalBin() {
    }

    public TemporalBin(long index, int numFeatures) {
        super(index, numFeatures);
    }

    public int getNumPasses() {
        return this.numPasses;
    }

    public void setNumPasses(int numPasses) {
        this.numPasses = numPasses;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.numObs);
        dataOutput.writeInt(this.numPasses);
        dataOutput.writeInt(this.featureValues.length);
        for (float value : this.featureValues) {
            dataOutput.writeFloat(value);
        }
    }

    public static TemporalBin read(DataInput dataInput) throws IOException {
        TemporalBin bin = new TemporalBin();
        bin.readFields(dataInput);
        return bin;
    }

    public static TemporalBin read(long index, DataInput dataInput) throws IOException {
        TemporalBin bin = new TemporalBin();
        bin.readFields(dataInput);
        bin.index = index;
        return bin;
    }

    public String toString() {
        return String.format("%s{index=%d, numObs=%d, numPasses=%d, featureValues=%s}", this.getClass().getSimpleName(), this.index, this.numObs, this.numPasses, Arrays.toString(this.featureValues));
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.numObs = dataInput.readInt();
        this.numPasses = dataInput.readInt();
        int numFeatures = dataInput.readInt();
        this.featureValues = new float[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            this.featureValues[i] = dataInput.readFloat();
        }
    }
}

