/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.esa.snap.binning.Bin;
import org.esa.snap.binning.support.GrowableVector;

public class SpatialBin
extends Bin {
    protected GrowableVector[] vectors;

    public SpatialBin() {
        this.vectors = new GrowableVector[0];
    }

    public SpatialBin(long index, int numFeatures) {
        this(index, numFeatures, 0);
    }

    public SpatialBin(long index, int numFeatures, int numGrowableFeatures) {
        super(index, numFeatures);
        if (numGrowableFeatures > 0) {
            this.vectors = new GrowableVector[numGrowableFeatures];
            for (int i = 0; i < numGrowableFeatures; ++i) {
                this.vectors[i] = new GrowableVector(256);
            }
        } else {
            this.vectors = new GrowableVector[0];
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.numObs);
        dataOutput.writeInt(this.featureValues.length);
        for (float value : this.featureValues) {
            dataOutput.writeFloat(value);
        }
        int numVectors = this.vectors.length;
        dataOutput.writeInt(numVectors);
        for (GrowableVector vector : this.vectors) {
            int vectorSize = vector.size();
            dataOutput.writeInt(vectorSize);
            for (int k = 0; k < vectorSize; ++k) {
                dataOutput.writeFloat(vector.get(k));
            }
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.numObs = dataInput.readInt();
        int numFeatures = dataInput.readInt();
        this.featureValues = new float[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            this.featureValues[i] = dataInput.readFloat();
        }
        int numVectors = dataInput.readInt();
        this.vectors = new GrowableVector[numVectors];
        for (int i = 0; i < numVectors; ++i) {
            GrowableVector vector;
            int vectorLength = dataInput.readInt();
            this.vectors[i] = vector = new GrowableVector(vectorLength);
            for (int k = 0; k < vectorLength; ++k) {
                vector.add(dataInput.readFloat());
            }
        }
    }

    public static SpatialBin read(DataInput dataInput) throws IOException {
        return SpatialBin.read(-1L, dataInput);
    }

    public static SpatialBin read(long index, DataInput dataInput) throws IOException {
        SpatialBin bin = new SpatialBin();
        bin.index = index;
        bin.readFields(dataInput);
        return bin;
    }

    public GrowableVector[] getVectors() {
        return this.vectors;
    }

    public String toString() {
        return String.format("%s{index=%d, numObs=%d, featureValues=%s}", this.getClass().getSimpleName(), this.index, this.numObs, Arrays.toString(this.featureValues));
    }
}

