/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import com.bc.ceres.compiler.CodeCompiler;
import com.bc.ceres.jai.ExpressionCompilerConfig;
import com.bc.ceres.jai.opimage.ExpressionCode;
import com.bc.ceres.jai.opimage.ExpressionCodeGenerator;
import java.awt.RenderingHints;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;

public class ExpressionCRIF
extends CRIFImpl {
    public ExpressionCRIF() {
        super("Expression");
    }

    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout;
        Map sourceMap = (Map)paramBlock.getSource(0);
        int dataType = paramBlock.getIntParameter(0);
        String expression = (String)paramBlock.getObjectParameter(1);
        ExpressionCompilerConfig compilerConfig = (ExpressionCompilerConfig)paramBlock.getObjectParameter(2);
        ImageLayout imageLayout = layout = renderHints != null ? (ImageLayout)renderHints.get(JAI.KEY_IMAGE_LAYOUT) : null;
        if (layout == null) {
            layout = new ImageLayout();
        }
        RenderedImage sourceImage = (RenderedImage)sourceMap.values().iterator().next();
        layout.setWidth(sourceImage.getWidth());
        layout.setHeight(sourceImage.getHeight());
        layout.setSampleModel((SampleModel)new PixelInterleavedSampleModel(dataType, sourceImage.getWidth(), sourceImage.getHeight(), 1, sourceImage.getWidth(), new int[]{0}));
        return this.create(sourceMap, expression, compilerConfig, renderHints, layout);
    }

    private RenderedImage create(Map<String, RenderedImage> sourceMap, String expression, ExpressionCompilerConfig compilerConfig, Map config, ImageLayout layout) {
        String packageName = ((Object)((Object)this)).getClass().getPackage().getName();
        String className = "ExpressionOpImage_" + Long.toHexString(System.nanoTime());
        ExpressionCode code = ExpressionCodeGenerator.generate(packageName, className, sourceMap, layout.getSampleModel(null).getDataType(), expression);
        try {
            Class<?> opImageClass = new CodeCompiler(compilerConfig.getOutputDir(), compilerConfig.getClassPath()).compile(code);
            return (OpImage)opImageClass.getConstructor(Vector.class, Map.class, ImageLayout.class).newInstance(code.getSources(), config, layout);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

