/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai;

import com.bc.ceres.jai.operator.XmlDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterListDescriptor;

public class JaiShell {
    String opt;

    public static void main(String[] args) {
        if (args.length == 0) {
            JaiShell.printUsage();
        }
        boolean interactive = false;
        ArrayList<String> argList = new ArrayList<String>();
        HashMap<String, String> configuration = new HashMap<String, String>(64);
        Properties properties = System.getProperties();
        for (String name : properties.stringPropertyNames()) {
            configuration.put(name, properties.getProperty(name));
        }
        for (String arg : args) {
            if (arg.equals("-i")) {
                interactive = true;
                continue;
            }
            if (arg.startsWith("-D")) {
                String[] tokens = arg.substring(2).split("=", 2);
                configuration.put(tokens[0], tokens.length == 2 ? tokens[1] : "");
                continue;
            }
            if (arg.startsWith("-?")) {
                JaiShell.printOpHelp(arg, 2);
                continue;
            }
            argList.add(arg);
        }
        for (String arg : argList) {
            File file = new File(arg);
            try {
                URI location = JaiShell.createInput(file, configuration);
                XmlDescriptor.create(location, null, null).getRendering();
            }
            catch (Throwable t) {
                System.out.println("Error: " + t.getMessage());
            }
        }
        if (interactive) {
            System.out.println("Note: The interactive shell is not yet implemented. \n      You can only use the '?' or '?<op>' function.");
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                String line;
                block15: {
                    System.out.print("\n> ");
                    try {
                        line = r.readLine();
                        if (line == null) {
                        }
                        break block15;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                if ((line = line.trim()).equalsIgnoreCase("exit")) {
                    System.out.println("Bye!");
                    break;
                }
                if (!line.startsWith("?")) continue;
                JaiShell.printOpHelp(line, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI createInput(File file, HashMap<String, String> conf) throws IOException {
        String text = JaiShell.readText(file, conf);
        File tempFile = File.createTempFile("jai", "xml");
        try (FileWriter writer = new FileWriter(tempFile);){
            writer.write(text);
        }
        return tempFile.toURI();
    }

    private static String readText(File file, HashMap<String, String> conf) throws IOException {
        return JaiShell.replace(JaiShell.read(file), conf).toString();
    }

    private static StringBuilder read(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            StringBuilder stringBuilder = JaiShell.readAll(reader);
            return stringBuilder;
        }
    }

    private static StringBuilder readAll(Reader reader) throws IOException {
        int i;
        StringBuilder sb = new StringBuilder(1024);
        while ((i = reader.read()) != -1) {
            sb.append((char)i);
        }
        return sb;
    }

    private static StringBuilder replace(StringBuilder text, HashMap<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            int i;
            String p = "${" + entry.getKey() + "}";
            while ((i = text.indexOf(p)) != -1) {
                text.replace(i, i + p.length(), entry.getValue());
            }
        }
        return text;
    }

    private static void printOpHelp(String s, int i) {
        String name = s.substring(i);
        if (name.equals("")) {
            JaiShell.printOperatorList();
        } else {
            JaiShell.printOperatorHelp(name);
        }
    }

    private static void printOperatorHelp(String name) {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        OperationDescriptor descriptor = (OperationDescriptor)operationRegistry.getDescriptor(OperationDescriptor.class, name);
        if (descriptor == null) {
            System.out.println("Unknown operation '" + name + "'");
            return;
        }
        String[][] resources = descriptor.getResources(Locale.getDefault());
        String globalName = resources[0][1];
        String description = resources[3][1];
        String[] sourceNames = descriptor.getSourceNames();
        Class[] sourceTypes = descriptor.getSourceClasses("rendered");
        ParameterListDescriptor parameterListDescriptor = descriptor.getParameterListDescriptor("rendered");
        String[] paramNames = parameterListDescriptor.getParamNames();
        Class[] paramTypes = parameterListDescriptor.getParamClasses();
        StringBuilder text = new StringBuilder();
        text.append("Usage: ");
        text.append(globalName);
        text.append('(');
        StringBuilder paramListText = new StringBuilder();
        if (sourceNames != null) {
            for (String sourceName : sourceNames) {
                if (paramListText.length() > 0) {
                    paramListText.append(", ");
                }
                paramListText.append(sourceName);
            }
        }
        if (paramNames != null) {
            for (String paramName : paramNames) {
                if (paramListText.length() > 0) {
                    paramListText.append(", ");
                }
                paramListText.append(paramName);
                Object defaultValue = parameterListDescriptor.getParamDefaultValue(paramName);
                if (defaultValue == ParameterListDescriptor.NO_PARAMETER_DEFAULT) continue;
                paramListText.append("=");
                paramListText.append(JaiShell.format(defaultValue));
            }
        }
        text.append((CharSequence)paramListText);
        text.append(')');
        text.append('\n');
        text.append("Description: ");
        text.append(description);
        text.append('\n');
        text.append("Arguments:\n");
        if (sourceNames != null) {
            for (int i = 0; i < sourceNames.length; ++i) {
                String sourceName = sourceNames[i];
                Class sourceType = sourceTypes[i];
                text.append("  ");
                text.append(sourceName);
                text.append(": ");
                text.append("A source.");
                text.append(" (" + sourceType.getName() + ")");
                text.append('\n');
            }
        }
        if (paramNames != null) {
            for (int i = 0; i < paramNames.length; ++i) {
                String paramName = paramNames[i];
                Class paramType = paramTypes[i];
                text.append("  ");
                text.append(paramName);
                text.append(": ");
                text.append(resources[6 + i][1]);
                text.append(" (" + paramType.getName() + ")");
                text.append('\n');
            }
        }
        System.out.println(text);
    }

    private static String format(Object value) {
        if (value == null) {
            return "null";
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(JaiShell.format(Array.get(value, i)));
            }
            builder.append('}');
            return builder.toString();
        }
        if (EnumeratedParameter.class.isAssignableFrom(type)) {
            return ((EnumeratedParameter)value).getName();
        }
        if (Interpolation.class.isAssignableFrom(type)) {
            if (Interpolation.getInstance((int)0).equals(value)) {
                return "INTERP_NEAREST";
            }
            if (Interpolation.getInstance((int)1).equals(value)) {
                return "INTERP_BILINEAR";
            }
            if (Interpolation.getInstance((int)2).equals(value)) {
                return "INTERP_BICUBIC";
            }
            if (Interpolation.getInstance((int)3).equals(value)) {
                return "INTERP_BICUBIC_2";
            }
        } else if (CharSequence.class.isAssignableFrom(type)) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return String.valueOf(value);
    }

    private static void printUsage() {
        System.out.println("Usage: jai [-?[<op>]] [-i] {-D<param-name>=<param-value>} {<xml-file>}\n");
    }

    private static void printOperatorList() {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        List descriptors = operationRegistry.getDescriptors(OperationDescriptor.class);
        Collections.sort(descriptors, new Comparator<OperationDescriptor>(){

            @Override
            public int compare(OperationDescriptor descriptor1, OperationDescriptor descriptor2) {
                return descriptor1.getName().compareTo(descriptor2.getName());
            }
        });
        int columnCount = 0;
        for (OperationDescriptor descriptor : descriptors) {
            columnCount = Math.max(columnCount, descriptor.getName().length());
        }
        for (OperationDescriptor descriptor : descriptors) {
            Object namePart = descriptor.getName();
            if (((String)namePart).length() < columnCount) {
                namePart = (String)namePart + JaiShell.spaces(columnCount - ((String)namePart).length());
            }
            String[][] resources = descriptor.getResources(Locale.getDefault());
            String description = resources[3][1];
            System.out.println((String)namePart + " - " + description);
        }
    }

    private static String spaces(int n) {
        char[] c = new char[n];
        Arrays.fill(c, ' ');
        return new String(c);
    }
}

