/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.compiler;

import java.util.HashMap;
import java.util.Map;

public class CodeMapper {
    private static final char EOS = '\uffff';

    public static CodeMapping mapCode(CharSequence code, NameMapper nameMapper) {
        char ch;
        StringBuilder codeBuilder = new StringBuilder(2 * code.length());
        StringBuilder nameBuilder = new StringBuilder(16);
        HashMap<String, String> mappings = new HashMap<String, String>(16);
        int pos = 0;
        do {
            char c = ch = pos < code.length() ? (char)code.charAt(pos++) : (char)'\uffff';
            if (nameBuilder.length() == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    nameBuilder.append(ch);
                    continue;
                }
                if (ch == 65535) continue;
                codeBuilder.append(ch);
                continue;
            }
            if (Character.isJavaIdentifierPart(ch) || ch == '.') {
                nameBuilder.append(ch);
                continue;
            }
            String name = nameBuilder.toString();
            String mappedName = nameMapper.mapName(name);
            if (mappedName != null) {
                mappings.put(name, mappedName);
                codeBuilder.append(mappedName);
            } else {
                codeBuilder.append(name);
            }
            if (ch != '\uffff') {
                codeBuilder.append(ch);
            }
            nameBuilder.setLength(0);
        } while (ch != 65535);
        return new CodeMappingImpl(codeBuilder.toString(), mappings);
    }

    private static class CodeMappingImpl
    implements CodeMapping {
        final String mappedCode;
        final Map<String, String> mappings;

        public CodeMappingImpl(String mappedCode, Map<String, String> mappings) {
            this.mappedCode = mappedCode;
            this.mappings = mappings;
        }

        @Override
        public String getMappedCode() {
            return this.mappedCode;
        }

        @Override
        public Map<String, String> getMappings() {
            return this.mappings;
        }
    }

    public static interface CodeMapping {
        public String getMappedCode();

        public Map<String, String> getMappings();
    }

    public static interface NameMapper {
        public String mapName(String var1);
    }
}

