/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Map;
import javax.media.jai.ParameterBlockJAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseMathOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.NumberRange;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class Multiply
extends BaseMathOperationJAI {
    private static final long serialVersionUID = 3559075474256896861L;

    public Multiply() {
        super("Multiply", Multiply.getOperationDescriptor(JAIExt.getOperationName((String)"Multiply")));
    }

    @Override
    public String getName() {
        return "Multiply";
    }

    @Override
    protected NumberRange<? extends Number> deriveRange(NumberRange<? extends Number>[] ranges, OperationJAI.Parameters parameters) {
        if (ranges != null && ranges.length == 2) {
            NumberRange<? extends Number> range0 = ranges[0];
            NumberRange<? extends Number> range1 = ranges[1];
            double min0 = range0.getMinimum();
            double min1 = range1.getMinimum();
            double max0 = range0.getMaximum();
            double max1 = range1.getMaximum();
            double max = max0 * max1;
            double min = min0 * min1;
            return NumberRange.create((double)min, (double)max);
        }
        return null;
    }

    @Override
    protected void handleJAIEXTParams(ParameterBlockJAI parameters, ParameterValueGroup parameters2) {
        if (JAIExt.isJAIExtOperation((String)"algebric")) {
            parameters.set((Object)AlgebraDescriptor.Operator.MULTIPLY, 0);
            Collection sources = (Collection)parameters2.parameter("sources").getValue();
            for (GridCoverage2D source : sources) {
                Multiply.handleROINoDataInternal(parameters, source, "algebric", 1, 2);
            }
        }
    }

    @Override
    protected void extractSources(ParameterValueGroup parameters, Collection<GridCoverage2D> sources, String[] sourceNames) throws ParameterNotFoundException, InvalidParameterValueException {
        try {
            Collection paramSources = (Collection)parameters.parameter("Sources").getValue();
            if (paramSources.size() >= 2) {
                sources.addAll(paramSources);
                return;
            }
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            // empty catch block
        }
        super.extractSources(parameters, sources, sourceNames);
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        return Multiply.handleROINoDataProperties(null, parameters.parameters, sources[0], "algebric", 1, 2, 3);
    }
}

