/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.variable;

import org.esa.smos.ee2netcdf.variable.ByteStructMemberWriter;
import org.esa.smos.ee2netcdf.variable.DoubleStructMemberWriter;
import org.esa.smos.ee2netcdf.variable.FloatStructMember2DWriter;
import org.esa.smos.ee2netcdf.variable.FloatStructMemberWriter;
import org.esa.smos.ee2netcdf.variable.FloatStructSequence2DWriter;
import org.esa.smos.ee2netcdf.variable.IntStructMemberWriter;
import org.esa.smos.ee2netcdf.variable.IntStructSequence2DWriter;
import org.esa.smos.ee2netcdf.variable.LongStructMemberWriter;
import org.esa.smos.ee2netcdf.variable.ShortStructMemberWriter;
import org.esa.smos.ee2netcdf.variable.ShortStructSequence2DWriter;
import org.esa.smos.ee2netcdf.variable.VariableDescriptor;
import org.esa.smos.ee2netcdf.variable.VariableWriter;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import ucar.ma2.DataType;

public class VariableWriterFactory {
    public static VariableWriter create(NVariable nVariable, VariableDescriptor variableDescriptor, int gridPointCount, int btDataCount) {
        DataType dataType = variableDescriptor.getDataType();
        int memberIndex = variableDescriptor.getBtDataMemberIndex();
        boolean is2d = variableDescriptor.isIs2d();
        float fillValue = 0.0f;
        if (variableDescriptor.isFillValuePresent()) {
            fillValue = variableDescriptor.getFillValue();
        }
        if (is2d) {
            if (dataType == DataType.FLOAT) {
                if (variableDescriptor.isGridPointData()) {
                    return new FloatStructSequence2DWriter(nVariable, gridPointCount, btDataCount, memberIndex, fillValue);
                }
                return new FloatStructMember2DWriter(nVariable, gridPointCount, btDataCount, memberIndex, fillValue);
            }
            if (dataType == DataType.INT) {
                return new IntStructSequence2DWriter(nVariable, gridPointCount, btDataCount, memberIndex, (int)fillValue);
            }
            if (dataType == DataType.SHORT) {
                return new ShortStructSequence2DWriter(nVariable, gridPointCount, btDataCount, memberIndex, (short)fillValue);
            }
            if (dataType == DataType.BYTE) {
                throw new IllegalArgumentException("Unsupported data type for writer: " + dataType);
            }
        } else {
            if (dataType == DataType.FLOAT) {
                return new FloatStructMemberWriter(nVariable, memberIndex, gridPointCount, fillValue);
            }
            if (dataType == DataType.INT) {
                return new IntStructMemberWriter(nVariable, memberIndex, gridPointCount, (int)fillValue);
            }
            if (dataType == DataType.SHORT) {
                return new ShortStructMemberWriter(nVariable, memberIndex, gridPointCount, (short)fillValue);
            }
            if (dataType == DataType.BYTE) {
                return new ByteStructMemberWriter(nVariable, memberIndex, gridPointCount, (byte)fillValue);
            }
            if (dataType == DataType.LONG) {
                return new LongStructMemberWriter(nVariable, memberIndex, gridPointCount, (long)fillValue);
            }
            if (dataType == DataType.DOUBLE) {
                return new DoubleStructMemberWriter(nVariable, memberIndex, gridPointCount, fillValue);
            }
        }
        throw new IllegalArgumentException("Unsupported data type for writer: " + dataType);
    }
}

