/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.variable;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import org.esa.smos.ee2netcdf.variable.AbstractVariableWriter;
import org.esa.smos.ee2netcdf.variable.VariableHelper;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;

class ShortStructSequence2DWriter
extends AbstractVariableWriter {
    private final int memberIndex;

    ShortStructSequence2DWriter(NVariable variable, int width, int height, int memberIndex, short fillValue) {
        this.variable = variable;
        this.memberIndex = memberIndex;
        short[] shortArray = VariableHelper.getShortVector(width * height, fillValue);
        this.array = Array.factory((DataType)DataType.SHORT, (int[])new int[]{width, height}, (Object)shortArray);
    }

    @Override
    public void write(CompoundData gridPointData, SequenceData btDataList, int index) throws IOException {
        Index arrayIndex = this.array.getIndex();
        int size = btDataList.getElementCount();
        for (int i = 0; i < size; ++i) {
            short data = btDataList.getCompound(i).getShort(this.memberIndex);
            arrayIndex.set(index, i);
            this.array.setShort(arrayIndex, data);
        }
    }
}

