/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.variable;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import org.esa.smos.ee2netcdf.variable.AbstractVariableWriter;
import org.esa.smos.ee2netcdf.variable.VariableHelper;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;

class IntStructSequence2DWriter
extends AbstractVariableWriter {
    private final int memberIndex;

    IntStructSequence2DWriter(NVariable variable, int width, int height, int memberIndex, int fillValue) {
        this.variable = variable;
        this.memberIndex = memberIndex;
        int[] intArray = VariableHelper.getIntVector(width * height, fillValue);
        this.array = Array.factory((DataType)DataType.INT, (int[])new int[]{width, height}, (Object)intArray);
    }

    @Override
    public void write(CompoundData gridPointData, SequenceData btDataList, int index) throws IOException {
        Index arrayIndex = this.array.getIndex();
        long size = btDataList.getElementCount();
        int i = 0;
        while ((long)i < size) {
            int data = btDataList.getCompound(i).getInt(this.memberIndex);
            arrayIndex.set(index, i);
            this.array.setInt(arrayIndex, data);
            ++i;
        }
    }
}

