/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.variable;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import java.io.IOException;
import org.esa.smos.ee2netcdf.variable.AbstractVariableWriter;
import org.esa.smos.ee2netcdf.variable.VariableHelper;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;

class FloatStructMember2DWriter
extends AbstractVariableWriter {
    private final int memberIndex;

    FloatStructMember2DWriter(NVariable variable, int width, int height, int memberIndex, float fillValue) {
        this.variable = variable;
        this.memberIndex = memberIndex;
        float[] floatArray = VariableHelper.getFloatVector(width * height, fillValue);
        this.array = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{width, height}, (Object)floatArray);
    }

    @Override
    public void write(CompoundData gridPointData, SequenceData btDataList, int index) throws IOException {
        Index arrayIndex = this.array.getIndex();
        SequenceData sequence = gridPointData.getSequence(this.memberIndex);
        long size = sequence.getElementCount();
        int i = 0;
        while ((long)i < size) {
            float data = sequence.getFloat(i);
            arrayIndex.set(index, i);
            this.array.setFloat(arrayIndex, data);
            ++i;
        }
    }
}

