/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import java.awt.geom.Area;
import java.io.IOException;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.ee2netcdf.reader.ArrayCache;
import ucar.ma2.Array;

class VariableValueProvider
extends AbstractValueProvider {
    private final Area area;
    private final GridPointInfo gridPointInfo;
    private final ArrayCache arrayCache;
    private final String variableName;

    VariableValueProvider(ArrayCache arrayCache, String variableName, Area area, GridPointInfo gridPointInfo) {
        this.area = area;
        this.gridPointInfo = gridPointInfo;
        this.arrayCache = arrayCache;
        this.variableName = variableName;
    }

    public Area getArea() {
        return this.area;
    }

    public int getGridPointIndex(int seqnum) {
        return this.gridPointInfo.getGridPointIndex(seqnum);
    }

    public byte getByte(int gridPointIndex) throws IOException {
        Array array = this.arrayCache.get(this.variableName);
        return array.getByte(gridPointIndex);
    }

    public short getShort(int gridPointIndex) throws IOException {
        Array array = this.arrayCache.get(this.variableName);
        return array.getShort(gridPointIndex);
    }

    public int getInt(int gridPointIndex) throws IOException {
        Array array = this.arrayCache.get(this.variableName);
        return array.getInt(gridPointIndex);
    }

    public float getFloat(int gridPointIndex) throws IOException {
        Array array = this.arrayCache.get(this.variableName);
        return array.getFloat(gridPointIndex);
    }
}

