/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import java.awt.geom.Area;
import java.io.IOException;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.ee2netcdf.reader.ArrayCache;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;

public class ScienceValueProvider
extends AbstractValueProvider {
    private final Area area;
    private final GridPointInfo gridPointInfo;
    private final String variableName;
    private final ArrayCache arrayCache;
    private final BandDescriptor descriptor;
    private final double incidenceAngleScalingFactor;
    private long snapshotId;

    ScienceValueProvider(ArrayCache arrayCache, String variableName, BandDescriptor descriptor, Area area, GridPointInfo gridPointInfo, double incidenceAngleScalingFactor) {
        this.area = area;
        this.gridPointInfo = gridPointInfo;
        this.variableName = variableName;
        this.arrayCache = arrayCache;
        this.descriptor = descriptor;
        this.incidenceAngleScalingFactor = incidenceAngleScalingFactor;
        this.snapshotId = -1L;
    }

    public Area getArea() {
        return this.area;
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public int getGridPointIndex(int seqnum) {
        return this.gridPointInfo.getGridPointIndex(seqnum);
    }

    public byte getByte(int gridPointIndex) {
        if (this.snapshotId == -1L) {
            return (byte)this.getInterpolatedValue(gridPointIndex);
        }
        return (byte)this.getSnapshotValue(gridPointIndex);
    }

    public short getShort(int gridPointIndex) {
        if (this.snapshotId == -1L) {
            return (short)this.getInterpolatedValue(gridPointIndex);
        }
        return (short)this.getSnapshotValue(gridPointIndex);
    }

    public int getInt(int gridPointIndex) {
        if (this.snapshotId == -1L) {
            return (int)this.getInterpolatedValue(gridPointIndex);
        }
        return (int)this.getSnapshotValue(gridPointIndex);
    }

    public float getFloat(int gridPointIndex) {
        if (this.snapshotId == -1L) {
            return this.getInterpolatedValue(gridPointIndex);
        }
        return this.getSnapshotValue(gridPointIndex);
    }

    private float getInterpolatedValue(int gridPointIndex) {
        float fillValue = (float)this.descriptor.getFillValue();
        try {
            Array flagsArray = this.arrayCache.get("Flags");
            Array incidenceAngleArray = this.arrayCache.get("Incidence_Angle");
            if (flagsArray == null || incidenceAngleArray == null) {
                return fillValue;
            }
            Array gpArray = this.arrayCache.get(this.variableName);
            Array gpDataVector = this.extractGridPointVector(gridPointIndex, gpArray);
            Index dataIndex = gpDataVector.getIndex();
            Array flagsVector = this.extractGridPointVector(gridPointIndex, flagsArray);
            Index flagsIndex = flagsVector.getIndex();
            Array incidenceAngleVector = this.extractGridPointVector(gridPointIndex, incidenceAngleArray);
            Index angleVectorIndex = incidenceAngleVector.getIndex();
            int count = 0;
            double sx = 0.0;
            double sy = 0.0;
            double sxx = 0.0;
            double sxy = 0.0;
            boolean hasLower = false;
            boolean hasUpper = false;
            int polarization = this.descriptor.getPolarization();
            int i = 0;
            while ((long)i < gpDataVector.getSize()) {
                dataIndex.set(i);
                flagsIndex.set(i);
                angleVectorIndex.set(i);
                float value = gpDataVector.getFloat(dataIndex);
                if (!((double)Math.abs(value - fillValue) < 1.0E-8)) {
                    double incidenceAngle;
                    int flags = flagsVector.getInt(flagsIndex);
                    if ((polarization == 4 || polarization == (flags & 3) || (polarization & flags & 2) != 0) && (incidenceAngle = this.incidenceAngleScalingFactor * (double)incidenceAngleVector.getInt(angleVectorIndex)) >= 37.5 && incidenceAngle <= 52.5) {
                        sx += incidenceAngle;
                        sy += (double)value;
                        sxx += incidenceAngle * incidenceAngle;
                        sxy += incidenceAngle * (double)value;
                        ++count;
                        if (!hasLower) {
                            boolean bl = hasLower = incidenceAngle <= 42.5;
                        }
                        if (!hasUpper) {
                            hasUpper = incidenceAngle > 42.5;
                        }
                    }
                }
                ++i;
            }
            if (hasLower && hasUpper) {
                double a = ((double)count * sxy - sx * sy) / ((double)count * sxx - sx * sx);
                double b = (sy - a * sx) / (double)count;
                return (float)(a * 42.5 + b);
            }
        }
        catch (IOException | InvalidRangeException e) {
            return fillValue;
        }
        return fillValue;
    }

    private float getSnapshotValue(int gridPointIndex) {
        float fillValue = (float)this.descriptor.getFillValue();
        try {
            Array snapshotIdOfPixelArray = this.arrayCache.get("Snapshot_ID_of_Pixel");
            Array flagsArray = this.arrayCache.get("Flags");
            if (snapshotIdOfPixelArray == null || flagsArray == null) {
                return fillValue;
            }
            Array gpArray = this.arrayCache.get(this.variableName);
            Array gpDataVector = this.extractGridPointVector(gridPointIndex, gpArray);
            Index dataIndex = gpDataVector.getIndex();
            Array snapsotIdVector = this.extractGridPointVector(gridPointIndex, snapshotIdOfPixelArray);
            Index snapshotIndex = snapsotIdVector.getIndex();
            Array flagsVector = this.extractGridPointVector(gridPointIndex, flagsArray);
            Index flagsIndex = flagsVector.getIndex();
            int polarization = this.descriptor.getPolarization();
            int i = 0;
            while ((long)i < gpDataVector.getSize()) {
                snapshotIndex.set(i);
                long pixelSnapshotId = snapsotIdVector.getLong(snapshotIndex);
                if (pixelSnapshotId == this.snapshotId) {
                    flagsIndex.set(i);
                    int flags = flagsVector.getInt(flagsIndex);
                    if (polarization == 4 || polarization == (flags & 1) || (polarization & flags & 2) != 0) {
                        dataIndex.set(i);
                        return gpDataVector.getFloat(dataIndex);
                    }
                }
                ++i;
            }
        }
        catch (IOException | InvalidRangeException e) {
            return fillValue;
        }
        return fillValue;
    }

    private Array extractGridPointVector(int gridPointIndex, Array array) throws InvalidRangeException {
        int[] origin = new int[]{gridPointIndex, 0};
        int[] shape = array.getShape();
        shape[0] = 1;
        return array.section(origin, shape);
    }
}

