/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.esa.smos.SmosUtils;
import org.esa.smos.dataio.smos.DggUtils;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.L1cPolarisationModel;
import org.esa.smos.dataio.smos.PolarisationModel;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.SmosMultiLevelSource;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.dataio.smos.provider.DPH;
import org.esa.smos.dataio.smos.provider.DPV;
import org.esa.smos.dataio.smos.provider.FPH;
import org.esa.smos.dataio.smos.provider.FPHVR;
import org.esa.smos.dataio.smos.provider.FPV;
import org.esa.smos.dataio.smos.provider.ValueProvider;
import org.esa.smos.ee2netcdf.reader.AbstractProductTypeSupport;
import org.esa.smos.ee2netcdf.reader.ArrayCache;
import org.esa.smos.ee2netcdf.reader.ScienceFlagsValueProvider;
import org.esa.smos.ee2netcdf.reader.ScienceValueProvider;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

class ScienceProductSupport
extends AbstractProductTypeSupport {
    private final String typeString;
    private Future<SnapshotInfo> snapshotInfoFuture;
    private double incidentAngleScaleFactor;

    ScienceProductSupport(NetcdfFile netcdfFile, String typeString) {
        super(netcdfFile);
        this.typeString = typeString;
    }

    static boolean allRequiredArrayPresent(Array latitude, Array longitude, Array btDataCounter, Array snapshotIdOfPixel, Array flags, Array snapshotId) {
        return latitude != null && longitude != null && btDataCounter != null && snapshotIdOfPixel != null && flags != null & snapshotId != null;
    }

    static boolean containsAccuracy_XY_Bands(Product product) {
        return product.containsBand("Pixel_Radiometric_Accuracy_X") && product.containsBand("Pixel_Radiometric_Accuracy_Y");
    }

    static boolean containsAccuracy_XY_FP_Bands(Product product) {
        return ScienceProductSupport.containsAccuracy_XY_Bands(product) && product.containsBand("Pixel_Radiometric_Accuracy_XY");
    }

    static boolean containsBT_XY_Bands(Product product) {
        return product.containsBand("BT_Value_X") && product.containsBand("BT_Value_Y");
    }

    static boolean containsBT_XY_FP_Bands(Product product) {
        return ScienceProductSupport.containsBT_XY_Bands(product) && product.containsBand("BT_Value_XY_Real");
    }

    static boolean containsAllRotationBands(Product product) {
        return product.containsBand("Faraday_Rotation_Angle_X") && product.containsBand("Faraday_Rotation_Angle_Y") && product.containsBand("Geometric_Rotation_Angle_X") && product.containsBand("Geometric_Rotation_Angle_Y");
    }

    @Override
    public void initialize(Family<BandDescriptor> bandDescriptors) {
        boolean found = false;
        List bandDescriptorList = bandDescriptors.asList();
        for (BandDescriptor bandDescriptor : bandDescriptorList) {
            if (!bandDescriptor.getMemberName().startsWith("Incidence_Angle")) continue;
            this.incidentAngleScaleFactor = bandDescriptor.getScalingFactor();
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("No Incidence_Angle variable found");
        }
        super.initialize(bandDescriptors);
    }

    @Override
    public String getLatitudeBandName() {
        return "Grid_Point_Latitude";
    }

    @Override
    public String getLongitudeBandName() {
        return "Grid_Point_Longitude";
    }

    @Override
    public boolean canOpenFile() {
        return this.containsVariable("Grid_Point_Latitude") && this.containsVariable("Grid_Point_Longitude") && this.containsVariable("Grid_Point_ID") && this.containsVariable("Flags") && this.containsVariable("Incidence_Angle");
    }

    @Override
    public AbstractValueProvider createValueProvider(ArrayCache arrayCache, String variableName, BandDescriptor descriptor, Area area, GridPointInfo gridPointInfo) {
        if (descriptor.getMemberName().equals("Flags")) {
            Variable incidenceAngleVariable = this.netcdfFile.findVariable("Incidence_Angle");
            if (incidenceAngleVariable == null) {
                return null;
            }
            return new ScienceFlagsValueProvider(arrayCache, variableName, descriptor, area, gridPointInfo, this.incidentAngleScaleFactor);
        }
        return new ScienceValueProvider(arrayCache, variableName, descriptor, area, gridPointInfo, this.incidentAngleScaleFactor);
    }

    @Override
    public void createAdditionalBands(Product product, Area area, Family<BandDescriptor> bandDescriptors, String formatName, HashMap<String, AbstractValueProvider> valueProvierMap) {
        if (SmosUtils.isDualPolScienceFormat((String)formatName)) {
            this.addRotatedDualPoleBands(product, bandDescriptors, valueProvierMap);
        } else {
            this.addRotatedFullPoleBands(product, bandDescriptors, valueProvierMap);
        }
    }

    @Override
    public boolean canSupplyGridPointBtData() {
        return true;
    }

    @Override
    public boolean canSupplyFullPolData() {
        return SmosUtils.isFullPolScienceFormat((String)this.typeString);
    }

    @Override
    public boolean canSupplySnapshotData() {
        return true;
    }

    @Override
    public boolean hasSnapshotInfo() {
        if (this.snapshotInfoFuture == null) {
            this.snapshotInfoFuture = Executors.newSingleThreadExecutor().submit(this::createSnapshotInfo);
        }
        return this.snapshotInfoFuture.isDone();
    }

    @Override
    public SnapshotInfo getSnapshotInfo() {
        try {
            return this.snapshotInfoFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object[][] getSnapshotData(int snapshotIndex) {
        try {
            Object[][] snapshotData = new Object[this.snapshotDataNames.length][2];
            for (int i = 0; i < this.snapshotDataNames.length; ++i) {
                String variableName = this.snapshotDataNames[i];
                Array array = this.arrayCache.get(variableName);
                snapshotData[i][0] = variableName;
                snapshotData[i][1] = array.getDouble(snapshotIndex);
            }
            return snapshotData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SnapshotInfo createSnapshotInfo() throws IOException {
        this.ensureDataStructuresInitialized();
        TreeSet<Long> all = new TreeSet<Long>();
        TreeSet<Long> x = new TreeSet<Long>();
        TreeSet<Long> y = new TreeSet<Long>();
        TreeSet<Long> xy = new TreeSet<Long>();
        TreeMap<Long, Rectangle2D> snapshotAreaMap = new TreeMap<Long, Rectangle2D>();
        TreeMap<Long, Integer> snapshotIndexMap = new TreeMap<Long, Integer>();
        Array latitude = this.arrayCache.get("Grid_Point_Latitude");
        Array longitude = this.arrayCache.get("Grid_Point_Longitude");
        Array btDataCounter = this.arrayCache.get("BT_Data_Counter");
        Array snapshotIdOfPixel = this.arrayCache.get("Snapshot_ID_of_Pixel");
        Array flags = this.arrayCache.get("Flags");
        Array snapshotId = this.arrayCache.get("Snapshot_ID");
        if (ScienceProductSupport.allRequiredArrayPresent(latitude, longitude, btDataCounter, snapshotIdOfPixel, flags, snapshotId)) {
            Dimension dimension = this.netcdfFile.findDimension("n_grid_points");
            int gridPointCount = dimension.getLength();
            for (int i = 0; i < gridPointCount; ++i) {
                int btCount = btDataCounter.getInt(i);
                Index snapshotIdOfPixelIndex = snapshotIdOfPixel.getIndex();
                Index flagsIndex = flags.getIndex();
                if (btCount <= 0) continue;
                double lon = longitude.getDouble(i);
                double lat = latitude.getDouble(i);
                if (lon > 180.0) {
                    lon -= 360.0;
                }
                Rectangle2D rectangle = DggUtils.createGridPointRectangle((double)lon, (double)lat);
                long lastId = -1L;
                block6: for (int j = 0; j < btCount; ++j) {
                    snapshotIdOfPixelIndex.set(i, j);
                    long id = snapshotIdOfPixel.getLong(snapshotIdOfPixelIndex);
                    if (lastId != id) {
                        all.add(id);
                        if (snapshotAreaMap.containsKey(id)) {
                            ((Rectangle2D)snapshotAreaMap.get(id)).add(rectangle);
                        } else {
                            snapshotAreaMap.put(id, rectangle);
                        }
                        lastId = id;
                    }
                    flagsIndex.set(i, j);
                    int flag = flags.getInt(flagsIndex);
                    switch (flag & 3) {
                        case 0: {
                            x.add(id);
                            continue block6;
                        }
                        case 1: {
                            y.add(id);
                            continue block6;
                        }
                        case 2: 
                        case 3: {
                            xy.add(id);
                        }
                    }
                }
            }
            Dimension snapshotDimension = this.netcdfFile.findDimension("n_snapshots");
            int snapshotCount = snapshotDimension.getLength();
            for (int i = 0; i < snapshotCount; ++i) {
                long id = snapshotId.getLong(i);
                if (!all.contains(id)) continue;
                snapshotIndexMap.put(id, i);
            }
            for (String variableName : this.snapshotDataNames) {
                this.arrayCache.get(variableName);
            }
        }
        Family bandDescriptors = Dddb.getInstance().getBandDescriptors(this.typeString);
        List bandDescriptorsList = bandDescriptors.asList();
        List flagDescriptorList = null;
        for (BandDescriptor descriptor : bandDescriptorsList) {
            if (!descriptor.getBandName().equals("RFI_Flags")) continue;
            Family flagDescriptors = descriptor.getFlagDescriptors();
            flagDescriptorList = flagDescriptors.asList();
            break;
        }
        return new SnapshotInfo(snapshotIndexMap, all, x, y, xy, snapshotAreaMap, flagDescriptorList);
    }

    @Override
    public FlagDescriptor[] getBtFlagDescriptors() {
        try {
            this.ensureDataStructuresInitialized();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.flagDescriptors;
    }

    @Override
    public PolarisationModel getPolarisationModel() {
        return new L1cPolarisationModel();
    }

    private void addRotatedFullPoleBands(Product product, Family<BandDescriptor> bandDescriptors, HashMap<String, AbstractValueProvider> valueProviderMap) {
        if (ScienceProductSupport.containsAllRotationBands(product)) {
            BandDescriptor descriptor;
            FPH valueProvider;
            if (ScienceProductSupport.containsBT_XY_FP_Bands(product)) {
                valueProvider = new FPH(product, valueProviderMap, false);
                descriptor = (BandDescriptor)bandDescriptors.getMember("BT_Value_H");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
                valueProvider = new FPV(product, valueProviderMap, false);
                descriptor = (BandDescriptor)bandDescriptors.getMember("BT_Value_V");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
                valueProvider = new FPHVR(product, valueProviderMap, false);
                descriptor = (BandDescriptor)bandDescriptors.getMember("BT_Value_HV_Real");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
                ProductHelper.addVirtualBand((Product)product, (BandDescriptor)((BandDescriptor)bandDescriptors.getMember("Stokes_1")), (String)"(BT_Value_X + BT_Value_Y) / 2.0");
                ProductHelper.addVirtualBand((Product)product, (BandDescriptor)((BandDescriptor)bandDescriptors.getMember("Stokes_2")), (String)"(BT_Value_H - BT_Value_V) / 2.0");
                ProductHelper.addVirtualBand((Product)product, (BandDescriptor)((BandDescriptor)bandDescriptors.getMember("Stokes_3")), (String)"BT_Value_HV_Real");
            }
            if (product.containsBand("BT_Value_XY_Imag")) {
                ProductHelper.addVirtualBand((Product)product, (BandDescriptor)((BandDescriptor)bandDescriptors.getMember("BT_Value_HV_Imag")), (String)"BT_Value_XY_Imag");
            }
            if (ScienceProductSupport.containsAccuracy_XY_FP_Bands(product)) {
                valueProvider = new FPH(product, valueProviderMap, true);
                descriptor = (BandDescriptor)bandDescriptors.getMember("Pixel_Radiometric_Accuracy_H");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
                valueProvider = new FPV(product, valueProviderMap, true);
                descriptor = (BandDescriptor)bandDescriptors.getMember("Pixel_Radiometric_Accuracy_V");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
                valueProvider = new FPHVR(product, valueProviderMap, true);
                descriptor = (BandDescriptor)bandDescriptors.getMember("Pixel_Radiometric_Accuracy_HV");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
            }
            if (product.containsBand("BT_Value_XY_Imag")) {
                ProductHelper.addVirtualBand((Product)product, (BandDescriptor)((BandDescriptor)bandDescriptors.getMember("Stokes_4")), (String)"BT_Value_XY_Imag");
            }
        }
    }

    private void addRotatedDualPoleBands(Product product, Family<BandDescriptor> bandDescriptors, HashMap<String, AbstractValueProvider> valueProviderMap) {
        if (ScienceProductSupport.containsAllRotationBands(product)) {
            BandDescriptor descriptor;
            DPH valueProvider;
            if (ScienceProductSupport.containsBT_XY_Bands(product)) {
                valueProvider = new DPH(product, valueProviderMap, false);
                descriptor = (BandDescriptor)bandDescriptors.getMember("BT_Value_H");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
                valueProvider = new DPV(product, valueProviderMap, false);
                descriptor = (BandDescriptor)bandDescriptors.getMember("BT_Value_V");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
                ProductHelper.addVirtualBand((Product)product, (BandDescriptor)((BandDescriptor)bandDescriptors.getMember("Stokes_1")), (String)"(BT_Value_X + BT_Value_Y) / 2.0");
                ProductHelper.addVirtualBand((Product)product, (BandDescriptor)((BandDescriptor)bandDescriptors.getMember("Stokes_2")), (String)"(BT_Value_H - BT_Value_V) / 2.0");
            }
            if (ScienceProductSupport.containsAccuracy_XY_Bands(product)) {
                valueProvider = new DPH(product, valueProviderMap, true);
                descriptor = (BandDescriptor)bandDescriptors.getMember("Pixel_Radiometric_Accuracy_H");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
                valueProvider = new DPV(product, valueProviderMap, true);
                descriptor = (BandDescriptor)bandDescriptors.getMember("Pixel_Radiometric_Accuracy_V");
                this.addRotatedBand(product, descriptor, (ValueProvider)valueProvider);
            }
        }
    }

    private void addRotatedBand(Product product, BandDescriptor descriptor, ValueProvider valueProvider) {
        if (!descriptor.isVisible()) {
            return;
        }
        Band band = product.addBand(descriptor.getBandName(), 30);
        band.setUnit(descriptor.getUnit());
        band.setDescription(descriptor.getDescription());
        if (descriptor.hasFillValue()) {
            band.setNoDataValueUsed(true);
            band.setNoDataValue(descriptor.getFillValue());
        }
        SmosMultiLevelSource smosMultiLevelSource = new SmosMultiLevelSource((RasterDataNode)band, valueProvider);
        DefaultMultiLevelImage defaultMultiLevelImage = new DefaultMultiLevelImage((MultiLevelSource)smosMultiLevelSource);
        band.setSourceImage((MultiLevelImage)defaultMultiLevelImage);
        band.setImageInfo(ProductHelper.createImageInfo((Band)band, (BandDescriptor)descriptor));
    }
}

