/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import java.awt.geom.Area;
import java.io.IOException;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.ee2netcdf.reader.ArrayCache;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;

public class ScienceFlagsValueProvider
extends AbstractValueProvider {
    private final Area area;
    private final GridPointInfo gridPointInfo;
    private final String variableName;
    private final ArrayCache arrayCache;
    private final BandDescriptor descriptor;
    private final double incidenceAngleScalingFactor;
    private long snapshotId;

    ScienceFlagsValueProvider(ArrayCache arrayCache, String variableName, BandDescriptor descriptor, Area area, GridPointInfo gridPointInfo, double incidenceAngleScalingFactor) {
        this.gridPointInfo = gridPointInfo;
        this.area = area;
        this.variableName = variableName;
        this.arrayCache = arrayCache;
        this.descriptor = descriptor;
        this.incidenceAngleScalingFactor = incidenceAngleScalingFactor;
        this.snapshotId = -1L;
    }

    public Area getArea() {
        return this.area;
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public int getGridPointIndex(int seqnum) {
        return this.gridPointInfo.getGridPointIndex(seqnum);
    }

    public byte getByte(int gridPointIndex) {
        if (this.snapshotId < 0L) {
            return (byte)this.getCombinedFlags(gridPointIndex);
        }
        return (byte)this.getSnapshotValue(gridPointIndex);
    }

    public short getShort(int gridPointIndex) {
        if (this.snapshotId < 0L) {
            return (short)this.getCombinedFlags(gridPointIndex);
        }
        return (short)this.getSnapshotValue(gridPointIndex);
    }

    public int getInt(int gridPointIndex) {
        if (this.snapshotId < 0L) {
            return this.getCombinedFlags(gridPointIndex);
        }
        return this.getSnapshotValue(gridPointIndex);
    }

    public float getFloat(int gridPointIndex) {
        if (this.snapshotId < 0L) {
            return this.getCombinedFlags(gridPointIndex);
        }
        return this.getSnapshotValue(gridPointIndex);
    }

    private int getCombinedFlags(int gridPointIndex) {
        try {
            Array flagDataArray = this.arrayCache.get(this.variableName);
            Array flagsVector = this.extractGridPointVector(gridPointIndex, flagDataArray);
            Index flagsVectorIndex = flagsVector.getIndex();
            Array incidenceAngleArray = this.arrayCache.get("Incidence_Angle");
            Array incidenceAngleVector = this.extractGridPointVector(gridPointIndex, incidenceAngleArray);
            Index angleVectorIndex = incidenceAngleVector.getIndex();
            int combinedFlags = 0;
            boolean hasLower = false;
            boolean hasUpper = false;
            int polarization = this.descriptor.getPolarization();
            int i = 0;
            while ((long)i < flagsVector.getSize()) {
                double incidenceAngle;
                flagsVectorIndex.set(i);
                angleVectorIndex.set(i);
                int flags = flagsVector.getInt(flagsVectorIndex);
                if ((polarization == 4 || polarization == (flags & 3) || (polarization & flags & 2) != 0) && (incidenceAngle = this.incidenceAngleScalingFactor * (double)incidenceAngleVector.getInt(angleVectorIndex)) >= 37.5 && incidenceAngle <= 52.5) {
                    combinedFlags |= flags;
                    if (!hasLower) {
                        boolean bl = hasLower = incidenceAngle <= 42.5;
                    }
                    if (!hasUpper) {
                        hasUpper = incidenceAngle > 42.5;
                    }
                }
                ++i;
            }
            if (hasLower && hasUpper) {
                return combinedFlags;
            }
        }
        catch (IOException | InvalidRangeException throwable) {
            // empty catch block
        }
        return (int)this.descriptor.getFillValue();
    }

    private int getSnapshotValue(int gridPointIndex) {
        try {
            Array flagDataArray = this.arrayCache.get(this.variableName);
            Array flagsVector = this.extractGridPointVector(gridPointIndex, flagDataArray);
            Index flagsVectorIndex = flagsVector.getIndex();
            Array snapshotIdOfPixelArray = this.arrayCache.get("Snapshot_ID_of_Pixel");
            Array snapsotIdVector = this.extractGridPointVector(gridPointIndex, snapshotIdOfPixelArray);
            Index snapshotIndex = snapsotIdVector.getIndex();
            int polarization = this.descriptor.getPolarization();
            int i = 0;
            while ((long)i < flagsVector.getSize()) {
                snapshotIndex.set(i);
                long pixelSnapshotId = snapsotIdVector.getLong(snapshotIndex);
                if (pixelSnapshotId == this.snapshotId) {
                    flagsVectorIndex.set(i);
                    int flags = flagsVector.getInt(flagsVectorIndex);
                    if (polarization == 4 || polarization == (flags & 1) || (polarization & flags & 2) != 0) {
                        return flags;
                    }
                }
                ++i;
            }
        }
        catch (IOException | InvalidRangeException throwable) {
            // empty catch block
        }
        return (int)this.descriptor.getFillValue();
    }

    private Array extractGridPointVector(int gridPointIndex, Array array) throws InvalidRangeException {
        int[] origin = new int[]{gridPointIndex, 0};
        int[] shape = array.getShape();
        shape[0] = 1;
        return array.section(origin, shape);
    }
}

