/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import org.esa.smos.ee2netcdf.reader.BrowseProductSupport;
import org.esa.smos.ee2netcdf.reader.L2ProductSupport;
import org.esa.smos.ee2netcdf.reader.ProductTypeSupport;
import org.esa.smos.ee2netcdf.reader.ScienceProductSupport;
import ucar.nc2.NetcdfFile;

class ProductTypeSupportFactory {
    ProductTypeSupportFactory() {
    }

    static ProductTypeSupport get(String typeString, NetcdfFile netcdfFile) {
        if (typeString == null) {
            throw new IllegalArgumentException("Invalid product type: null");
        }
        if (ProductTypeSupportFactory.isL2Type(typeString)) {
            return new L2ProductSupport(netcdfFile);
        }
        if (ProductTypeSupportFactory.isBrowseType(typeString)) {
            return new BrowseProductSupport(netcdfFile);
        }
        if (ProductTypeSupportFactory.isScienceType(typeString)) {
            return new ScienceProductSupport(netcdfFile, typeString);
        }
        throw new IllegalArgumentException("Invalid product type: '" + typeString + "'");
    }

    private static boolean isBrowseType(String typeString) {
        return typeString.matches("MIR_BW[L|N|S][D|F]1C");
    }

    private static boolean isScienceType(String typeString) {
        return typeString.matches("MIR_SC[L|N|S][D|F]1C");
    }

    private static boolean isL2Type(String typeString) {
        return "MIR_SMUDP2".equalsIgnoreCase(typeString) || "MIR_OSUDP2".equalsIgnoreCase(typeString);
    }
}

