/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.esa.smos.SmosUtils;
import org.esa.smos.ee2netcdf.reader.NetcdfProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public class NetcdfProductReaderPlugin
implements ProductReaderPlugIn {
    private static final String EXTENSION = ".nc";

    public DecodeQualification getDecodeQualification(Object input) {
        File file = input instanceof File ? (File)input : new File(input.toString());
        String fileName = file.getName();
        String extension = FileUtils.getExtension((String)fileName);
        if (!EXTENSION.equals(extension)) {
            return DecodeQualification.UNABLE;
        }
        String fileNameWithHDRExtension = FileUtils.exchangeExtension((String)fileName, (String)".HDR");
        if (SmosUtils.isL1cType((String)fileNameWithHDRExtension) || SmosUtils.isL2Type((String)fileNameWithHDRExtension)) {
            return DecodeQualification.INTENDED;
        }
        if (this.isValidSmosNetCDF(file)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return new Class[]{File.class, String.class};
    }

    public ProductReader createReaderInstance() {
        return new NetcdfProductReader(this);
    }

    public String[] getFormatNames() {
        return new String[]{"SMOS-NC"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{EXTENSION};
    }

    public String getDescription(Locale locale) {
        return "SMOS Data Products in NetCDF Format";
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidSmosNetCDF(File file) {
        NetcdfFile netcdfFile = null;
        try {
            Attribute attribute;
            String fullName;
            netcdfFile = NetcdfFileOpener.open((Object)file.getAbsolutePath());
            if (netcdfFile == null) {
                boolean bl = false;
                return bl;
            }
            List globalAttributes = netcdfFile.getGlobalAttributes();
            Iterator iterator = globalAttributes.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!"total_number_of_grid_points".equalsIgnoreCase(fullName = (attribute = (Attribute)iterator.next()).getFullName()));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (netcdfFile != null) {
                try {
                    netcdfFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

