/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.ee2netcdf.reader;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import org.esa.smos.ObservationPointList;
import org.esa.smos.Point;
import org.esa.smos.PointList;
import org.esa.smos.SmosUtils;
import org.esa.smos.dataio.smos.DggUtils;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.dataio.smos.GridPointInfo;
import org.esa.smos.dataio.smos.PolarisationModel;
import org.esa.smos.dataio.smos.ProductHelper;
import org.esa.smos.dataio.smos.SmosMultiLevelSource;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.dataio.smos.SnapshotInfo;
import org.esa.smos.dataio.smos.dddb.BandDescriptor;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.Family;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.dataio.smos.provider.AbstractValueProvider;
import org.esa.smos.dataio.smos.provider.ValueProvider;
import org.esa.smos.dgg.SmosDgg;
import org.esa.smos.ee2netcdf.AttributeEntry;
import org.esa.smos.ee2netcdf.ExporterUtils;
import org.esa.smos.ee2netcdf.MetadataUtils;
import org.esa.smos.ee2netcdf.reader.ArrayCache;
import org.esa.smos.ee2netcdf.reader.ProductTypeSupport;
import org.esa.smos.ee2netcdf.reader.ProductTypeSupportFactory;
import org.esa.smos.lsmask.SmosLsMask;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NetcdfProductReader
extends SmosReader {
    private static final String SENSING_TIMES_PATTERN = "'UTC='yyyy-MM-dd'T'HH:mm:ss";
    private static final String LSMASK_SCHEMA_NAME = "DBL_SM_XXXX_AUX_LSMASK_0200";
    private static final String FILE_TYPE_ATTRIBUTE_NAME = "Fixed_Header:File_Type";
    private final HashMap<String, AbstractValueProvider> valueProviderMap = new HashMap();
    private NetcdfFile netcdfFile;
    private ProductTypeSupport typeSupport;
    private GridPointInfo gridPointInfo;
    private boolean isL2Type;
    private List<AttributeEntry> globalAttributeList;

    NetcdfProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    static String getSchemaDescription(NetcdfFile netcdfFile) throws IOException {
        String replacement;
        String schemaAttributeName = "Variable_Header:Specific_Product_Header:Main_Info:Datablock_Schema";
        Attribute schemaAttribute = netcdfFile.findGlobalAttribute("Variable_Header:Specific_Product_Header:Main_Info:Datablock_Schema");
        if (schemaAttribute == null && (schemaAttribute = netcdfFile.findGlobalAttribute(replacement = MetadataUtils.getReplacement("Variable_Header:Specific_Product_Header:Main_Info:Datablock_Schema"))) == null) {
            throw new IOException("Schema attribute not found.");
        }
        String schemaValue = schemaAttribute.getStringValue();
        if (StringUtils.isNullOrEmpty((String)schemaValue)) {
            throw new IOException("Schema attribute is empty.");
        }
        return schemaValue.substring(0, 27);
    }

    public boolean canSupplyGridPointBtData() {
        if (this.typeSupport == null) {
            return false;
        }
        return this.typeSupport.canSupplyGridPointBtData();
    }

    public boolean canSupplyFullPolData() {
        if (this.typeSupport == null) {
            return false;
        }
        return this.typeSupport.canSupplyFullPolData();
    }

    public GridPointBtDataset getBtData(int gridPointIndex) throws IOException {
        if (this.typeSupport == null) {
            return null;
        }
        return this.typeSupport.getBtData(gridPointIndex);
    }

    public int getGridPointIndex(int gridPointId) {
        if (this.gridPointInfo == null) {
            return -1;
        }
        return this.gridPointInfo.getGridPointIndex(gridPointId);
    }

    public int getGridPointId(int levelPixelX, int levelPixelY, int currentLevel) {
        MultiLevelImage levelImage = SmosDgg.getInstance().getMultiLevelImage();
        RenderedImage image = levelImage.getImage(currentLevel);
        Raster data = image.getData(new Rectangle(levelPixelX, levelPixelY, 1, 1));
        return data.getSample(levelPixelX, levelPixelY, 0);
    }

    public String[] getRawDataTableNames() {
        if (this.typeSupport == null) {
            return null;
        }
        return this.typeSupport.getRawDataTableNames();
    }

    public FlagDescriptor[] getBtFlagDescriptors() {
        if (this.typeSupport == null) {
            return null;
        }
        return this.typeSupport.getBtFlagDescriptors();
    }

    public PolarisationModel getPolarisationModel() {
        if (this.typeSupport == null) {
            return null;
        }
        return this.typeSupport.getPolarisationModel();
    }

    public boolean canSupplySnapshotData() {
        if (this.typeSupport == null) {
            return false;
        }
        return this.typeSupport.canSupplySnapshotData();
    }

    public boolean hasSnapshotInfo() {
        if (this.typeSupport == null) {
            return false;
        }
        return this.typeSupport.hasSnapshotInfo();
    }

    public SnapshotInfo getSnapshotInfo() {
        if (this.typeSupport == null) {
            return null;
        }
        try {
            return this.typeSupport.getSnapshotInfo();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object[][] getSnapshotData(int snapshotIndex) {
        if (this.typeSupport == null) {
            return new Object[0][];
        }
        return this.typeSupport.getSnapshotData(snapshotIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Product readProductNodesImpl() throws IOException {
        Product product;
        File inputFile = this.getInputFile();
        this.netcdfFile = NetcdfFileOpener.open((Object)inputFile.getAbsolutePath());
        if (this.netcdfFile == null) {
            throw new IOException("Unable to read file");
        }
        String fileNameWithHDRExtension = FileUtils.exchangeExtension((String)inputFile.getName(), (String)".HDR");
        this.isL2Type = SmosUtils.isL2Type((String)fileNameWithHDRExtension);
        NetcdfFile netcdfFile = this.netcdfFile;
        synchronized (netcdfFile) {
            ArrayCache arrayCache = new ArrayCache(this.netcdfFile);
            String productType = this.getProductTypeString();
            this.typeSupport = ProductTypeSupportFactory.get(productType, this.netcdfFile);
            if (!this.typeSupport.canOpenFile()) {
                throw new IOException("Incomplete SMOS file, unable to handle correctly.");
            }
            List globalAttributes = this.netcdfFile.getGlobalAttributes();
            boolean shrinkedAttributes = MetadataUtils.hasShrinkedAttributes(globalAttributes);
            this.globalAttributeList = MetadataUtils.convertNetcdfAttributes(globalAttributes, this.isL2Type && shrinkedAttributes);
            product = ProductHelper.createProduct((File)inputFile, (String)productType);
            product.setProductReader((ProductReader)this);
            this.addSensingTimes(product);
            MetadataUtils.parseMetadata(this.globalAttributeList, product.getMetadataRoot());
            Area area = this.calculateArea(this.typeSupport);
            this.gridPointInfo = this.calculateGridPointInfo();
            String schemaDescription = NetcdfProductReader.getSchemaDescription(this.netcdfFile);
            Dddb dddb = Dddb.getInstance();
            Family bandDescriptors = dddb.getBandDescriptors(schemaDescription);
            if (bandDescriptors == null) {
                throw new IOException("Unsupported file schema: '" + schemaDescription + "`");
            }
            this.typeSupport.initialize((Family<BandDescriptor>)bandDescriptors);
            for (BandDescriptor descriptor : bandDescriptors.asList()) {
                String eeVariableName;
                String ncVariableName;
                Variable variable;
                if (!descriptor.isVisible() || (variable = this.netcdfFile.findVariable(null, ncVariableName = ExporterUtils.ensureNetCDFName(eeVariableName = dddb.getEEVariableName(descriptor.getMemberName(), schemaDescription)))) == null) continue;
                int rasterDataType = DataTypeUtils.getRasterDataType((Variable)variable);
                Band band = product.addBand(descriptor.getBandName(), rasterDataType);
                this.typeSupport.setScalingAndOffset(band, descriptor);
                if (descriptor.hasFillValue()) {
                    band.setNoDataValueUsed(true);
                    band.setNoDataValue(descriptor.getFillValue());
                }
                if (!descriptor.getValidPixelExpression().isEmpty()) {
                    band.setValidPixelExpression(descriptor.getValidPixelExpression());
                }
                if (!descriptor.getUnit().isEmpty()) {
                    band.setUnit(descriptor.getUnit());
                }
                if (!descriptor.getDescription().isEmpty()) {
                    band.setDescription(descriptor.getDescription());
                }
                if (descriptor.getFlagDescriptors() != null) {
                    ProductHelper.addFlagsAndMasks((Product)product, (Band)band, (String)descriptor.getFlagCodingName(), (Family)descriptor.getFlagDescriptors());
                }
                AbstractValueProvider valueProvider = this.typeSupport.createValueProvider(arrayCache, ncVariableName, descriptor, area, this.gridPointInfo);
                SmosMultiLevelSource smosMultiLevelSource = new SmosMultiLevelSource((RasterDataNode)band, (ValueProvider)valueProvider);
                DefaultMultiLevelImage defaultMultiLevelImage = new DefaultMultiLevelImage((MultiLevelSource)smosMultiLevelSource);
                band.setSourceImage((MultiLevelImage)defaultMultiLevelImage);
                NetcdfProductReader.calculateMinMaxIfMissing(variable, descriptor);
                band.setImageInfo(ProductHelper.createImageInfo((Band)band, (BandDescriptor)descriptor));
                this.valueProviderMap.put(descriptor.getBandName(), valueProvider);
            }
            this.addLandSeaMask(product);
            this.typeSupport.createAdditionalBands(product, area, (Family<BandDescriptor>)bandDescriptors, schemaDescription, this.valueProviderMap);
            this.typeSupport.setArrayCache(arrayCache);
            this.typeSupport.setGridPointInfo(this.gridPointInfo);
        }
        return product;
    }

    static void calculateMinMaxIfMissing(Variable variable, BandDescriptor descriptor) throws IOException {
        boolean hasMin = descriptor.hasTypicalMin();
        boolean hasMax = descriptor.hasTypicalMax();
        if (hasMin && hasMax) {
            return;
        }
        Array array = variable.read();
        int size = (int)array.getSize();
        double fillValue = Double.NaN;
        if (descriptor.hasFillValue()) {
            fillValue = descriptor.getFillValue();
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < size; ++i) {
            double value = array.getDouble(i);
            if (Math.abs(value - fillValue) < 1.0E-8) continue;
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        if (!hasMin) {
            descriptor.setTypicalMin(min);
        }
        if (!hasMax) {
            descriptor.setTypicalMax(max);
        }
    }

    private String getProductTypeString() throws IOException {
        Attribute fileTypeAttrbute = this.netcdfFile.findGlobalAttribute(FILE_TYPE_ATTRIBUTE_NAME);
        if (fileTypeAttrbute == null) {
            if (this.isL2Type) {
                String fileTypeAttribName = MetadataUtils.getReplacement(FILE_TYPE_ATTRIBUTE_NAME);
                fileTypeAttrbute = this.netcdfFile.findGlobalAttribute(fileTypeAttribName);
            }
            if (fileTypeAttrbute == null) {
                throw new IOException("Required attribute `Fixed_Header:File_Type` not found");
            }
        }
        return fileTypeAttrbute.getStringValue();
    }

    private void addSensingTimes(Product product) throws IOException {
        String sensingStartUTC = this.getGlobalAttributeValue("Fixed_Header:Validity_Period:Validity_Start");
        String sensingStopUTC = this.getGlobalAttributeValue("Fixed_Header:Validity_Period:Validity_Stop");
        try {
            product.setStartTime(ProductData.UTC.parse((String)sensingStartUTC, (String)SENSING_TIMES_PATTERN));
            product.setEndTime(ProductData.UTC.parse((String)sensingStopUTC, (String)SENSING_TIMES_PATTERN));
        }
        catch (ParseException e) {
            System.out.println("e.getMessage() = " + e.getMessage());
            e.printStackTrace();
        }
    }

    private GridPointInfo calculateGridPointInfo() throws IOException {
        Variable gridPointIdVariable = this.netcdfFile.findVariable(null, "Grid_Point_ID");
        if (gridPointIdVariable == null) {
            throw new IOException("Required variable 'Grid_Point_ID' missing, Unable to open product");
        }
        Array gridPointIdArray = gridPointIdVariable.read();
        int[] shape = gridPointIdArray.getShape();
        int minSeqNum = Integer.MAX_VALUE;
        int maxSeqNum = Integer.MIN_VALUE;
        int[] seqNumbers = new int[shape[0]];
        for (int i = 0; i < shape[0]; ++i) {
            int seqnum;
            int gridPointId = gridPointIdArray.getInt(i);
            seqNumbers[i] = seqnum = SmosDgg.gridPointIdToSeqnum((int)gridPointId);
            if (seqnum < minSeqNum) {
                minSeqNum = seqnum;
            }
            if (seqnum <= maxSeqNum) continue;
            maxSeqNum = seqnum;
        }
        GridPointInfo gridPointInfo = new GridPointInfo(minSeqNum, maxSeqNum);
        gridPointInfo.setSequenceNumbers(seqNumbers);
        return gridPointInfo;
    }

    private Area calculateArea(ProductTypeSupport productTypeSupport) throws IOException {
        Variable latitude = this.netcdfFile.findVariable(null, productTypeSupport.getLatitudeBandName());
        Variable longitude = this.netcdfFile.findVariable(null, productTypeSupport.getLongitudeBandName());
        if (latitude == null || longitude == null) {
            throw new IOException("Missing geo location variables");
        }
        Array latitudeArray = latitude.read();
        Array longitudeArray = longitude.read();
        int[] shape = longitudeArray.getShape();
        Point[] pointArray = new Point[shape[0]];
        for (int i = 0; i < shape[0]; ++i) {
            pointArray[i] = new Point(longitudeArray.getDouble(i), latitudeArray.getDouble(i));
        }
        return DggUtils.computeArea((PointList)new ObservationPointList(pointArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band targetBand, int targetOffsetX, int targetOffsetY, int targetWidth, int targetHeight, ProductData targetBuffer, ProgressMonitor pm) {
        NetcdfFile netcdfFile = this.netcdfFile;
        synchronized (netcdfFile) {
            MultiLevelImage image = targetBand.getSourceImage();
            Raster data = image.getData(new Rectangle(targetOffsetX, targetOffsetY, targetWidth, targetHeight));
            data.getDataElements(targetOffsetX, targetOffsetY, targetWidth, targetHeight, targetBuffer.getElems());
        }
    }

    public void close() throws IOException {
        if (this.netcdfFile != null) {
            this.netcdfFile.close();
            this.netcdfFile = null;
        }
    }

    private void addLandSeaMask(Product product) {
        BandDescriptor descriptor = (BandDescriptor)Dddb.getInstance().getBandDescriptors(LSMASK_SCHEMA_NAME).getMember("Land_Sea_Mask");
        Band band = product.addBand(descriptor.getBandName(), 20);
        band.setScalingOffset(descriptor.getScalingOffset());
        band.setScalingFactor(descriptor.getScalingFactor());
        if (descriptor.hasFillValue()) {
            band.setNoDataValueUsed(true);
            band.setNoDataValue(descriptor.getFillValue());
        }
        if (!descriptor.getValidPixelExpression().isEmpty()) {
            band.setValidPixelExpression(descriptor.getValidPixelExpression());
        }
        if (!descriptor.getUnit().isEmpty()) {
            band.setUnit(descriptor.getUnit());
        }
        if (!descriptor.getDescription().isEmpty()) {
            band.setDescription(descriptor.getDescription());
        }
        if (descriptor.getFlagDescriptors() != null) {
            ProductHelper.addFlagsAndMasks((Product)product, (Band)band, (String)descriptor.getFlagCodingName(), (Family)descriptor.getFlagDescriptors());
        }
        band.setSourceImage(SmosLsMask.getInstance().getMultiLevelImage());
        band.setImageInfo(ProductHelper.createImageInfo((Band)band, (BandDescriptor)descriptor));
    }

    private String getGlobalAttributeValue(String key) throws IOException {
        for (AttributeEntry entry : this.globalAttributeList) {
            if (!entry.getName().equals(key)) continue;
            return entry.getValue();
        }
        throw new IOException("Global attribute '" + key + "' not found.");
    }
}

